/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.data;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.Long2IntAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;

public abstract class ArrivalsCache {
    private long nextRequest;
    private final Long2IntAVLTreeMap queuedPlatformIdsWithAge = new Long2IntAVLTreeMap();
    private final ObjectArrayList<ArrivalResponse> arrivalResponseCache = new ObjectArrayList();
    private final int cachedMillis;
    private static final int PERSISTENT_AGE = 5;

    protected ArrivalsCache(int cachedMillis) {
        this.cachedMillis = cachedMillis;
    }

    public final ObjectArrayList<ArrivalResponse> requestArrivals(LongCollection platformIds) {
        if (this.queuedPlatformIdsWithAge.isEmpty() && this.canSendRequest()) {
            this.nextRequest = System.currentTimeMillis() + 100L;
        }
        platformIds.forEach(platformId -> this.queuedPlatformIdsWithAge.put(platformId, 0));
        ObjectArrayList<ArrivalResponse> arrivals = new ObjectArrayList<ArrivalResponse>();
        this.arrivalResponseCache.forEach(arrivalResponse -> {
            if (platformIds.contains(arrivalResponse.getPlatformId())) {
                arrivals.add((ArrivalResponse)arrivalResponse);
            }
        });
        return arrivals;
    }

    public final void tick() {
        if (!this.queuedPlatformIdsWithAge.isEmpty() && this.canSendRequest()) {
            LongAVLTreeSet platformIds = new LongAVLTreeSet(this.queuedPlatformIdsWithAge.keySet());
            this.requestArrivalsFromServer(platformIds, arrivalResponseList -> {
                this.arrivalResponseCache.clear();
                this.arrivalResponseCache.addAll((ObjectList<ArrivalResponse>)arrivalResponseList);
            });
            platformIds.forEach(platformId -> this.queuedPlatformIdsWithAge.compute(platformId, (BiFunction<? super Long, ? super Integer, ? extends Integer>)((BiFunction<Long, Integer, Integer>)(key, age) -> age > 5 ? null : Integer.valueOf(age + 1))));
            this.nextRequest = System.currentTimeMillis() + (long)this.cachedMillis;
        }
    }

    private boolean canSendRequest() {
        return System.currentTimeMillis() >= this.nextRequest;
    }

    public abstract long getMillisOffset();

    protected abstract void requestArrivalsFromServer(LongAVLTreeSet var1, Consumer<ObjectList<ArrivalResponse>> var2);
}

