/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.Blocks;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockEyeCandy;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderRails;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderEyeCandy
extends BlockEntityRenderer<BlockEyeCandy.BlockEntity> {
    public RenderEyeCandy(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void render(BlockEyeCandy.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        int newLight;
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)blockEntity.getPos2().getX(), blockEntity.getPos2().getY(), 0.5 + (double)blockEntity.getPos2().getZ());
        int n = newLight = blockEntity.getFullBrightness() ? GraphicsHolder.getDefaultLight() : light;
        if ((RenderRails.isHoldingRailRelated(clientPlayerEntity) || clientPlayerEntity.isHolding(Blocks.EYE_CANDY.get().asItem())) && minecraftClient.getCurrentScreenMapped() == null) {
            MainRenderer.scheduleRender(new Identifier("mtrsteamloco", "textures/item/eye_candy.png"), false, QueuedRenderLayer.INTERIOR, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                graphicsHolderNew.translate(0.0, 0.5, 0.0);
                InitClient.transformToFacePlayer(graphicsHolderNew, (double)blockEntity.getPos2().getX() + 0.5, (double)blockEntity.getPos2().getY() + 0.5, (double)blockEntity.getPos2().getZ() + 0.5);
                graphicsHolderNew.rotateZDegrees(180.0f);
                IDrawing.drawTexture(graphicsHolderNew, -0.5f, -0.5f, 1.0f, 1.0f, Direction.UP, GraphicsHolder.getDefaultLight());
                graphicsHolderNew.pop();
            });
        }
        BlockPos blockPos = blockEntity.getPos2();
        Direction facing = IBlock.getStatePropertySafe(world, blockPos, BlockEyeCandy.FACING);
        String modelId = blockEntity.getModelId();
        if (modelId != null) {
            CustomResourceLoader.getObjectById(modelId, objectResource -> {
                StoredMatrixTransformations storedMatrixTransformationsNew = storedMatrixTransformations.copy();
                storedMatrixTransformationsNew.add(graphicsHolderNew -> {
                    graphicsHolderNew.translate(blockEntity.getTranslateX(), blockEntity.getTranslateY(), blockEntity.getTranslateZ());
                    graphicsHolderNew.rotateYDegrees(180.0f - facing.asRotation());
                    graphicsHolderNew.rotateXRadians(blockEntity.getRotateX() + (float)Math.PI);
                    graphicsHolderNew.rotateYRadians(blockEntity.getRotateY());
                    graphicsHolderNew.rotateZRadians(blockEntity.getRotateZ());
                });
                objectResource.render(storedMatrixTransformationsNew, newLight);
            });
        }
    }

    @Override
    public boolean isInRenderDistance(BlockEyeCandy.BlockEntity blockEntity, Vector3d position) {
        return true;
    }
}

