/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.OrderedText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Util;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.IGui;

public class BetaWarningScreen
extends ScreenExtension
implements IGui,
Utilities {
    private final ButtonWidgetExtension buttonPatreon = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("Support this mod on Patreon"), button -> Util.getOperatingSystem().open("https://www.patreon.com/minecraft_transit_railway"));
    private final ButtonWidgetExtension buttonYouTube = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("Subscribe on YouTube"), button -> Util.getOperatingSystem().open("https://www.youtube.com/@JonathanHo33"));
    private static long openTime;
    private static long lastMillis;
    private static final int BUTTON_WIDTH = 160;
    private static final int FORCE_OPEN_DURATION = 20000;

    @Override
    protected void init2() {
        super.init2();
        IDrawing.setPositionAndWidth(this.buttonPatreon, this.f_96543_ / 2 - 10 - 160, this.f_96544_ - 40, 160);
        IDrawing.setPositionAndWidth(this.buttonYouTube, this.f_96543_ / 2 + 10, this.f_96544_ - 40, 160);
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonPatreon));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonYouTube));
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        super.render(graphicsHolder, mouseX, mouseY, delta);
        graphicsHolder.push();
        graphicsHolder.translate((float)this.f_96543_ / 2.0f, 20.0, 0.0);
        graphicsHolder.scale(2.0f, 2.0f, 1.0f);
        graphicsHolder.drawCenteredText("Minecraft Transit Railway 4.0.0", 0, 0, -1);
        graphicsHolder.pop();
        int i = 40;
        graphicsHolder.drawCenteredText("Please back up your worlds before continuing!", this.f_96543_ / 2, i += 8, System.currentTimeMillis() % 1000L < 500L ? 0xFFFF00 : 0xFF9900);
        i = this.wrapAndRender(graphicsHolder, "- We are very close to the official release of 4.0.0. Please report any bugs you find!", i + 20);
        i = this.wrapAndRender(graphicsHolder, "- If you find any issues with the Resource Pack Creator, please let me know.", i);
        i = this.wrapAndRender(graphicsHolder, "- Manual driving still has NOT been implemented yet!", i);
        graphicsHolder.drawCenteredText("Thank you and enjoy :)", this.f_96543_ / 2, i, -1);
        graphicsHolder.push();
        graphicsHolder.translate((float)this.f_96543_ / 2.0f, (float)(i + 8) + 3.0f, 0.0);
        graphicsHolder.scale(0.5f, 0.5f, 1.0f);
        graphicsHolder.drawCenteredText(openTime < 20000L ? String.format("Please read the above carefully to continue! (%s)", (20000L - openTime) / 1000L) : "Press ESC to continue", 0, 0, -1);
        graphicsHolder.pop();
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingTexture(new Identifier("mtr", "textures/gui/patreon.png"));
        guiDrawing.drawTexture((float)this.f_96543_ / 2.0f - 80.0f - 20.0f, this.f_96544_ - 60 - 6, (float)this.f_96543_ / 2.0f - 80.0f, this.f_96544_ - 40 - 6, 0.0f, 0.0f, 1.0f, 1.0f);
        guiDrawing.finishDrawingTexture();
        guiDrawing.beginDrawingTexture(new Identifier("mtr", "textures/gui/youtube.png"));
        float youTubeIconPadding = 4.0625f;
        guiDrawing.drawTexture((float)this.f_96543_ / 2.0f + 80.0f - 4.0625f, this.f_96544_ - 60 - 6, (float)this.f_96543_ / 2.0f + 80.0f + 20.0f + 4.0625f, this.f_96544_ - 40 - 6, 0.0f, 0.0f, 1.0f, 1.0f);
        guiDrawing.finishDrawingTexture();
    }

    @Override
    public void tick2() {
        super.tick2();
        if (openTime < 20000L) {
            long currentMillis = System.currentTimeMillis();
            if (lastMillis > 0L) {
                openTime += currentMillis - lastMillis;
            }
            lastMillis = currentMillis;
        }
    }

    @Override
    public void onClose2() {
        if (openTime >= 20000L) {
            Config.getClient().hideBetaWarningScreen();
            Config.save();
            super.onClose2();
        }
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    private int wrapAndRender(GraphicsHolder graphicsHolder, String text, int y) {
        int textWidth = Math.min(512, this.f_96543_ - 40);
        int[] newY = new int[]{y};
        GraphicsHolder.wrapLines(new MutableText((MutableComponent)TextHelper.literal((String)text).data), textWidth).forEach(orderedText -> {
            graphicsHolder.drawText((OrderedText)orderedText, (this.f_96543_ - textWidth) / 2 + (newY[0] == y ? 0 : 10), newY[0], -5592406, true, GraphicsHolder.getDefaultLight());
            newY[0] = newY[0] + 11;
        });
        return newY[0] + 9;
    }

    public static void handle() {
        if (openTime < 20000L && Config.getClient().showBetaWarningScreen()) {
            Screen screen = MinecraftClient.getInstance().getCurrentScreenMapped();
            if (screen != null && ((Component)screen.getTitle().data).toString().contains("narrator.screen.title")) {
                MinecraftClient.getInstance().openScreen(new Screen(new BetaWarningScreen()));
            }
        } else {
            openTime = 20000L;
        }
    }
}

