/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3797;
import org.apache.commons.io.IOUtils;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.tool.DummyClass;

public final class ResourceManagerHelper
extends DummyClass {
    @MappedMethod
    public static void readResource(Identifier identifier, Consumer<InputStream> consumer) {
        try {
            ResourceManagerHelper.readResource(class_310.method_1551().method_1478().method_14486((class_2960)identifier.data), consumer);
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static String readResource(Identifier identifier) {
        String[] string = new String[]{""};
        ResourceManagerHelper.readResource(identifier, (InputStream inputStream2) -> {
            try {
                string[0] = IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                ResourceManagerHelper.logException(e);
            }
        });
        return string[0];
    }

    @MappedMethod
    public static void readAllResources(Identifier identifier, Consumer<InputStream> consumer) {
        try {
            class_310.method_1551().method_1478().method_14489((class_2960)identifier.data).forEach(resource -> ResourceManagerHelper.readResource(resource, consumer));
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static void readDirectory(String path, BiConsumer<Identifier, InputStream> consumer) {
        try {
            class_310.method_1551().method_1478().method_14488(path, identifier -> true).forEach(identifier -> ResourceManagerHelper.readAllResources(new Identifier((class_2960)identifier), inputStream2 -> consumer.accept(new Identifier((class_2960)identifier), (InputStream)inputStream2)));
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    private static void readResource(class_3298 resource, Consumer<InputStream> consumer) {
        try (class_3298 newResource = resource;){
            try (InputStream inputStream2 = newResource.method_14482();){
                consumer.accept(inputStream2);
            }
            catch (Exception e) {
                ResourceManagerHelper.logException(e);
            }
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static int getResourcePackVersion() {
        return class_3797.method_16672().getPackVersion();
    }

    @MappedMethod
    public static int getDataPackVersion() {
        return 0;
    }
}

