/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2769;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.BlockStationNameBase;
import org.mtr.mod.block.IBlock;

public abstract class BlockStationNameTallBase
extends BlockStationNameBase
implements IBlock {
    public static final BooleanProperty METAL = BooleanProperty.of("metal");
    public static final float WIDTH = 0.6875f;
    public static final float HEIGHT = 1.5f;
    public static final float OFFSET_Y = 0.125f;

    public BlockStationNameTallBase() {
        super(Blocks.createDefaultBlockSettings(true));
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            boolean isWhite = IBlock.getStatePropertySafe(state, COLOR) == 0;
            int newColorProperty = isWhite ? 2 : 0;
            boolean newMetalProperty = isWhite == IBlock.getStatePropertySafe(state, METAL);
            BlockStationNameTallBase.updateProperties(world, pos, newMetalProperty, newColorProperty);
            switch ((IBlock.EnumThird)IBlock.getStatePropertySafe(state, THIRD)) {
                case LOWER: {
                    BlockStationNameTallBase.updateProperties(world, pos.up(), newMetalProperty, newColorProperty);
                    BlockStationNameTallBase.updateProperties(world, pos.up(2), newMetalProperty, newColorProperty);
                    break;
                }
                case MIDDLE: {
                    BlockStationNameTallBase.updateProperties(world, pos.down(), newMetalProperty, newColorProperty);
                    BlockStationNameTallBase.updateProperties(world, pos.up(), newMetalProperty, newColorProperty);
                    break;
                }
                case UPPER: {
                    BlockStationNameTallBase.updateProperties(world, pos.down(), newMetalProperty, newColorProperty);
                    BlockStationNameTallBase.updateProperties(world, pos.down(2), newMetalProperty, newColorProperty);
                }
            }
        });
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if ((direction == Direction.UP && IBlock.getStatePropertySafe(state, THIRD) != IBlock.EnumThird.UPPER || direction == Direction.DOWN && IBlock.getStatePropertySafe(state, THIRD) != IBlock.EnumThird.LOWER) && !neighborState.isOf(new Block(this))) {
            return org.mtr.mapping.holder.Blocks.getAirMapped().getDefaultState();
        }
        return state;
    }

    @Override
    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        switch ((IBlock.EnumThird)IBlock.getStatePropertySafe(state, THIRD)) {
            case MIDDLE: {
                IBlock.onBreakCreative(world, player, pos.down());
                break;
            }
            case UPPER: {
                IBlock.onBreakCreative(world, player, pos.down(2));
            }
        }
        super.onBreak2(world, pos, state, player);
    }

    @Override
    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClient()) {
            Direction facing = IBlock.getStatePropertySafe(state, FACING);
            world.setBlockState(pos.up(), this.getDefaultState2().with(new Property((class_2769)BlockStationNameTallBase.FACING.data), facing.data).with(new Property((class_2769)BlockStationNameTallBase.METAL.data), true).with(new Property((class_2769)BlockStationNameTallBase.THIRD.data), IBlock.EnumThird.MIDDLE), 3);
            world.setBlockState(pos.up(2), this.getDefaultState2().with(new Property((class_2769)BlockStationNameTallBase.FACING.data), facing.data).with(new Property((class_2769)BlockStationNameTallBase.METAL.data), true).with(new Property((class_2769)BlockStationNameTallBase.THIRD.data), IBlock.EnumThird.UPPER), 3);
            world.updateNeighbors(pos, org.mtr.mapping.holder.Blocks.getAirMapped());
            state.updateNeighbors(new WorldAccess((class_1936)world.data), pos, 3);
        }
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(COLOR);
        properties.add(FACING);
        properties.add(METAL);
        properties.add(THIRD);
    }

    protected static ImmutablePair<Integer, Integer> getBounds(BlockState state) {
        int end;
        int start;
        IBlock.EnumThird third = (IBlock.EnumThird)IBlock.getStatePropertySafe(state, THIRD);
        switch (third) {
            case LOWER: {
                start = 10;
                end = 16;
                break;
            }
            case UPPER: {
                start = 0;
                end = 8;
                break;
            }
            default: {
                start = 0;
                end = 16;
            }
        }
        return new ImmutablePair((Object)start, (Object)end);
    }

    private static void updateProperties(World world, BlockPos pos, boolean metalProperty, int colorProperty) {
        world.setBlockState(pos, world.getBlockState(pos).with(new Property((class_2769)BlockStationNameTallBase.COLOR.data), colorProperty).with(new Property((class_2769)BlockStationNameTallBase.METAL.data), metalProperty));
    }

    public static class BlockEntityTallBase
    extends BlockStationNameBase.BlockEntityBase {
        public BlockEntityTallBase(BlockEntityType<?> type, BlockPos pos, BlockState state, float zOffset, boolean isDoubleSided) {
            super(type, pos, state, 0.21875f, zOffset, isDoubleSided);
        }

        @Override
        public int getColor(BlockState state) {
            switch (IBlock.getStatePropertySafe(state, BlockStationNameBase.COLOR)) {
                case 1: {
                    return -5592406;
                }
                case 2: {
                    return -16777216;
                }
            }
            return -1;
        }
    }
}

