/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.config;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.FileUtils;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.com.google.gson.JsonParser;
import org.mtr.mod.Init;
import org.mtr.mod.config.Client;
import org.mtr.mod.config.Server;
import org.mtr.mod.generated.config.ConfigSchema;

public final class Config
extends ConfigSchema {
    private static Config instance;
    private static Path basePath;

    public static void init(File baseFolder) {
        if (instance == null || basePath == null) {
            basePath = baseFolder.toPath();
            try (InputStream inputStream2 = Files.newInputStream(Config.getConfigFilePath(), StandardOpenOption.READ);){
                instance = new Config(new JsonReader(Config.readResource(inputStream2)));
            }
            catch (Exception ignored) {
                instance = new Config(new JsonReader(new JsonObject()));
            }
        }
        Config.save();
    }

    private Config(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonElement readResource(InputStream inputStream2) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, StandardCharsets.UTF_8);){
            JsonElement jsonElement = JsonParser.parseReader(inputStreamReader);
            return jsonElement;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return new JsonObject();
        }
    }

    public static Client getClient() {
        return instance == null ? new Client(new JsonReader(new JsonObject())) : Config.instance.client;
    }

    public static Server getServer() {
        return instance == null ? new Server(new JsonReader(new JsonObject())) : Config.instance.server;
    }

    public static void save() {
        try {
            FileUtils.write((File)Config.getConfigFilePath().toFile(), (CharSequence)Utilities.prettyPrint(Utilities.getJsonObjectFromData(instance)), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    private static Path getConfigFilePath() {
        return basePath == null ? Paths.get("", new String[0]) : basePath.resolve("config/mtr.json");
    }
}

