/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.data;

import java.util.function.Supplier;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.VehicleCar;
import org.mtr.core.data.VehicleExtraData;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mod.client.Oscillation;
import org.mtr.mod.client.ScrollingText;
import org.mtr.mod.resource.DoorAnimationType;
import org.mtr.mod.resource.Interpolation;
import org.mtr.mod.resource.VehicleResource;
import org.mtr.mod.sound.VehicleSoundBase;

public final class PersistentVehicleData {
    private double smoothedRailProgress;
    private double railProgressSmoothingAdjustment;
    private double doorValue;
    private double oldDoorValue;
    private double nextAnnouncementRailProgress;
    private int doorCooldown;
    private int overrideDoorMultiplier;
    public final boolean[] rayTracing;
    public final double[] longestDimensions;
    private final TransportMode transportMode;
    private final ObjectArrayList<VehicleSoundBase> vehicleSoundBaseList = new ObjectArrayList();
    private final ObjectArrayList<ObjectArrayList<ScrollingText>> scrollingTexts = new ObjectArrayList();
    private final ObjectArrayList<Oscillation> oscillations = new ObjectArrayList();
    private final Object2ObjectOpenHashMap<String, DoorMovementInterpolation> doorMovementInterpolations = new Object2ObjectOpenHashMap();

    public PersistentVehicleData(ObjectImmutableList<VehicleCar> immutableVehicleCars, TransportMode transportMode) {
        this.rayTracing = new boolean[immutableVehicleCars.size()];
        this.longestDimensions = new double[immutableVehicleCars.size()];
        for (int i = 0; i < immutableVehicleCars.size(); ++i) {
            this.longestDimensions[i] = Math.max(immutableVehicleCars.get(i).getLength(), immutableVehicleCars.get(i).getWidth());
        }
        this.transportMode = transportMode;
    }

    public void update(double newRailProgress, double totalVehicleLength) {
        this.railProgressSmoothingAdjustment = newRailProgress - this.smoothedRailProgress;
        if (Math.abs(this.railProgressSmoothingAdjustment) > totalVehicleLength - 1.0) {
            this.railProgressSmoothingAdjustment = 0.0;
        }
    }

    public double getSmoothedRailProgress(double railProgress, double adjustmentAmount) {
        if (this.railProgressSmoothingAdjustment > 0.0) {
            this.railProgressSmoothingAdjustment = Math.max(this.railProgressSmoothingAdjustment - adjustmentAmount, 0.0);
        } else if (this.railProgressSmoothingAdjustment < 0.0) {
            this.railProgressSmoothingAdjustment = Math.min(this.railProgressSmoothingAdjustment + adjustmentAmount, 0.0);
        }
        this.smoothedRailProgress = railProgress - this.railProgressSmoothingAdjustment;
        return this.smoothedRailProgress;
    }

    public ObjectArrayList<ScrollingText> getScrollingText(int carNumber) {
        return PersistentVehicleData.getElement(this.scrollingTexts, carNumber, ObjectArrayList::new);
    }

    public Oscillation getOscillation(int carNumber) {
        return PersistentVehicleData.getElement(this.oscillations, carNumber, () -> new Oscillation(this.transportMode));
    }

    public void tick(double railProgress, long millisElapsed, VehicleExtraData vehicleExtraData) {
        this.oldDoorValue = this.doorValue;
        this.doorValue = Utilities.clamp(this.doorValue + (double)(millisElapsed * (long)this.getAdjustedDoorMultiplier(vehicleExtraData)) / 3200.0, 0.0, 1.0);
        if (this.checkCanOpenDoors()) {
            --this.doorCooldown;
        } else {
            this.overrideDoorMultiplier = 0;
        }
        if (this.doorValue > 0.0) {
            this.doorCooldown = 2;
            this.nextAnnouncementRailProgress = railProgress + vehicleExtraData.getTotalVehicleLength() * 1.5;
        }
        this.oscillations.forEach(oscillation -> oscillation.tick(millisElapsed));
    }

    public double getDoorValue() {
        return this.doorValue;
    }

    public float getInterpolatedDoorValue(DoorAnimationType doorAnimationType, double doorZMultiplier, boolean flipped, double doorOverrideValue, boolean opening) {
        float interpolatedDoorValue;
        String key = doorZMultiplier + "_" + (Object)((Object)doorAnimationType) + "_" + flipped;
        DoorMovementInterpolation doorMovementInterpolation = this.doorMovementInterpolations.get(key);
        double value = doorAnimationType.getDoorAnimationZ(doorZMultiplier, flipped, this.doorValue, opening);
        if (doorMovementInterpolation == null) {
            DoorMovementInterpolation newDoorMovementInterpolation = new DoorMovementInterpolation();
            this.doorMovementInterpolations.put(key, newDoorMovementInterpolation);
            interpolatedDoorValue = newDoorMovementInterpolation.setAndGet(value, opening);
        } else {
            interpolatedDoorValue = doorMovementInterpolation.setAndGet(value, opening);
        }
        float newDoorOverrideValue = (float)(doorOverrideValue * doorZMultiplier) * (float)(flipped ? -1 : 1);
        return Math.abs(newDoorOverrideValue) > Math.abs(interpolatedDoorValue) ? newDoorOverrideValue : interpolatedDoorValue;
    }

    public boolean checkCanOpenDoors() {
        return this.doorCooldown > 0;
    }

    public int getAdjustedDoorMultiplier(VehicleExtraData vehicleExtraData) {
        return this.overrideDoorMultiplier != 0 ? this.overrideDoorMultiplier : vehicleExtraData.getDoorMultiplier();
    }

    public void overrideDoorMultiplier(int overrideDoorMultiplier) {
        this.overrideDoorMultiplier = overrideDoorMultiplier;
    }

    public boolean canAnnounce(double oldRailProgress, double railProgress) {
        return oldRailProgress < this.nextAnnouncementRailProgress && railProgress >= this.nextAnnouncementRailProgress;
    }

    public void playMotorSound(VehicleResource vehicleResource, int carNumber, BlockPos bogiePosition, float speed, float speedChange, float acceleration, boolean isOnRoute) {
        this.getVehicleSoundBase(vehicleResource, carNumber).playMotorSound(bogiePosition, speed, speedChange, acceleration, isOnRoute);
    }

    public void playDoorSound(VehicleResource vehicleResource, int carNumber, BlockPos vehiclePosition) {
        this.getVehicleSoundBase(vehicleResource, carNumber).playDoorSound(vehiclePosition, this.doorValue, this.oldDoorValue);
    }

    private VehicleSoundBase getVehicleSoundBase(VehicleResource vehicleResource, int carNumber) {
        return PersistentVehicleData.getElement(this.vehicleSoundBaseList, carNumber, vehicleResource.createVehicleSoundBase);
    }

    public void dispose() {
        for (VehicleSoundBase sounds : this.vehicleSoundBaseList) {
            sounds.dispose();
        }
    }

    private static <T> T getElement(ObjectArrayList<T> list, int index, Supplier<T> supplier) {
        while (list.size() <= index) {
            list.add(supplier.get());
        }
        return list.get(index);
    }

    private static class DoorMovementInterpolation {
        private boolean opening;
        private final Interpolation interpolation = new Interpolation(500);

        private DoorMovementInterpolation() {
        }

        private float setAndGet(double value, boolean opening) {
            this.interpolation.setValue(value, this.opening != opening);
            this.opening = opening;
            return (float)this.interpolation.getValue();
        }
    }
}

