/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.data;

import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.mtr.core.data.Data;
import org.mtr.core.data.PathData;
import org.mtr.core.data.Vehicle;
import org.mtr.core.data.VehicleCar;
import org.mtr.core.operation.VehicleUpdate;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.tool.Utilities;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.doubles.DoubleObjectImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Style;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.TextColor;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockTrainAnnouncer;
import org.mtr.mod.block.BlockTrainRedstoneSensor;
import org.mtr.mod.block.BlockTrainSensorBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.client.VehicleRidingMovement;
import org.mtr.mod.data.IGui;
import org.mtr.mod.data.PersistentVehicleData;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketCheckRouteIdHasDisabledAnnouncements;
import org.mtr.mod.packet.PacketTurnOnBlockEntity;
import org.mtr.mod.render.DrivingGuiRenderer;
import org.mtr.mod.resource.VehicleResource;

public class VehicleExtension
extends Vehicle
implements Utilities {
    private double oldSpeed;
    private int speedLimitKilometersPerHour;
    @Nullable
    private DoubleObjectImmutablePair<DoubleDoubleImmutablePair> platformStoppingDetails;
    public final PersistentVehicleData persistentVehicleData;

    public VehicleExtension(VehicleUpdate vehicleUpdate, Data data) {
        super(vehicleUpdate.getVehicleExtraData(), null, new JsonReader(Utilities.getJsonObjectFromData(vehicleUpdate.getVehicle())), data);
        PersistentVehicleData tempPersistentVehicleData = MinecraftClientData.getInstance().vehicleIdToPersistentVehicleData.get(this.getId());
        if (tempPersistentVehicleData == null) {
            this.persistentVehicleData = new PersistentVehicleData(this.vehicleExtraData.immutableVehicleCars, this.getTransportMode());
            MinecraftClientData.getInstance().vehicleIdToPersistentVehicleData.put(this.getId(), this.persistentVehicleData);
        } else {
            this.persistentVehicleData = tempPersistentVehicleData;
            this.persistentVehicleData.update(this.railProgress, this.vehicleExtraData.getTotalVehicleLength());
        }
    }

    public void updateData(@Nullable JsonObject jsonObject) {
        if (jsonObject != null) {
            this.updateData(new JsonReader(jsonObject.getAsJsonObject("vehicle")));
            this.vehicleExtraData.updateData(new JsonReader(jsonObject.getAsJsonObject("data")));
        }
    }

    public void simulate(long millisElapsed) {
        double oldRailProgress = this.railProgress;
        this.oldSpeed = this.speed;
        this.simulate(millisElapsed, null, null);
        this.persistentVehicleData.tick(this.railProgress, millisElapsed, this.vehicleExtraData);
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientWorld clientWorld = minecraftClient.getWorldMapped();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientWorld == null || clientPlayerEntity == null) {
            return;
        }
        int thisRouteColor = this.vehicleExtraData.getThisRouteColor();
        String thisRouteName = VehicleExtension.formatRouteName(this.vehicleExtraData.getThisRouteName());
        int nextRouteColor = this.vehicleExtraData.getNextRouteColor();
        String nextRouteName = VehicleExtension.formatRouteName(this.vehicleExtraData.getNextRouteName());
        String thisStationName = this.vehicleExtraData.getThisStationName();
        String nextStationName = this.vehicleExtraData.getNextStationName();
        String thisRouteDestination = this.vehicleExtraData.getThisRouteDestination();
        String nextRouteDestination = this.vehicleExtraData.getNextRouteDestination();
        long thisRouteId = this.vehicleExtraData.getThisRouteId();
        if (VehicleRidingMovement.isRiding(this.id)) {
            if (VehicleRidingMovement.showShiftProgressBar()) {
                if (this.speed * 1000.0 > 5.0 || thisRouteName.isEmpty() || thisStationName.isEmpty() || thisRouteDestination.isEmpty()) {
                    clientPlayerEntity.sendMessage(TranslationProvider.GUI_MTR_VEHICLE_SPEED.getText(Utilities.round(this.speed * 1000.0, 1), Utilities.round(this.speed * (double)3.6f * 1000.0, 1)), true);
                } else {
                    MutableText text;
                    block0 : switch ((int)(System.currentTimeMillis() / 1000L % 3L)) {
                        default: {
                            text = VehicleExtension.getStationText(thisStationName, TranslationProvider.GUI_MTR_THIS_STATION_CJK, TranslationProvider.GUI_MTR_THIS_STATION);
                            break;
                        }
                        case 1: {
                            if (nextStationName.isEmpty()) {
                                text = VehicleExtension.getStationText(thisStationName, TranslationProvider.GUI_MTR_THIS_STATION_CJK, TranslationProvider.GUI_MTR_THIS_STATION);
                                break;
                            }
                            text = VehicleExtension.getStationText(nextStationName, TranslationProvider.GUI_MTR_NEXT_STATION_CJK, TranslationProvider.GUI_MTR_NEXT_STATION);
                            break;
                        }
                        case 2: {
                            switch (this.transportMode) {
                                case TRAIN: {
                                    text = VehicleExtension.getStationText(thisRouteDestination, TranslationProvider.GUI_MTR_LAST_TRAIN_STATION_CJK, TranslationProvider.GUI_MTR_LAST_TRAIN_STATION);
                                    break block0;
                                }
                                case BOAT: {
                                    text = VehicleExtension.getStationText(thisRouteDestination, TranslationProvider.GUI_MTR_LAST_BOAT_STATION_CJK, TranslationProvider.GUI_MTR_LAST_BOAT_STATION);
                                    break block0;
                                }
                                case CABLE_CAR: {
                                    text = VehicleExtension.getStationText(thisRouteDestination, TranslationProvider.GUI_MTR_LAST_CABLE_CAR_STATION_CJK, TranslationProvider.GUI_MTR_LAST_CABLE_CAR_STATION);
                                    break block0;
                                }
                                case AIRPLANE: {
                                    text = VehicleExtension.getStationText(thisRouteDestination, TranslationProvider.GUI_MTR_LAST_AIRPLANE_STATION_CJK, TranslationProvider.GUI_MTR_LAST_AIRPLANE_STATION);
                                    break block0;
                                }
                            }
                            text = TextHelper.literal("");
                        }
                    }
                    clientPlayerEntity.sendMessage(new Text((class_2561)text.data), true);
                }
            }
            if (this.persistentVehicleData.canAnnounce(oldRailProgress, this.railProgress)) {
                InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketCheckRouteIdHasDisabledAnnouncements(thisRouteId, routeIdHasDisabledAnnouncements -> {
                    if (!routeIdHasDisabledAnnouncements.booleanValue()) {
                        ObjectArrayList<String> narrateText = new ObjectArrayList<String>();
                        ObjectArrayList<MutableText> chatText = new ObjectArrayList<MutableText>();
                        if (!nextStationName.isEmpty()) {
                            String nextStationFormatted = IGui.insertTranslation(TranslationProvider.GUI_MTR_NEXT_STATION_ANNOUNCEMENT_CJK, TranslationProvider.GUI_MTR_NEXT_STATION_ANNOUNCEMENT, 1, nextStationName);
                            narrateText.add(nextStationFormatted);
                            chatText.add(TextHelper.literal(IGui.formatStationName(nextStationFormatted)));
                        }
                        ObjectArrayList narrateTextThisStation = new ObjectArrayList();
                        ObjectArrayList narrateTextOtherStations = new ObjectArrayList();
                        ObjectArrayList chatTextThisStation = new ObjectArrayList();
                        ObjectArrayList chatTextOtherStations = new ObjectArrayList();
                        this.vehicleExtraData.iterateInterchanges((stationName, interchangeColors) -> {
                            ObjectArrayList<String> combinedRouteNames = new ObjectArrayList<String>();
                            ObjectArrayList globalVisitedRouteNames = new ObjectArrayList();
                            boolean isThisStation = stationName.equals(nextStationName);
                            boolean[] addedStationName = new boolean[]{false};
                            interchangeColors.forEach((color, routeNames) -> {
                                ObjectArrayList visitedRouteNames = new ObjectArrayList();
                                routeNames.forEach(routeName -> {
                                    String routeNameFormatted = VehicleExtension.formatRouteName(routeName);
                                    if (!(routeName.isEmpty() || visitedRouteNames.contains(routeNameFormatted) || color == thisRouteColor && routeNameFormatted.equals(thisRouteName) || color == nextRouteColor && routeNameFormatted.equals(nextRouteName))) {
                                        if (!isThisStation && !addedStationName[0]) {
                                            chatTextOtherStations.add(TextHelper.literal(IGui.formatStationName(IGui.insertTranslation(TranslationProvider.GUI_MTR_CONNECTING_STATION_ANNOUNCEMENT_CJK, TranslationProvider.GUI_MTR_CONNECTING_STATION_ANNOUNCEMENT, 1, stationName))));
                                        }
                                        if (!globalVisitedRouteNames.contains(routeNameFormatted)) {
                                            combinedRouteNames.add(routeNameFormatted);
                                        }
                                        (isThisStation ? chatTextThisStation : chatTextOtherStations).add(TextHelper.append(TextHelper.setStyle(TextHelper.literal("-"), Style.getEmptyMapped().withColor(TextColor.fromRgb(color))), TextHelper.setStyle(TextHelper.literal(" " + IGui.formatStationName(routeNameFormatted)), Style.getEmptyMapped().withColor(TextFormatting.getWhiteMapped()))));
                                        addedStationName[0] = true;
                                        globalVisitedRouteNames.add(routeNameFormatted);
                                        visitedRouteNames.add(routeNameFormatted);
                                    }
                                });
                            });
                            if (addedStationName[0]) {
                                if (isThisStation) {
                                    narrateTextThisStation.add(IGui.insertTranslation(TranslationProvider.GUI_MTR_INTERCHANGE_ANNOUNCEMENT_CJK, TranslationProvider.GUI_MTR_INTERCHANGE_ANNOUNCEMENT, 1, VehicleExtension.getInterchangeText(combinedRouteNames)));
                                } else {
                                    narrateTextOtherStations.add(IGui.insertTranslation(TranslationProvider.GUI_MTR_CONNECTING_STATION_PART_CJK, TranslationProvider.GUI_MTR_CONNECTING_STATION_PART, 1, IGui.insertTranslation(TranslationProvider.GUI_MTR_CONNECTING_STATION_INTERCHANGE_ANNOUNCEMENT_PART_CJK, TranslationProvider.GUI_MTR_CONNECTING_STATION_INTERCHANGE_ANNOUNCEMENT_PART, 2, VehicleExtension.getInterchangeText(combinedRouteNames), stationName)));
                                }
                            }
                        });
                        narrateText.addAll(narrateTextThisStation);
                        narrateText.addAll(narrateTextOtherStations);
                        chatText.addAll(chatTextThisStation);
                        chatText.addAll(chatTextOtherStations);
                        if (!(nextRouteName.isEmpty() || nextRouteColor == thisRouteColor && nextRouteName.equals(thisRouteName))) {
                            String changeRouteText = IGui.insertTranslation(TranslationProvider.GUI_MTR_NEXT_ROUTE_TRAIN_ANNOUNCEMENT_CJK, TranslationProvider.GUI_MTR_NEXT_ROUTE_TRAIN_ANNOUNCEMENT, 2, nextRouteName, nextRouteDestination);
                            chatText.add(TextHelper.append(TextHelper.setStyle(TextHelper.literal("*"), Style.getEmptyMapped().withColor(TextColor.fromRgb(nextRouteColor))), TextHelper.setStyle(TextHelper.literal(" " + IGui.formatStationName(changeRouteText)), Style.getEmptyMapped().withColor(TextFormatting.getWhiteMapped()))));
                            narrateText.add(changeRouteText);
                        }
                        IDrawing.narrateOrAnnounce(IGui.formatStationName(IGui.mergeStations(narrateText, " ", " ")), chatText);
                    }
                }));
            }
            DrivingGuiRenderer.setVehicle(this);
        }
        Vector headPosition = this.getHeadPosition();
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    BlockEntity blockEntity;
                    BlockPos offsetBlockPos = Init.newBlockPos(headPosition.x + (double)xOffset, headPosition.y + (double)yOffset, headPosition.z + (double)zOffset);
                    BlockState blockState = clientWorld.getBlockState(offsetBlockPos);
                    Block block = blockState.getBlock();
                    if (!BlockTrainSensorBase.matchesFilter(new World((class_1937)clientWorld.data), offsetBlockPos, thisRouteId, this.speed)) continue;
                    if (block.data instanceof BlockTrainRedstoneSensor && IBlock.getStatePropertySafe(blockState, BlockTrainRedstoneSensor.POWERED) < 2) {
                        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketTurnOnBlockEntity(offsetBlockPos));
                        continue;
                    }
                    if (!(block.data instanceof BlockTrainAnnouncer) || !VehicleRidingMovement.isRiding(this.id) || (blockEntity = clientWorld.getBlockEntity(offsetBlockPos)) == null || !(blockEntity.data instanceof BlockTrainAnnouncer.BlockEntity)) continue;
                    ((BlockTrainAnnouncer.BlockEntity)blockEntity.data).announce();
                }
            }
        }
        double totalLength = 0.0;
        for (int i = 0; i < this.vehicleExtraData.immutableVehicleCars.size(); ++i) {
            int carNumber;
            int currentIndex = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, oldRailProgress - totalLength);
            if (currentIndex < 0 || currentIndex >= this.vehicleExtraData.immutablePath.size()) continue;
            int n = carNumber = this.reversed ? this.vehicleExtraData.immutableVehicleCars.size() - i - 1 : i;
            if (this.speed * 1000.0 > 5.0 && Math.random() < 0.01) {
                this.persistentVehicleData.getOscillation(carNumber).startOscillation(Math.sqrt(this.speed) * Math.random());
            }
            if (this.railProgress - totalLength >= this.vehicleExtraData.immutablePath.get(currentIndex).getEndDistance()) {
                this.persistentVehicleData.getOscillation(carNumber).startOscillation(Math.sqrt(this.speed) * 2.0 * (Math.random() + 0.5));
            }
            totalLength += this.vehicleExtraData.immutableVehicleCars.get(carNumber).getLength();
        }
        double padding = 0.5 * this.speed * this.speed / this.vehicleExtraData.getDeceleration() + (double)this.transportMode.stoppingSpace;
        int headIndexPadded = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, this.railProgress + padding);
        int headIndex = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, this.railProgress - 1.0);
        int endIndex = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, this.railProgress - this.vehicleExtraData.getTotalVehicleLength());
        int endIndexPadded = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, this.railProgress - this.vehicleExtraData.getTotalVehicleLength() - padding);
        for (int i = Math.max(0, endIndexPadded); i <= Math.min(this.vehicleExtraData.immutablePath.size() - 1, headIndexPadded); ++i) {
            PathData pathData = this.vehicleExtraData.immutablePath.get(i);
            if (i > endIndexPadded && i <= headIndex) {
                MinecraftClientData.getInstance().blockedRailIds.add(pathData.getHexId(false));
            }
            if (i >= headIndexPadded || i < endIndex) continue;
            MinecraftClientData.getInstance().blockedRailIds.add(pathData.getHexId(true));
        }
        PathData pathDataHead = (PathData)Utilities.getElement(this.vehicleExtraData.immutablePath, headIndex);
        if (pathDataHead != null) {
            this.speedLimitKilometersPerHour = (int)pathDataHead.getSpeedLimitKilometersPerHour();
        }
        this.platformStoppingDetails = null;
        PathData previousPathData = null;
        for (int i = Math.min(this.vehicleExtraData.immutablePath.size() - 1, headIndex + 1); i >= 0; --i) {
            PathData pathData = this.vehicleExtraData.immutablePath.get(i);
            if (i <= headIndex) {
                if (pathData.getEndDistance() <= this.railProgress - this.vehicleExtraData.getTotalVehicleLength() || pathData.getSavedRailBaseId() == this.vehicleExtraData.getSidingId()) break;
                if (pathData.getDwellTime() > 0L) {
                    this.platformStoppingDetails = new DoubleObjectImmutablePair<DoubleDoubleImmutablePair>(pathData.getEndDistance() - this.railProgress, new DoubleDoubleImmutablePair(pathData.getRailLength(), previousPathData != null && previousPathData.isOppositeRail(pathData) ? 0.0 : this.vehicleExtraData.getTotalVehicleLength()));
                    break;
                }
            }
            previousPathData = pathData;
        }
    }

    public ObjectArrayList<ObjectObjectImmutablePair<VehicleCar, ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>>>> getSmoothedVehicleCarsAndPositions(long millisElapsed) {
        double oldRailProgress = this.railProgress;
        this.railProgress = this.persistentVehicleData.getSmoothedRailProgress(this.railProgress, this.persistentVehicleData.getDoorValue() > 0.0 ? 0.0 : (double)millisElapsed * (this.speed == 0.0 ? 2.147483647E9 : this.speed / 10.0));
        ObjectArrayList<ObjectObjectImmutablePair<VehicleCar, ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>>>> vehicleCarsAndPositions = this.getVehicleCarsAndPositions();
        this.railProgress = oldRailProgress;
        return vehicleCarsAndPositions;
    }

    public void playMotorSound(VehicleResource vehicleResource, int carNumber, Vector bogiePosition) {
        this.persistentVehicleData.playMotorSound(vehicleResource, carNumber, Init.newBlockPos(bogiePosition.x, bogiePosition.y, bogiePosition.z), (float)this.speed, (float)(this.speed - this.oldSpeed), (float)this.vehicleExtraData.getAcceleration(), this.getIsOnRoute());
    }

    public void playDoorSound(VehicleResource vehicleResource, int carNumber, Vector vehiclePosition) {
        this.persistentVehicleData.playDoorSound(vehicleResource, carNumber, Init.newBlockPos(vehiclePosition.x, vehiclePosition.y, vehiclePosition.z));
    }

    public int getSpeedLimitKilometersPerHour() {
        return this.speedLimitKilometersPerHour;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean isVehiclePastSafeStoppingDistance() {
        return this.speed > 0.0 && this.railProgress + 0.5 * this.speed * this.speed / this.vehicleExtraData.getDeceleration() * 5.0 >= this.vehicleExtraData.getStoppingPoint();
    }

    @Nullable
    public DoubleObjectImmutablePair<DoubleDoubleImmutablePair> getPlatformStoppingDetails() {
        return this.platformStoppingDetails;
    }

    private static MutableText getStationText(String text, TranslationProvider.TranslationHolder keyCjk, TranslationProvider.TranslationHolder key) {
        return TextHelper.literal(text.isEmpty() ? "" : IGui.formatStationName(IGui.insertTranslation(keyCjk, key, 1, IGui.textOrUntitled(text))));
    }

    private static String formatRouteName(String routeName) {
        return routeName.split("\\|\\|")[0];
    }

    private static String getInterchangeText(ObjectArrayList<String> names) {
        ObjectArrayList<String> newNamesCjk = new ObjectArrayList<String>();
        ObjectArrayList<String> newNames = new ObjectArrayList<String>();
        names.forEach(name -> {
            for (String nameSplit : name.split("\\|")) {
                (IGui.isCjk(nameSplit) ? newNamesCjk : newNames).add(nameSplit);
            }
        });
        String combinedCjk = VehicleExtension.mergeNames(newNamesCjk, TranslationProvider.GUI_MTR_COMMA_CJK, TranslationProvider.GUI_MTR_COMMA_LAST_CJK);
        String combined = VehicleExtension.mergeNames(newNames, TranslationProvider.GUI_MTR_COMMA, TranslationProvider.GUI_MTR_COMMA_LAST);
        return String.format("%s%s%s", combinedCjk, !combinedCjk.isEmpty() && !combined.isEmpty() ? "|" : "", combined);
    }

    private static String mergeNames(ObjectArrayList<String> names, TranslationProvider.TranslationHolder keyComma, TranslationProvider.TranslationHolder keyCommaLast) {
        if (names.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            stringBuilder.append(names.get(i));
            if (i <= names.size() - 3) {
                stringBuilder.append(keyComma.getString(new Object[0]));
                continue;
            }
            if (i != names.size() - 2) continue;
            stringBuilder.append(keyCommaLast.getString(new Object[0]));
        }
        return stringBuilder.toString();
    }

    public void dispose() {
        this.persistentVehicleData.dispose();
    }
}

