/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.generated.resource;

import javax.annotation.Nonnull;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mod.resource.MinecraftModelResource;
import org.mtr.mod.resource.ModelWrapper;
import org.mtr.mod.resource.VehicleResourceWrapper;

public abstract class ResourceWrapperSchema
implements SerializedDataBase {
    protected final ObjectArrayList<VehicleResourceWrapper> vehicles = new ObjectArrayList();
    protected final ObjectArrayList<ModelWrapper> modelResources = new ObjectArrayList();
    protected final ObjectArrayList<String> textureResources = new ObjectArrayList();
    protected final ObjectArrayList<MinecraftModelResource> minecraftModelResources = new ObjectArrayList();
    protected final ObjectArrayList<String> minecraftTextureResources = new ObjectArrayList();
    protected boolean isMinecraftPaused;
    protected String exportDirectory = "";

    protected ResourceWrapperSchema() {
    }

    protected ResourceWrapperSchema(ReaderBase readerBase) {
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateReaderArray("vehicles", this.vehicles::clear, readerBaseChild -> this.vehicles.add(new VehicleResourceWrapper((ReaderBase)readerBaseChild)));
        readerBase.iterateReaderArray("modelResources", this.modelResources::clear, readerBaseChild -> this.modelResources.add(new ModelWrapper((ReaderBase)readerBaseChild)));
        readerBase.iterateStringArray("textureResources", this.textureResources::clear, this.textureResources::add);
        readerBase.iterateReaderArray("minecraftModelResources", this.minecraftModelResources::clear, readerBaseChild -> this.minecraftModelResources.add(new MinecraftModelResource((ReaderBase)readerBaseChild)));
        readerBase.iterateStringArray("minecraftTextureResources", this.minecraftTextureResources::clear, this.minecraftTextureResources::add);
        readerBase.unpackBoolean("isMinecraftPaused", value -> {
            this.isMinecraftPaused = value;
        });
        readerBase.unpackString("exportDirectory", value -> {
            this.exportDirectory = value;
        });
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        this.serializeVehicles(writerBase);
        this.serializeModelResources(writerBase);
        this.serializeTextureResources(writerBase);
        this.serializeMinecraftModelResources(writerBase);
        this.serializeMinecraftTextureResources(writerBase);
        this.serializeIsMinecraftPaused(writerBase);
        this.serializeExportDirectory(writerBase);
    }

    @Nonnull
    public String toString() {
        return "vehicles: " + this.vehicles + "\nmodelResources: " + this.modelResources + "\ntextureResources: " + this.textureResources + "\nminecraftModelResources: " + this.minecraftModelResources + "\nminecraftTextureResources: " + this.minecraftTextureResources + "\nisMinecraftPaused: " + this.isMinecraftPaused + "\nexportDirectory: " + this.exportDirectory + "\n";
    }

    protected void serializeVehicles(WriterBase writerBase) {
        writerBase.writeDataset(this.vehicles, "vehicles");
    }

    protected void serializeModelResources(WriterBase writerBase) {
        writerBase.writeDataset(this.modelResources, "modelResources");
    }

    protected void serializeTextureResources(WriterBase writerBase) {
        WriterBase.Array textureResourcesWriterBaseArray = writerBase.writeArray("textureResources");
        this.textureResources.forEach(textureResourcesWriterBaseArray::writeString);
    }

    protected void serializeMinecraftModelResources(WriterBase writerBase) {
        writerBase.writeDataset(this.minecraftModelResources, "minecraftModelResources");
    }

    protected void serializeMinecraftTextureResources(WriterBase writerBase) {
        WriterBase.Array minecraftTextureResourcesWriterBaseArray = writerBase.writeArray("minecraftTextureResources");
        this.minecraftTextureResources.forEach(minecraftTextureResourcesWriterBaseArray::writeString);
    }

    protected void serializeIsMinecraftPaused(WriterBase writerBase) {
        writerBase.writeBoolean("isMinecraftPaused", this.isMinecraftPaused);
    }

    protected void serializeExportDirectory(WriterBase writerBase) {
        writerBase.writeString("exportDirectory", this.exportDirectory);
    }
}

