/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import javax.annotation.Nullable;
import net.minecraft.class_2561;
import org.mtr.core.data.VehicleExtraData;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.doubles.DoubleObjectImmutablePair;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Window;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mod.client.VehicleRidingMovement;
import org.mtr.mod.data.RailType;
import org.mtr.mod.data.VehicleExtension;

public final class DrivingGuiRenderer {
    @Nullable
    private static VehicleExtension vehicle;
    private static final int EDGE_PADDING = 16;
    private static final int PADDING = 4;
    private static final int TOOL_SIZE = 96;
    private static final int PLATFORM_BAR_SIZE = 6;
    private static final int SMALL_LINE_SPACING = 6;
    private static final int SPEEDOMETER_CIRCLE_INTERVAL = 3;
    private static final double SPEEDOMETER_CIRCLE_EDGE_LENGTH;
    private static final int SPEEDOMETER_SPAN = 300;
    private static final int SPEEDOMETER_START_ANGLE = -60;
    private static final int SPEEDOMETER_TICK_INTERVAL = 5;
    private static final int ATS_SLICES = 64;
    private static final float ATS_INTERVAL = 5.625f;
    private static final int ATS_RADIUS_1 = 9;
    private static final int ATS_RADIUS_2 = 8;
    private static final int ATS_RADIUS_3 = 5;
    private static final int ATS_RADIUS_4 = 1;
    private static final double ATS_CIRCLE_EDGE_HALF_LENGTH_1;
    private static final double ATS_CIRCLE_EDGE_HALF_LENGTH_2;
    private static final double ATS_CIRCLE_EDGE_HALF_LENGTH_3;
    private static final double ATS_CIRCLE_EDGE_HALF_LENGTH_4;
    private static final int BLUE_COLOR = -5583617;
    private static final int ORANGE_COLOR = -26368;

    public static void render(GraphicsHolder graphicsHolder) {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        if (vehicle != null && (minecraftClient.getCurrentScreenMapped() == null || ((class_2561)minecraftClient.getCurrentScreenMapped().getTitle().data).toString().contains("chat_screen.title")) && VehicleRidingMovement.getValidHoldingKey(DrivingGuiRenderer.vehicle.vehicleExtraData.getDepotId()) != null) {
            int notchColor;
            int i;
            float i2;
            VehicleExtraData vehicleExtraData = DrivingGuiRenderer.vehicle.vehicleExtraData;
            Window window = minecraftClient.getWindow();
            int speedometerX = window.getScaledWidth() - 96 - 16;
            int speedometerY = window.getScaledHeight() - 96 - 16;
            int radius = 48;
            GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
            graphicsHolder.push();
            graphicsHolder.translate(speedometerX + 48, speedometerY + 48, 0.0);
            graphicsHolder.push();
            for (int i3 = 0; i3 < 180; i3 += 3) {
                guiDrawing.beginDrawingRectangle();
                guiDrawing.drawRectangle(-48.0, -((float)SPEEDOMETER_CIRCLE_EDGE_LENGTH) / 2.0f, 48.0, (float)SPEEDOMETER_CIRCLE_EDGE_LENGTH / 2.0f, -10066330);
                guiDrawing.drawRectangle(-47.0, -((float)SPEEDOMETER_CIRCLE_EDGE_LENGTH) / 2.0f, 47.0, (float)SPEEDOMETER_CIRCLE_EDGE_LENGTH / 2.0f, -15658735);
                guiDrawing.finishDrawingRectangle();
                graphicsHolder.rotateZDegrees(3.0f);
            }
            graphicsHolder.pop();
            graphicsHolder.push();
            graphicsHolder.translate(0.0, 37.0, 0.0);
            graphicsHolder.rotateZDegrees(14.0625f);
            for (i2 = 0.0f; i2 < 64.0f; i2 += 1.0f) {
                guiDrawing.beginDrawingRectangle();
                guiDrawing.drawRectangle(-9.0, -((float)ATS_CIRCLE_EDGE_HALF_LENGTH_1), 9.0, (float)ATS_CIRCLE_EDGE_HALF_LENGTH_1, -15066598);
                guiDrawing.finishDrawingRectangle();
                graphicsHolder.rotateZDegrees(5.625f);
            }
            for (i2 = 0.0f; i2 < 64.0f; i2 += 1.0f) {
                guiDrawing.beginDrawingRectangle();
                if (i2 % 8.0f < 4.0f) {
                    if (vehicle.isVehiclePastSafeStoppingDistance()) {
                        guiDrawing.drawRectangle(-8.0, -((float)ATS_CIRCLE_EDGE_HALF_LENGTH_2), -8.0, (float)ATS_CIRCLE_EDGE_HALF_LENGTH_2, -5.0, (float)ATS_CIRCLE_EDGE_HALF_LENGTH_3, -5.0, -((float)ATS_CIRCLE_EDGE_HALF_LENGTH_3), -26368);
                        guiDrawing.drawRectangle(-5.0, -((float)ATS_CIRCLE_EDGE_HALF_LENGTH_3), -5.0, (float)ATS_CIRCLE_EDGE_HALF_LENGTH_3, -1.0, (float)ATS_CIRCLE_EDGE_HALF_LENGTH_4, -1.0, -((float)ATS_CIRCLE_EDGE_HALF_LENGTH_4), -1);
                    } else {
                        guiDrawing.drawRectangle(-8.0, -((float)ATS_CIRCLE_EDGE_HALF_LENGTH_2), -8.0, (float)ATS_CIRCLE_EDGE_HALF_LENGTH_2, -1.0, (float)ATS_CIRCLE_EDGE_HALF_LENGTH_4, -1.0, -((float)ATS_CIRCLE_EDGE_HALF_LENGTH_4), -14540254);
                    }
                }
                guiDrawing.finishDrawingRectangle();
                graphicsHolder.rotateZDegrees(5.625f);
            }
            graphicsHolder.pop();
            graphicsHolder.push();
            int maxSpeedKilometersPerHour = vehicleExtraData.getIsManualAllowed() ? (int)Math.round(vehicleExtraData.getMaxManualSpeed() * 3600.0) : RailType.DIAMOND.speedLimit;
            graphicsHolder.rotateZDegrees(-60.0f);
            for (i = 0; i <= maxSpeedKilometersPerHour; i += 5) {
                guiDrawing.beginDrawingRectangle();
                guiDrawing.drawRectangle(-46.0, -0.5, -48 + (i % 20 == 0 ? 10 : (i % 10 == 0 ? 8 : 4)), 0.5, vehicle.getSpeedLimitKilometersPerHour() > 0 && i == Math.min(vehicle.getSpeedLimitKilometersPerHour(), maxSpeedKilometersPerHour) ? -16711936 : -1);
                guiDrawing.finishDrawingRectangle();
                graphicsHolder.rotateZDegrees(1500.0f / (float)maxSpeedKilometersPerHour);
            }
            graphicsHolder.pop();
            graphicsHolder.push();
            graphicsHolder.rotateZDegrees(-60.0f);
            for (i = 0; i <= maxSpeedKilometersPerHour; i += 20) {
                graphicsHolder.push();
                graphicsHolder.translate(-33.0, 0.0, 0.0);
                graphicsHolder.rotateZDegrees(60.0f - (float)i * 300.0f / (float)maxSpeedKilometersPerHour);
                graphicsHolder.scale(0.5f, 0.5f, 1.0f);
                DrivingGuiRenderer.drawCenteredText(graphicsHolder, String.valueOf(i), -1);
                graphicsHolder.pop();
                graphicsHolder.rotateZDegrees(6000.0f / (float)maxSpeedKilometersPerHour);
            }
            graphicsHolder.pop();
            graphicsHolder.push();
            graphicsHolder.translate(-14.40000057220459, -10.8f, 0.0);
            int notch = vehicleExtraData.getPowerLevel();
            int n = notch < -7 ? -65536 : (notch < 0 ? -26368 : (notchColor = notch > 0 ? -5583617 : -1));
            DrivingGuiRenderer.drawCenteredText(graphicsHolder, notch < -7 ? "E" : (notch < 0 ? "B" + -notch : (notch > 0 ? "P" + notch : "N")), notchColor);
            if (notch != 0 && notch >= -7) {
                graphicsHolder.translate(0.0, 6.0, 0.0);
                graphicsHolder.scale(0.5f, 0.5f, 1.0f);
                DrivingGuiRenderer.drawCenteredText(graphicsHolder, String.format("(%s%%)", Math.abs(notch) * 100 / 5), notchColor);
            }
            graphicsHolder.pop();
            graphicsHolder.push();
            graphicsHolder.translate(0.0, -20.400001525878906, 0.0);
            DrivingGuiRenderer.drawCenteredText(graphicsHolder, "ATO", vehicleExtraData.getIsCurrentlyManual() ? -14540254 : -16711936);
            graphicsHolder.pop();
            graphicsHolder.push();
            graphicsHolder.translate(14.40000057220459, -10.8f, 0.0);
            DrivingGuiRenderer.drawCenteredText(graphicsHolder, vehicleExtraData.getDoorMultiplier() > 0 ? "DO" : "DC", -1);
            graphicsHolder.translate(0.0, 6.0, 0.0);
            graphicsHolder.scale(0.5f, 0.5f, 1.0f);
            DrivingGuiRenderer.drawCenteredText(graphicsHolder, String.format("(%s%%)", (int)Math.round(DrivingGuiRenderer.vehicle.persistentVehicleData.getDoorValue() * 100.0)), -1);
            graphicsHolder.pop();
            graphicsHolder.push();
            graphicsHolder.translate(0.0, 9.6f, 0.0);
            double speedKilometersPerHour = vehicle.getSpeed() * 3600.0;
            int speedColor = vehicle.getSpeedLimitKilometersPerHour() > 0 && speedKilometersPerHour > (double)vehicle.getSpeedLimitKilometersPerHour() ? -26368 : -1;
            DrivingGuiRenderer.drawCenteredText(graphicsHolder, String.valueOf(Utilities.round(speedKilometersPerHour, 1)), speedColor);
            graphicsHolder.translate(0.0, 6.0, 0.0);
            graphicsHolder.scale(0.5f, 0.5f, 1.0f);
            DrivingGuiRenderer.drawCenteredText(graphicsHolder, "km/h", speedColor);
            graphicsHolder.pop();
            graphicsHolder.push();
            graphicsHolder.rotateZDegrees(-60.0f + (float)speedKilometersPerHour * 300.0f / (float)maxSpeedKilometersPerHour);
            guiDrawing.beginDrawingRectangle();
            guiDrawing.drawRectangle(-44.0, -0.5, 0.0, 0.5, -65536);
            guiDrawing.finishDrawingRectangle();
            graphicsHolder.pop();
            graphicsHolder.pop();
            DoubleObjectImmutablePair<DoubleDoubleImmutablePair> platformStoppingDetails = vehicle.getPlatformStoppingDetails();
            if (platformStoppingDetails != null) {
                double platformLength = platformStoppingDetails.right().leftDouble();
                double vehicleLength = platformStoppingDetails.right().rightDouble();
                int platformIndicatorX = window.getScaledWidth() - 16 - 6;
                int platformIndicatorY = window.getScaledHeight() - 192 - 16 - 4;
                double targetY = vehicleLength / (platformLength + vehicleLength) * 95.0;
                double positionY = (vehicleLength + platformStoppingDetails.leftDouble()) / (platformLength + vehicleLength) * 95.0;
                guiDrawing.beginDrawingRectangle();
                guiDrawing.drawRectangle(platformIndicatorX, platformIndicatorY, platformIndicatorX + 6, platformIndicatorY + 96, -5583617);
                guiDrawing.drawRectangle(platformIndicatorX, (float)platformIndicatorY + (float)targetY, platformIndicatorX + 6, (float)platformIndicatorY + (float)targetY + 1.0f, -16769203);
                guiDrawing.drawRectangle(platformIndicatorX, (float)platformIndicatorY + (float)positionY, platformIndicatorX + 6, (float)platformIndicatorY + (float)positionY + 1.0f, -65536);
                guiDrawing.finishDrawingRectangle();
                String text = Utilities.round(platformStoppingDetails.leftDouble(), 1) + " m";
                int textWidth = GraphicsHolder.getTextWidth(text);
                graphicsHolder.push();
                graphicsHolder.translate((float)platformIndicatorX - 2.0f, (double)platformIndicatorY + positionY + 0.5, 0.0);
                graphicsHolder.scale(0.5f, 0.5f, 1.0f);
                graphicsHolder.drawText(text, -textWidth, -4, -1, true, GraphicsHolder.getDefaultLight());
                graphicsHolder.pop();
            }
        }
        vehicle = null;
    }

    public static void setVehicle(VehicleExtension vehicle) {
        DrivingGuiRenderer.vehicle = vehicle;
    }

    private static void drawCenteredText(GraphicsHolder graphicsHolder, String text, int color) {
        graphicsHolder.drawText(text, -GraphicsHolder.getTextWidth(text) / 2, -4, color, false, GraphicsHolder.getDefaultLight());
    }

    static {
        SPEEDOMETER_CIRCLE_EDGE_LENGTH = Math.tan(Math.toRadians(3.0) / 2.0) * 96.0;
        ATS_CIRCLE_EDGE_HALF_LENGTH_1 = Math.tan(Math.toRadians(5.625) / 2.0) * 9.0;
        ATS_CIRCLE_EDGE_HALF_LENGTH_2 = Math.tan(Math.toRadians(5.625) / 2.0) * 8.0;
        ATS_CIRCLE_EDGE_HALF_LENGTH_3 = Math.tan(Math.toRadians(5.625) / 2.0) * 5.0;
        ATS_CIRCLE_EDGE_HALF_LENGTH_4 = Math.tan(Math.toRadians(5.625) / 2.0) * 1.0;
    }
}

