/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.core.data.VehicleCar;
import org.mtr.core.tool.Utilities;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.LightmapTextureManager;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mod.Init;

public final class PositionAndRotation {
    public final Vector position;
    public final double yaw;
    public final double pitch;
    public final int light;

    public PositionAndRotation(Vector position, double yaw, double pitch) {
        this.position = position;
        this.yaw = yaw;
        this.pitch = pitch;
        this.light = PositionAndRotation.getLight(position);
    }

    public PositionAndRotation(Vector position1, Vector position2, boolean hasPitch) {
        this(Vector.getAverage(position1, position2), PositionAndRotation.getYaw(position1, position2), hasPitch ? PositionAndRotation.getPitch(position1, position2) : 0.0);
    }

    public PositionAndRotation(ObjectArrayList<PositionAndRotation> bogiePositions, VehicleCar vehicleCar, boolean hasPitch) {
        if (bogiePositions.size() == 1 || bogiePositions.size() == 2) {
            Vector bogiesMidpoint;
            if (bogiePositions.size() == 1) {
                PositionAndRotation bogiePositionAndRotation = bogiePositions.get(0);
                bogiesMidpoint = bogiePositionAndRotation.position;
                this.yaw = bogiePositionAndRotation.yaw;
                this.pitch = hasPitch ? bogiePositionAndRotation.pitch : 0.0;
            } else {
                PositionAndRotation bogiePositionAndRotation1 = bogiePositions.get(0);
                PositionAndRotation bogiePositionAndRotation2 = bogiePositions.get(1);
                Vector average1 = bogiePositionAndRotation1.position;
                Vector average2 = bogiePositionAndRotation2.position;
                bogiesMidpoint = Vector.getAverage(average1, average2);
                this.yaw = PositionAndRotation.getYaw(average1, average2);
                this.pitch = hasPitch ? PositionAndRotation.getPitch(average1, average2) : 0.0;
            }
            double pivotOffset = Utilities.getAverage(vehicleCar.getBogie1Position(), vehicleCar.getBogie2Position());
            double halfLength = vehicleCar.getLength() / 2.0;
            double pivotOffset1 = -pivotOffset - halfLength;
            double pivotOffset2 = -pivotOffset + halfLength;
            Vector rotationalVector = new Vector(0.0, 0.0, 1.0).rotateX(this.pitch).rotateY(this.yaw);
            this.position = Vector.getAverage(rotationalVector.multiply(pivotOffset1, pivotOffset1, pivotOffset1).add(bogiesMidpoint), rotationalVector.multiply(pivotOffset2, pivotOffset2, pivotOffset2).add(bogiesMidpoint));
        } else {
            this.position = new Vector(0.0, 0.0, 0.0);
            this.yaw = 0.0;
            this.pitch = 0.0;
        }
        this.light = PositionAndRotation.getLight(this.position);
    }

    public <T> T transformForwards(T initialValue, Rotate<T> rotateX, Rotate<T> rotateY, Translate<T> translate) {
        return translate.apply(rotateY.apply(rotateX.apply(initialValue, (float)this.pitch), (float)this.yaw), this.position.x, this.position.y, this.position.z);
    }

    public <T> T transformBackwards(T initialValue, Rotate<T> rotateX, Rotate<T> rotateY, Translate<T> translate) {
        return rotateX.apply(rotateY.apply(translate.apply(initialValue, -this.position.x, -this.position.y, -this.position.z), (float)(-this.yaw)), (float)(-this.pitch));
    }

    private static int getLight(Vector position) {
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            return 0;
        }
        BlockPos blockPos = Init.newBlockPos(position.x, position.y + 1.0, position.z);
        return LightmapTextureManager.pack(clientWorld.getLightLevel(LightType.getBlockMapped(), blockPos), clientWorld.getLightLevel(LightType.getSkyMapped(), blockPos));
    }

    private static double getYaw(Vector position1, Vector position2) {
        double x1 = position1.x;
        double z1 = position1.z;
        double x2 = position2.x;
        double z2 = position2.z;
        return Math.atan2(x2 - x1, z2 - z1);
    }

    private static double getPitch(Vector position1, Vector position2) {
        double x1 = position1.x;
        double y1 = position1.y;
        double z1 = position1.z;
        double x2 = position2.x;
        double y2 = position2.y;
        double z2 = position2.z;
        return Math.atan2(y2 - y1, Math.sqrt((x2 - x1) * (x2 - x1) + (z2 - z1) * (z2 - z1)));
    }

    @FunctionalInterface
    public static interface Translate<T> {
        public T apply(T var1, double var2, double var4, double var6);
    }

    @FunctionalInterface
    public static interface Rotate<T> {
        public T apply(T var1, float var2);
    }
}

