/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.Collections;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2382;
import net.minecraft.class_2769;
import org.mtr.core.data.Rail;
import org.mtr.core.data.TransportMode;
import org.mtr.core.tool.Angle;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.logisticscraft.occlusionculling.util.Vec3d;
import org.mtr.libraries.it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Camera;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.HitResult;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.LightmapTextureManager;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.mapper.EntityHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.MinecraftClientHelper;
import org.mtr.mapping.mapper.OptimizedRenderer;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockNode;
import org.mtr.mod.block.BlockSignalLightBase;
import org.mtr.mod.block.BlockSignalSemaphoreBase;
import org.mtr.mod.block.PlatformHelper;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.IGui;
import org.mtr.mod.data.RailType;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.item.ItemBrush;
import org.mtr.mod.item.ItemNodeModifierBase;
import org.mtr.mod.item.ItemRailModifier;
import org.mtr.mod.model.ModelSmallCube;
import org.mtr.mod.packet.PacketUpdateLastRailStyles;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.RailResource;

public class RenderRails
implements IGui {
    private static final Identifier IRON_BLOCK_TEXTURE = new Identifier("textures/block/iron_block.png");
    private static final Identifier METAL_TEXTURE = new Identifier("mtr", "textures/block/metal.png");
    private static final Identifier RAIL_PREVIEW_TEXTURE = new Identifier("mtr", "textures/block/rail_preview.png");
    private static final Identifier RAIL_TEXTURE = new Identifier("textures/block/rail.png");
    private static final Identifier WOOL_TEXTURE = new Identifier("textures/block/white_wool.png");
    private static final Identifier ONE_WAY_RAIL_ARROW_TEXTURE = new Identifier("mtr", "textures/block/one_way_rail_arrow.png");
    private static final int INVALID_NODE_CHECK_RADIUS = 16;
    private static final double LIGHT_REFERENCE_OFFSET = 0.1;
    private static final ModelSmallCube MODEL_SMALL_CUBE = new ModelSmallCube(new Identifier("mtr", "textures/block/white.png"));

    public static void render() {
        HitResult hitResult;
        ObjectObjectImmutablePair<Rail, BlockPos> railAndBlockPos;
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientWorld clientWorld = minecraftClient.getWorldMapped();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientWorld == null || clientPlayerEntity == null) {
            return;
        }
        ObjectArrayList cullingTasks = new ObjectArrayList();
        Vector3d cameraPosition = minecraftClient.getGameRendererMapped().getCamera().getPos();
        Vec3d camera = new Vec3d(cameraPosition.getXMapped(), cameraPosition.getYMapped(), cameraPosition.getZMapped());
        boolean holdingRailRelated = RenderRails.isHoldingRailRelated(clientPlayerEntity);
        ObjectArrayList<Rail> railsToRender = new ObjectArrayList<Rail>();
        MinecraftClientData.getInstance().railWrapperList.values().forEach(railWrapper -> {
            cullingTasks.add(occlusionCullingInstance -> {
                boolean shouldRender = occlusionCullingInstance.isAABBVisible(railWrapper.startVector, railWrapper.endVector, camera);
                return () -> {
                    railWrapper.shouldRender = shouldRender;
                };
            });
            if (railWrapper.shouldRender) {
                railsToRender.add(railWrapper.getRail());
            }
        });
        ObjectArraySet<Rail> hoverRails = new ObjectArraySet<Rail>();
        if (clientPlayerEntity.isHolding(Items.BRUSH.get()) && (railAndBlockPos = MinecraftClientData.getInstance().getFacingRailAndBlockPos(false)) != null) {
            Rail rail2 = railAndBlockPos.left();
            BlockPos blockPos = railAndBlockPos.right();
            if (clientPlayerEntity.isSneaking()) {
                if (PacketUpdateLastRailStyles.CLIENT_CACHE.canApplyStylesToRail(clientPlayerEntity.getUuid(), rail2, false)) {
                    Rail newRail = PacketUpdateLastRailStyles.CLIENT_CACHE.getRailWithLastStyles(clientPlayerEntity.getUuid(), rail2);
                    hoverRails.add(newRail);
                    railsToRender.remove(rail2);
                    railsToRender.add(newRail);
                    DoubleDoubleImmutablePair railRadii = newRail.railMath.getHorizontalRadii();
                    RenderRails.renderRailStats(blockPos, null, newRail.railMath.getLength(), railRadii.leftDouble(), railRadii.rightDouble());
                }
            } else {
                hoverRails.add(rail2);
                DoubleDoubleImmutablePair railRadii = rail2.railMath.getHorizontalRadii();
                RenderRails.renderRailStats(blockPos, null, rail2.railMath.getLength(), railRadii.leftDouble(), railRadii.rightDouble());
            }
        }
        ItemStack itemStack = RenderRails.getStackInHand();
        Item item = itemStack.getItem();
        if (item.data instanceof ItemRailModifier && (hitResult = minecraftClient.getCrosshairTargetMapped()) != null) {
            Vector3d hitPos = hitResult.getPos();
            BlockPos posStart = Init.newBlockPos(hitPos.getXMapped(), hitPos.getYMapped(), hitPos.getZMapped());
            CompoundTag compoundTag = itemStack.getOrCreateTag();
            if (compoundTag.contains("pos")) {
                BlockPos posEnd = BlockPos.fromLong(compoundTag.getLong("pos"));
                BlockState blockStateEnd = clientWorld.getBlockState(posEnd);
                if (blockStateEnd.getBlock().data instanceof BlockNode) {
                    BlockState blockStateStart = clientWorld.getBlockState(posStart);
                    float angleEnd = BlockNode.getAngle(blockStateEnd);
                    ObjectObjectImmutablePair<Angle, Angle> angles = Rail.getAngles(Init.blockPosToPosition(posStart), blockStateStart.getBlock().data instanceof BlockNode ? BlockNode.getAngle(blockStateStart) : (blockStateEnd.getBlock().data instanceof BlockNode.BlockContinuousMovementNode ? angleEnd : EntityHelper.getYaw(new Entity((class_1297)clientPlayerEntity.data)) + 90.0f), Init.blockPosToPosition(posEnd), angleEnd);
                    Rail rail3 = ((ItemRailModifier)item.data).createRail(clientPlayerEntity.getUuid(), ItemNodeModifierBase.getTransportMode(compoundTag), blockStateStart, blockStateEnd, posStart, posEnd, angles.left(), angles.right());
                    if (rail3 != null) {
                        Rail newRail = PacketUpdateLastRailStyles.CLIENT_CACHE.getRailWithLastStyles(clientPlayerEntity.getUuid(), rail3);
                        railsToRender.add(newRail);
                        hoverRails.add(newRail);
                        double railLength = newRail.railMath.getLength();
                        DoubleDoubleImmutablePair railRadii = newRail.railMath.getHorizontalRadii();
                        RenderRails.renderRailStats(posStart, posEnd, railLength, railRadii.leftDouble(), railRadii.rightDouble());
                        RenderRails.renderRailStats(posEnd, posStart, railLength, railRadii.rightDouble(), railRadii.leftDouble());
                    }
                }
            }
        }
        railsToRender.forEach(rail -> {
            RenderState renderState = holdingRailRelated ? (hoverRails.contains(rail) ? RenderState.FLASHING : RenderState.COLORED) : RenderState.NORMAL;
            switch (rail.getTransportMode()) {
                case TRAIN: {
                    RenderRails.renderRailStandard(clientWorld, rail, renderState, 1.0f);
                    if (!renderState.hasColor) break;
                    RenderRails.renderRailOneWayArrows(rail, 0.25f);
                    RenderRails.renderSignalsStandard(clientWorld, rail);
                    break;
                }
                case BOAT: {
                    RenderRails.renderRailStandard(clientWorld, rail, renderState, 0.5f);
                    if (!renderState.hasColor) break;
                    RenderRails.renderRailOneWayArrows(rail, 0.25f);
                    RenderRails.renderSignalsStandard(clientWorld, rail);
                    break;
                }
                case CABLE_CAR: {
                    if (rail.isPlatform() || rail.isSiding() || rail.getSpeedLimitKilometersPerHour(false) == (long)RailType.CABLE_CAR_STATION.speedLimit || rail.getSpeedLimitKilometersPerHour(true) == (long)RailType.CABLE_CAR_STATION.speedLimit) {
                        RenderRails.renderRailStandard(clientWorld, rail, 0.253125f, renderState, 0.25f, METAL_TEXTURE, 0.25f, 0.0f, 0.75f, 1.0f);
                    }
                    if (renderState.hasColor && !rail.isPlatform() && !rail.isSiding()) {
                        RenderRails.renderRailOneWayArrows(rail, 0.503125f);
                    }
                    MainRenderer.scheduleRender(QueuedRenderLayer.LINES, (graphicsHolder, offset) -> RenderRails.renderWithinRenderDistance(rail, (blockPos, x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> graphicsHolder.drawLineInWorld((float)(x1 - offset.getXMapped()), (float)(y1 - offset.getYMapped() + 0.5), (float)(z1 - offset.getZMapped()), (float)(x3 - offset.getXMapped()), (float)(y2 - offset.getYMapped() + 0.5), (float)(z3 - offset.getZMapped()), holdingRailRelated ? RailType.getRailColor(rail) : -16777216), 0.5, 0.0f, 0.0f));
                    break;
                }
                case AIRPLANE: {
                    RenderRails.renderRailStandard(clientWorld, rail, 0.065625f, renderState, 0.25f, IRON_BLOCK_TEXTURE, 0.25f, 0.0f, 0.75f, 1.0f);
                    if (!renderState.hasColor) break;
                    RenderRails.renderRailOneWayArrows(rail, 0.25f);
                    RenderRails.renderSignalsStandard(clientWorld, rail);
                }
            }
        });
        if (holdingRailRelated) {
            MinecraftClientData.getInstance().positionsToRail.keySet().forEach(position -> {
                BlockPos blockPos = Init.positionToBlockPos(position);
                RenderRails.renderNode(clientWorld.getBlockState(blockPos), blockPos, () -> true, GraphicsHolder.getDefaultLight());
            });
            for (int x = -16; x <= 16; ++x) {
                for (int y = -16; y <= 16; ++y) {
                    for (int z = -16; z <= 16; ++z) {
                        BlockPos blockPos = clientPlayerEntity.getBlockPos().add(x, y, z);
                        BlockState blockState = clientWorld.getBlockState(blockPos);
                        RenderRails.renderNode(blockState, blockPos, () -> (Boolean)blockState.get(new Property((class_2769)BlockNode.IS_CONNECTED.data)) != false && !MinecraftClientData.getInstance().positionsToRail.containsKey(Init.blockPosToPosition(blockPos)), MainRenderer.getFlashingLight());
                    }
                }
            }
        }
        if (!OptimizedRenderer.renderingShadows()) {
            MainRenderer.WORKER_THREAD.scheduleRails(occlusionCullingInstance -> {
                ObjectArrayList tasks = new ObjectArrayList();
                cullingTasks.forEach(occlusionCullingInstanceRunnableFunction -> tasks.add(occlusionCullingInstanceRunnableFunction.apply(occlusionCullingInstance)));
                minecraftClient.execute(() -> tasks.forEach(Runnable::run));
            });
        }
    }

    public static boolean isHoldingRailRelated(ClientPlayerEntity clientPlayerEntity) {
        return PlayerHelper.isHolding(new PlayerEntity((class_1657)clientPlayerEntity.data), item -> item.data instanceof ItemNodeModifierBase || item.data instanceof ItemBrush || Block.getBlockFromItem((Item)item).data instanceof BlockSignalLightBase || Block.getBlockFromItem((Item)item).data instanceof BlockNode || Block.getBlockFromItem((Item)item).data instanceof BlockSignalSemaphoreBase || Block.getBlockFromItem((Item)item).data instanceof PlatformHelper);
    }

    private static void renderRailOneWayArrows(Rail rail, float yOffset) {
        long speedLimit1 = rail.getSpeedLimitKilometersPerHour(false);
        long speedLimit2 = rail.getSpeedLimitKilometersPerHour(true);
        if (speedLimit1 == 0L || speedLimit2 == 0L) {
            RenderRails.renderWithinRenderDistance(rail, (blockPos, x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> MainRenderer.scheduleRender(ONE_WAY_RAIL_ARROW_TEXTURE, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                IDrawing.drawTexture(graphicsHolder, x1, y1 + (double)yOffset + 0.125, z1, x2, y1 + (double)yOffset + 0.125 + (double)0.003125f, z2, x3, y2 + (double)yOffset + 0.125, z3, x4, y2 + (double)yOffset + 0.125 + (double)0.003125f, z4, offset, 0.0f, speedLimit1 == 0L ? 0.25f : 0.75f, 1.0f, speedLimit1 == 0L ? 0.75f : 0.25f, Direction.UP, -1, GraphicsHolder.getDefaultLight());
                IDrawing.drawTexture(graphicsHolder, x2, y1 + (double)yOffset + 0.125 + (double)0.003125f, z2, x1, y1 + (double)yOffset + 0.125, z1, x4, y2 + (double)yOffset + 0.125 + (double)0.003125f, z4, x3, y2 + (double)yOffset + 0.125, z3, offset, 0.0f, speedLimit1 == 0L ? 0.25f : 0.75f, 1.0f, speedLimit1 == 0L ? 0.75f : 0.25f, Direction.UP, -1, GraphicsHolder.getDefaultLight());
            }), 1.0, -1.0f, 1.0f);
        }
    }

    private static void renderRailStandard(ClientWorld clientWorld, Rail rail, RenderState renderState, float railWidth) {
        RenderRails.renderRailStandard(clientWorld, rail, 0.065625f, renderState, railWidth, renderState.hasColor ? RAIL_PREVIEW_TEXTURE : RAIL_TEXTURE, -1.0f, -1.0f, -1.0f, -1.0f);
    }

    private static void renderRailStandard(ClientWorld clientWorld, Rail rail, float yOffset, RenderState renderState, float railWidth, Identifier defaultTexture, float u1, float v1, float u2, float v2) {
        boolean[] renderType = new boolean[]{false, false};
        for (String style : rail.getStyles()) {
            String newStyle = OptimizedRenderer.hasOptimizedRendering() && Config.getClient().getDefaultRail3D() && rail.getTransportMode() == TransportMode.TRAIN ? (style.equals("default") ? (rail.isSiding() ? "default_3d_siding" : "default_3d") : style) : style;
            if (newStyle.equals("default")) {
                renderType[0] = true;
                continue;
            }
            boolean flip = newStyle.endsWith("_2");
            CustomResourceLoader.getRailById(RailResource.getIdWithoutDirection(newStyle), railResource -> RenderRails.renderWithinRenderDistance(rail, (blockPos, x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                int light = LightmapTextureManager.pack(clientWorld.getLightLevel(LightType.getBlockMapped(), blockPos), clientWorld.getLightLevel(LightType.getSkyMapped(), blockPos));
                double differenceX = x3 - x1;
                double differenceZ = z3 - z1;
                double yaw = Math.atan2(differenceZ, differenceX);
                double pitch = Math.atan2(y2 - y1, Math.sqrt(differenceX * differenceX + differenceZ * differenceZ));
                StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((x1 + x3) / 2.0, (y1 + y2) / 2.0 + railResource.getModelYOffset(), (z1 + z3) / 2.0);
                storedMatrixTransformations.add(graphicsHolder -> {
                    graphicsHolder.rotateYRadians((float)(1.5707963267948966 - yaw + (flip ? Math.PI : 0.0)));
                    graphicsHolder.rotateXRadians((float)(Math.PI - pitch * (double)(flip ? -1 : 1)));
                    graphicsHolder.rotateZDegrees((float)(x1 * z1 % 10.0) / 100.0f);
                });
                railResource.render(storedMatrixTransformations, light);
                renderType[1] = true;
            }, railResource.getRepeatInterval(), 0.0f, 0.0f));
        }
        if (renderType[0] || renderState.hasColor) {
            int color = renderState.hasColor ? (renderState == RenderState.FLASHING ? MainRenderer.getFlashingColor(RailType.getRailColor(rail), 1) : RailType.getRailColor(rail)) : -1;
            Identifier texture = renderType[1] && !renderType[0] ? IRON_BLOCK_TEXTURE : defaultTexture;
            RenderRails.renderWithinRenderDistance(rail, (blockPos, x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                float textureOffset = (float)((int)(x1 + z1) % 4) * 0.25f;
                int light = renderState == RenderState.FLASHING || renderState == RenderState.COLORED ? GraphicsHolder.getDefaultLight() : LightmapTextureManager.pack(clientWorld.getLightLevel(LightType.getBlockMapped(), blockPos), clientWorld.getLightLevel(LightType.getSkyMapped(), blockPos));
                MainRenderer.scheduleRender(texture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                    IDrawing.drawTexture(graphicsHolder, x1, y1 + (double)yOffset, z1, x2, y1 + (double)yOffset + (double)0.003125f, z2, x3, y2 + (double)yOffset, z3, x4, y2 + (double)yOffset + (double)0.003125f, z4, offset, u1 < 0.0f ? 0.0f : u1, v1 < 0.0f ? 0.1875f + textureOffset : v1, u2 < 0.0f ? 1.0f : u2, v2 < 0.0f ? 0.3125f + textureOffset : v2, Direction.UP, color, light);
                    IDrawing.drawTexture(graphicsHolder, x2, y1 + (double)yOffset + (double)0.003125f, z2, x1, y1 + (double)yOffset, z1, x4, y2 + (double)yOffset + (double)0.003125f, z4, x3, y2 + (double)yOffset, z3, offset, u1 < 0.0f ? 0.0f : u1, v1 < 0.0f ? 0.1875f + textureOffset : v1, u2 < 0.0f ? 1.0f : u2, v2 < 0.0f ? 0.3125f + textureOffset : v2, Direction.UP, color, light);
                });
            }, 0.5, -railWidth, railWidth);
        }
    }

    private static void renderSignalsStandard(ClientWorld clientWorld, Rail rail) {
        IntArrayList colors = new IntArrayList(rail.getSignalColors());
        Collections.sort(colors);
        float width = 0.0625f;
        LongArrayList preBlockedSignalColors = MinecraftClientData.getInstance().railIdToPreBlockedSignalColors.getOrDefault(rail.getHexId(), new LongArrayList());
        LongArrayList currentlyBlockedSignalColors = MinecraftClientData.getInstance().railIdToCurrentlyBlockedSignalColors.getOrDefault(rail.getHexId(), new LongArrayList());
        for (int i = 0; i < colors.size(); ++i) {
            boolean shouldFlash;
            int rawColor = colors.getInt(i);
            boolean preBlocked = preBlockedSignalColors.contains(rawColor);
            boolean currentlyBlocked = currentlyBlockedSignalColors.contains(rawColor);
            boolean bl = shouldFlash = preBlocked || currentlyBlocked;
            int color = shouldFlash ? MainRenderer.getFlashingColor(rawColor, currentlyBlocked ? 1 : 4) : 0xFF000000 | rawColor;
            float u1 = 0.0625f * (float)i + 1.0f - 0.0625f * (float)colors.size() / 2.0f;
            float u2 = u1 + 0.0625f;
            RenderRails.renderWithinRenderDistance(rail, (blockPos, x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                int light = shouldFlash ? GraphicsHolder.getDefaultLight() : LightmapTextureManager.pack(clientWorld.getLightLevel(LightType.getBlockMapped(), blockPos), clientWorld.getLightLevel(LightType.getSkyMapped(), blockPos));
                MainRenderer.scheduleRender(WOOL_TEXTURE, false, shouldFlash ? QueuedRenderLayer.EXTERIOR : QueuedRenderLayer.LIGHT, (graphicsHolder, offset) -> {
                    IDrawing.drawTexture(graphicsHolder, x1, y1 + 0.125, z1, x2, y1 + 0.125 + (double)0.003125f, z2, x3, y2 + 0.125, z3, x4, y2 + 0.125 + (double)0.003125f, z4, offset, u1, 0.0f, u2, 1.0f, Direction.UP, color, light);
                    IDrawing.drawTexture(graphicsHolder, x4, y2 + 0.125 + (double)0.003125f, z4, x3, y2 + 0.125, z3, x2, y1 + 0.125 + (double)0.003125f, z2, x1, y1 + 0.125, z1, offset, u1, 0.0f, u2, 1.0f, Direction.UP, color, light);
                });
            }, 1.0, u1 - 1.0f, u2 - 1.0f);
        }
    }

    private static void renderWithinRenderDistance(Rail rail, RenderRailWithBlockPos callback, double interval, float offsetRadius1, float offsetRadius2) {
        Camera camera = MinecraftClient.getInstance().getGameRendererMapped().getCamera();
        Vector3i cameraBlockPos = new Vector3i((class_2382)camera.getBlockPos().data);
        Vector3d cameraPosition = camera.getPos();
        int renderDistance = MinecraftClientHelper.getRenderDistance() * 16;
        rail.railMath.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
            BlockPos blockPos = Init.newBlockPos(x1, y1 + 0.1, z1);
            int distance = blockPos.getManhattanDistance(cameraBlockPos);
            if (distance <= renderDistance) {
                if (distance < 32) {
                    callback.renderRail(blockPos, x1, z1, x2, z2, x3, z3, x4, z4, y1, y2);
                } else {
                    Vector3d rotatedVector = new Vector3d(x1, y1, z1).subtract(cameraPosition).rotateY((float)Math.toRadians(camera.getYaw())).rotateX((float)Math.toRadians(camera.getPitch()));
                    if (rotatedVector.getZMapped() > 0.0) {
                        callback.renderRail(blockPos, x1, z1, x2, z2, x3, z3, x4, z4, y1, y2);
                    }
                }
            }
        }, interval, offsetRadius1, offsetRadius2);
    }

    private static void renderNode(BlockState blockState, BlockPos blockPos, BooleanSupplier shouldRender, int light) {
        if (blockState.getBlock().data instanceof BlockNode && shouldRender.getAsBoolean()) {
            StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5);
            storedMatrixTransformations.add(graphicsHolder -> {
                graphicsHolder.rotateYDegrees((float)(((Boolean)blockState.get(new Property((class_2769)BlockNode.FACING.data)) != false ? -90 : 0) + ((Boolean)blockState.get(new Property((class_2769)BlockNode.IS_45.data)) != false ? -45 : 0)) + ((Boolean)blockState.get(new Property((class_2769)BlockNode.IS_22_5.data)) != false ? -22.5f : 0.0f));
                graphicsHolder.scale(4.0f, 0.5f, 0.5f);
                graphicsHolder.translate(-0.5, 0.0, -0.5);
            });
            MODEL_SMALL_CUBE.render(storedMatrixTransformations, light);
        }
    }

    private static void renderRailStats(BlockPos renderPos, @Nullable BlockPos otherPos, double railLength, double closerRadius, double otherRadius) {
        if (railLength > 0.0) {
            String textXZRadius;
            String textXZRadiusLabel;
            String textXYZOffsetLabel = otherPos == null ? null : TranslationProvider.GUI_MTR_RAIL_XYZ_OFFSET.getString(new Object[0]);
            String textXYZOffset = otherPos == null ? null : String.format("(%s, %s, %s)", renderPos.getX() - otherPos.getX(), renderPos.getY() - otherPos.getY(), renderPos.getZ() - otherPos.getZ());
            double roundedCloserRadius = Utilities.round(closerRadius, 3);
            double roundedOtherRadius = Utilities.round(otherRadius, 3);
            if (roundedCloserRadius == 0.0 || roundedOtherRadius == 0.0 || roundedCloserRadius == roundedOtherRadius) {
                if (roundedCloserRadius == 0.0 && roundedOtherRadius == 0.0) {
                    textXZRadiusLabel = null;
                    textXZRadius = null;
                } else {
                    textXZRadiusLabel = TranslationProvider.GUI_MTR_RAIL_XZ_RADIUS.getString(new Object[0]);
                    textXZRadius = String.valueOf(roundedCloserRadius == 0.0 ? roundedOtherRadius : roundedCloserRadius);
                }
            } else {
                textXZRadiusLabel = TranslationProvider.GUI_MTR_RAIL_XZ_RADII.getString(new Object[0]);
                textXZRadius = String.format("%s, %s", roundedCloserRadius, roundedOtherRadius);
            }
            String textLengthLabel = TranslationProvider.GUI_MTR_RAIL_XZ_LENGTH.getString(new Object[0]);
            String textLength = String.valueOf(Utilities.round(railLength, 3));
            double textOffset = otherPos == null ? 0.5 : 1.0;
            MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
                graphicsHolder.push();
                graphicsHolder.translate((double)renderPos.getX() - offset.getXMapped() + 0.5, (double)renderPos.getY() - offset.getYMapped() + textOffset, (double)renderPos.getZ() - offset.getZMapped() + 0.5);
                InitClient.transformToFacePlayer(graphicsHolder, (double)renderPos.getX() + 0.5, (double)renderPos.getY() + textOffset, (double)renderPos.getZ() + 0.5);
                graphicsHolder.rotateZDegrees(180.0f);
                graphicsHolder.scale(0.03125f, 0.03125f, -0.03125f);
                int line = 0;
                if (otherPos != null) {
                    line = RenderRails.renderRailStat(graphicsHolder, textXYZOffsetLabel, textXYZOffset, line);
                }
                if (textXZRadius != null) {
                    line = RenderRails.renderRailStat(graphicsHolder, textXZRadiusLabel, textXZRadius, line);
                }
                RenderRails.renderRailStat(graphicsHolder, textLengthLabel, textLength, line);
                graphicsHolder.pop();
            });
        }
    }

    private static int renderRailStat(GraphicsHolder graphicsHolder, String title, String data, int line) {
        int newLine = line - 9;
        graphicsHolder.drawText(data, -GraphicsHolder.getTextWidth(data) / 2, newLine, -1, true, GraphicsHolder.getDefaultLight());
        graphicsHolder.push();
        graphicsHolder.scale(0.5f, 0.5f, 0.5f);
        graphicsHolder.drawText(title, -GraphicsHolder.getTextWidth(title) / 2, (newLine -= 5) * 2, -1, true, GraphicsHolder.getDefaultLight());
        graphicsHolder.pop();
        return newLine - 1;
    }

    private static ItemStack getStackInHand() {
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity != null) {
            try {
                return clientPlayerEntity.getStackInHand(clientPlayerEntity.getActiveHand());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ItemStack.getEmptyMapped();
    }

    @FunctionalInterface
    private static interface RenderRailWithBlockPos {
        public void renderRail(BlockPos var1, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20);
    }

    private static enum RenderState {
        NORMAL(false),
        COLORED(true),
        FLASHING(true);

        private final boolean hasColor;

        private RenderState(boolean hasColor) {
            this.hasColor = hasColor;
        }
    }
}

