/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.class_2382;
import org.mtr.core.data.Position;
import org.mtr.core.data.TwoPositionsBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockEntityAbstractMapping;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockNode;
import org.mtr.mod.block.BlockSignalBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderRails;
import org.mtr.mod.render.StoredMatrixTransformations;

public abstract class RenderSignalBase<T extends BlockSignalBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements IBlock,
IGui {
    protected final int aspects;
    private final float colorIndicatorHeight;

    public RenderSignalBase(BlockEntityRenderer.Argument dispatcher, int colorIndicatorHeight, int aspects) {
        super(dispatcher);
        this.aspects = aspects;
        this.colorIndicatorHeight = (float)colorIndicatorHeight / 16.0f + 0.003125f;
    }

    @Override
    public final void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = ((BlockEntityAbstractMapping)((Object)entity)).getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        BlockPos pos = ((BlockEntityAbstractMapping)((Object)entity)).getPos2();
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock().data instanceof BlockSignalBase)) {
            return;
        }
        float angle = BlockSignalBase.getAngle(state);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)((BlockEntityAbstractMapping)((Object)entity)).getPos2().getX(), ((BlockEntityAbstractMapping)((Object)entity)).getPos2().getY(), 0.5 + (double)((BlockEntityAbstractMapping)((Object)entity)).getPos2().getZ());
        int redstoneLevel = 0;
        ObjectArrayList<String> railIds1 = new ObjectArrayList<String>();
        ObjectArrayList<String> railIds2 = new ObjectArrayList<String>();
        for (int i = 0; i < (((BlockSignalBase.BlockEntityBase)((Object)entity)).isDoubleSided ? 2 : 1); ++i) {
            float newAngle = angle + (float)(i * 180);
            AspectState aspectState = RenderSignalBase.getAspectState(pos, newAngle + 90.0f);
            if (aspectState == null) continue;
            boolean isBackSide = i == 1;
            IntAVLTreeSet filterColors = ((BlockSignalBase.BlockEntityBase)((Object)entity)).getSignalColors(isBackSide);
            StoredMatrixTransformations storedMatrixTransformationsNew = storedMatrixTransformations.copy();
            storedMatrixTransformationsNew.add(graphicsHolderNew -> graphicsHolderNew.rotateYDegrees(-newAngle));
            if (RenderRails.isHoldingRailRelated(clientPlayerEntity)) {
                float xStart = -0.015625f * (float)aspectState.detectedColors.size();
                for (int j = 0; j < aspectState.detectedColors.size(); ++j) {
                    int signalColor = aspectState.detectedColors.getInt(j);
                    boolean occupied = aspectState.occupiedColors.contains(signalColor);
                    float x = xStart + (float)j * 0.03125f;
                    float width = 0.03125f / (float)(filterColors.isEmpty() || filterColors.contains(signalColor) ? 1 : 8);
                    MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/white.png"), false, occupied ? QueuedRenderLayer.EXTERIOR : QueuedRenderLayer.LIGHT, (graphicsHolderNew, offset) -> {
                        storedMatrixTransformationsNew.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                        IDrawing.drawTexture(graphicsHolderNew, x, this.colorIndicatorHeight, -0.15625f, x + 0.03125f, this.colorIndicatorHeight, -0.15625f, x + 0.03125f, this.colorIndicatorHeight, -0.15625f - width, x, this.colorIndicatorHeight, -0.15625f - width, 0.0f, 0.0f, 1.0f, 1.0f, Direction.UP, occupied ? MainRenderer.getFlashingColor(signalColor, 1) : signalColor | 0xFF000000, GraphicsHolder.getDefaultLight());
                        graphicsHolderNew.pop();
                    });
                }
            }
            int occupiedAspect = ((BlockSignalBase.BlockEntityBase)((Object)entity)).getActualAspect(filterColors.isEmpty() && aspectState.nodeBlocked || aspectState.occupiedColors.intStream().anyMatch(color -> filterColors.isEmpty() || filterColors.contains(color)), isBackSide);
            this.render(storedMatrixTransformationsNew, entity, tickDelta, occupiedAspect, isBackSide);
            if (occupiedAspect > 0 && occupiedAspect < this.aspects) {
                redstoneLevel = Math.max(redstoneLevel, (4 - occupiedAspect) * 5);
            }
            (isBackSide ? railIds2 : railIds1).addAll(aspectState.railIds);
        }
        ((BlockSignalBase.BlockEntityBase)((Object)entity)).checkForRedstoneUpdate(redstoneLevel, railIds1, railIds2);
    }

    protected abstract void render(StoredMatrixTransformations var1, T var2, float var3, int var4, boolean var5);

    @Nullable
    public static AspectState getAspectState(BlockPos blockPos, float angle) {
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            return null;
        }
        BlockPos startPos = RenderSignalBase.getNodePos(clientWorld, blockPos, Direction.fromRotation(angle));
        if (startPos == null) {
            return null;
        }
        MinecraftClientData minecraftClientData = MinecraftClientData.getInstance();
        IntArrayList detectedColors = new IntArrayList();
        IntAVLTreeSet occupiedColors = new IntAVLTreeSet();
        boolean[] blocked = new boolean[]{false};
        ObjectArrayList railIds = new ObjectArrayList();
        Position startPosition = Init.blockPosToPosition(startPos);
        minecraftClientData.positionsToRail.getOrDefault(startPosition, new Object2ObjectOpenHashMap()).forEach((endPosition, rail) -> {
            if (Math.abs(Utilities.circularDifference(Math.round(Math.toDegrees(Math.atan2(endPosition.getZ() - (long)startPos.getZ(), endPosition.getX() - (long)startPos.getX()))), Math.round(angle), 360L)) < 90L) {
                rail.getSignalColors().forEach(detectedColors::add);
                String railId = rail.getHexId();
                minecraftClientData.railIdToCurrentlyBlockedSignalColors.getOrDefault(railId, new LongArrayList()).forEach(color -> occupiedColors.add((int)color));
                if (minecraftClientData.blockedRailIds.contains(TwoPositionsBase.getHexIdRaw(startPosition, endPosition))) {
                    blocked[0] = true;
                }
                railIds.add(railId);
            }
        });
        Collections.sort(detectedColors);
        return new AspectState(detectedColors, occupiedColors, blocked[0], railIds);
    }

    @Nullable
    private static BlockPos getNodePos(ClientWorld world, BlockPos pos, Direction facing) {
        int closestDistance = Integer.MAX_VALUE;
        BlockPos closestPos = null;
        for (int z = -4; z <= 4; ++z) {
            for (int x = -4; x <= 4; ++x) {
                for (int y = -5; y <= 5; ++y) {
                    BlockPos checkPos = pos.up(y).offset(facing.rotateYClockwise(), x).offset(facing, z);
                    BlockState checkState = world.getBlockState(checkPos);
                    int distance = checkPos.getManhattanDistance(new Vector3i((class_2382)pos.data));
                    if (!(checkState.getBlock().data instanceof BlockNode) || distance >= closestDistance) continue;
                    closestDistance = distance;
                    closestPos = checkPos;
                }
            }
        }
        return closestPos;
    }

    public static class AspectState {
        public final IntArrayList detectedColors;
        private final IntAVLTreeSet occupiedColors;
        private final boolean nodeBlocked;
        private final ObjectArrayList<String> railIds;

        private AspectState(IntArrayList detectedColors, IntAVLTreeSet occupiedColors, boolean nodeBlocked, ObjectArrayList<String> railIds) {
            this.detectedColors = detectedColors;
            this.occupiedColors = occupiedColors;
            this.nodeBlocked = nodeBlocked;
            this.railIds = railIds;
        }
    }
}

