/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import java.util.Comparator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.mtr.core.data.Data;
import org.mtr.core.data.Vehicle;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectDoubleImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.OverlayTexture;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mapping.mapper.OptimizedRenderer;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.MutableBox;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.ScrollingText;
import org.mtr.mod.data.IGui;
import org.mtr.mod.data.VehicleExtension;
import org.mtr.mod.generated.resource.ModelPropertiesPartSchema;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.DisplayOption;
import org.mtr.mod.resource.DisplayType;
import org.mtr.mod.resource.DoorAnimationType;
import org.mtr.mod.resource.ModelDisplayPart;
import org.mtr.mod.resource.ModelPropertiesPartWrapper;
import org.mtr.mod.resource.OptimizedModelWrapper;
import org.mtr.mod.resource.PartCondition;
import org.mtr.mod.resource.PartPosition;
import org.mtr.mod.resource.PartType;
import org.mtr.mod.resource.PositionDefinition;
import org.mtr.mod.resource.PositionDefinitions;
import org.mtr.mod.resource.RenderStage;
import org.mtr.mod.resource.VehicleResource;

public final class ModelPropertiesPart
extends ModelPropertiesPartSchema
implements IGui {
    private final ObjectArrayList<PartDetails> partDetailsList = new ObjectArrayList();
    private final ObjectArrayList<DisplayPartDetails> displayPartDetailsList = new ObjectArrayList();
    private final int displayColorCjkInt;
    private final int displayColorInt;
    private static final int LINE_PADDING = 2;

    public ModelPropertiesPart(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
        this.displayColorInt = ModelPropertiesPart.parseColor(this.displayColor, 0xFF9900);
        this.displayColorCjkInt = ModelPropertiesPart.parseColor(this.displayColorCjk, this.displayColorInt);
    }

    ModelPropertiesPart(ObjectSet<String> names) {
        super(PartCondition.NORMAL, RenderStage.EXTERIOR, PartType.NORMAL, 0.0, 0.0, "", "", 0.0, 0.0, 0.0, DisplayType.DESTINATION, "", 0.0, 0.0, DoorAnimationType.STANDARD, 0L, 0L, 0L, 0L, 0L, 0L);
        this.names.addAll(names);
        this.positionDefinitions.add("");
        this.displayColorInt = 0;
        this.displayColorCjkInt = 0;
    }

    ModelPropertiesPart(ObjectArrayList<String> names, ObjectArrayList<String> positionDefinitions, PartCondition condition, RenderStage renderStage, PartType type, double displayXPadding, double displayYPadding, String displayColorCjk, String displayColor, double displayMaxLineHeight, double displayCjkSizeRatio, ObjectArrayList<String> displayOptions, double displayPadZeros, DisplayType displayType, String displayDefaultText, double doorXMultiplier, double doorZMultiplier, DoorAnimationType doorAnimationType, long renderFromOpeningDoorTime, long renderUntilOpeningDoorTime, long renderFromClosingDoorTime, long renderUntilClosingDoorTime, long flashOnTime, long flashOffTime) {
        super(condition, renderStage, type, displayXPadding, displayYPadding, displayColorCjk, displayColor, displayMaxLineHeight, displayCjkSizeRatio, displayPadZeros, displayType, displayDefaultText, doorXMultiplier, doorZMultiplier, doorAnimationType, renderFromOpeningDoorTime, renderUntilOpeningDoorTime, renderFromClosingDoorTime, renderUntilClosingDoorTime, flashOnTime, flashOffTime);
        this.names.addAll(names);
        this.positionDefinitions.addAll(positionDefinitions);
        this.displayOptions.addAll(displayOptions);
        this.displayColorInt = ModelPropertiesPart.parseColor(displayColor, 0xFF9900);
        this.displayColorCjkInt = ModelPropertiesPart.parseColor(displayColorCjk, this.displayColorInt);
    }

    public void writeCache(Identifier texture, Object2ObjectOpenHashMap<String, ObjectObjectImmutablePair<ModelPartExtension, MutableBox>> nameToPart, Object2ObjectOpenHashMap<String, ObjectArrayList<ModelDisplayPart>> nameToDisplayParts, PositionDefinitions positionDefinitionsObject, ObjectArraySet<Box> floors, ObjectArraySet<Box> doorways, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsForPartConditionAndRenderStage, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsForPartConditionAndRenderStageDoorsClosed) {
        OptimizedModelWrapper optimizedModelDoor;
        ObjectArrayList<ModelPartExtension> modelParts = new ObjectArrayList<ModelPartExtension>();
        MutableBox mutableBox = new MutableBox();
        ObjectArrayList modelDisplayParts = new ObjectArrayList();
        this.names.forEach(name -> {
            ObjectArrayList displayParts;
            ObjectObjectImmutablePair part = (ObjectObjectImmutablePair)nameToPart.get(name);
            if (part != null) {
                modelParts.add((ModelPartExtension)((Object)part.left()));
                mutableBox.add((MutableBox)part.right());
            }
            if ((displayParts = (ObjectArrayList)nameToDisplayParts.get(name)) != null) {
                modelDisplayParts.add(displayParts);
            }
        });
        if (this.isDoor()) {
            OptimizedModelWrapper.MaterialGroupWrapper materialGroup = new OptimizedModelWrapper.MaterialGroupWrapper(this.renderStage.shaderType, texture);
            modelParts.forEach(modelPart -> materialGroup.addCube((ModelPartExtension)((Object)modelPart), 0.0, 0.0, 0.0, false, 0xF000B0));
            optimizedModelDoor = OptimizedModelWrapper.fromMaterialGroups(ObjectArrayList.of(new OptimizedModelWrapper.MaterialGroupWrapper[]{materialGroup}));
        } else {
            optimizedModelDoor = null;
        }
        this.positionDefinitions.forEach(positionDefinitionName -> positionDefinitionsObject.getPositionDefinition((String)positionDefinitionName, (positions, positionsFlipped) -> {
            switch (this.type) {
                case NORMAL: {
                    ModelPropertiesPart.iteratePositions(positions, positionsFlipped, (x, y, z, flipped) -> {
                        if (!this.isDoor()) {
                            this.addCube(texture, modelParts, materialGroupsForPartConditionAndRenderStage, x, y, z, flipped);
                        }
                        this.addCube(texture, modelParts, materialGroupsForPartConditionAndRenderStageDoorsClosed, x, y, z, flipped);
                        this.partDetailsList.add(new PartDetails(modelParts, optimizedModelDoor, ModelPropertiesPart.addBox(mutableBox.get(), x, y, z, flipped), x, y, z, flipped));
                    });
                    break;
                }
                case DISPLAY: {
                    ModelPropertiesPart.iteratePositions(positions, positionsFlipped, (x, y, z, flipped) -> this.displayPartDetailsList.add(new DisplayPartDetails(modelDisplayParts, x, y, z, flipped)));
                    break;
                }
                case FLOOR: {
                    ModelPropertiesPart.iteratePositions(positions, positionsFlipped, (x, y, z, flipped) -> mutableBox.getAll().forEach(box -> floors.add(ModelPropertiesPart.addBox(box, x, y, z, flipped))));
                    break;
                }
                case DOORWAY: {
                    ModelPropertiesPart.iteratePositions(positions, positionsFlipped, (x, y, z, flipped) -> mutableBox.getAll().forEach(box -> doorways.add(ModelPropertiesPart.addBox(box, x, y, z, flipped))));
                }
            }
        }));
    }

    public void writeCache(Map<String, OptimizedModel.ObjModel> nameToObjModels, PositionDefinitions positionDefinitionsObject, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>> objModelsForPartConditionAndRenderStage, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>> objModelsForPartConditionAndRenderStageDoorsClosed, double modelYOffset) {
        ObjectArrayList objModels = new ObjectArrayList();
        MutableBox mutableBox = new MutableBox();
        this.names.forEach(name -> {
            OptimizedModel.ObjModel objModel = (OptimizedModel.ObjModel)nameToObjModels.get(name);
            if (objModel != null) {
                objModels.add(new OptimizedModelWrapper.ObjModelWrapper(objModel));
                mutableBox.add(new Box(-objModel.getMinX(), -objModel.getMinY(), -objModel.getMinZ(), -objModel.getMaxX(), -objModel.getMaxY(), -objModel.getMaxZ()));
            }
        });
        Supplier<OptimizedModelWrapper> optimizedModelDoor = () -> this.isDoor() ? OptimizedModelWrapper.fromObjModels(objModels) : null;
        this.positionDefinitions.forEach(positionDefinitionName -> positionDefinitionsObject.getPositionDefinition((String)positionDefinitionName, (arg_0, arg_1) -> this.lambda$null$13(objModels, objModelsForPartConditionAndRenderStage, modelYOffset, objModelsForPartConditionAndRenderStageDoorsClosed, (Supplier)optimizedModelDoor, mutableBox, arg_0, arg_1)));
    }

    public void render(Identifier texture, StoredMatrixTransformations storedMatrixTransformations, @Nullable VehicleExtension vehicle, int carNumber, int[] scrollingDisplayIndexTracker, int light, ObjectArrayList<ObjectDoubleImmutablePair<Box>> openDoorways, boolean fromResourcePackCreator) {
        if (vehicle == null || VehicleResource.matchesCondition(vehicle, this.condition, openDoorways.isEmpty())) {
            switch (this.type) {
                case NORMAL: {
                    ObjectIntImmutablePair<QueuedRenderLayer> renderProperties = ModelPropertiesPart.getRenderProperties(this.renderStage, light, vehicle);
                    if (OptimizedRenderer.hasOptimizedRendering()) {
                        MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> this.renderNormal(storedMatrixTransformations, vehicle, renderProperties, openDoorways, light, (GraphicsHolder)graphicsHolder, (Vector3d)offset));
                        break;
                    }
                    MainRenderer.scheduleRender(texture, false, renderProperties.left(), (graphicsHolder, offset) -> this.renderNormal(storedMatrixTransformations, vehicle, renderProperties, openDoorways, light, (GraphicsHolder)graphicsHolder, (Vector3d)offset));
                    break;
                }
                case DISPLAY: {
                    if (vehicle == null) break;
                    if (this.displayType == DisplayType.ROUTE_COLOR || this.displayType == DisplayType.ROUTE_COLOR_ROUNDED) {
                        this.renderLineColor(storedMatrixTransformations, vehicle, fromResourcePackCreator);
                        break;
                    }
                    if (this.displayOptions.contains(DisplayOption.SEVEN_SEGMENT.toString())) {
                        this.renderSevenSegmentDisplay(storedMatrixTransformations, vehicle);
                        break;
                    }
                    if (this.displayOptions.contains(DisplayOption.SCROLL_NORMAL.toString()) || this.displayOptions.contains(DisplayOption.SCROLL_LIGHT_RAIL.toString())) {
                        this.renderScrollingDisplay(storedMatrixTransformations, vehicle, carNumber, scrollingDisplayIndexTracker);
                        break;
                    }
                    this.renderDisplay(storedMatrixTransformations, vehicle);
                }
            }
        }
    }

    public void getOpenDoorBounds(ObjectArrayList<Box> boxes, double time) {
        if (this.isDoor()) {
            this.partDetailsList.forEach(partDetails -> {
                double x = this.doorAnimationType.getDoorAnimationX(this.doorXMultiplier, ((PartDetails)partDetails).flipped, time) / 16.0;
                double z = this.doorAnimationType.getDoorAnimationZ(this.doorZMultiplier, ((PartDetails)partDetails).flipped, time, true) / 16.0;
                Box box = ((PartDetails)partDetails).box;
                float xOffset = box.getMinXMapped() == box.getMaxXMapped() ? 0.1f : 0.0f;
                float yOffset = box.getMinYMapped() == box.getMaxYMapped() ? 0.1f : 0.0f;
                float zOffset = box.getMinZMapped() == box.getMaxZMapped() ? 0.1f : 0.0f;
                boxes.add(new Box(box.getMinXMapped() - (double)xOffset + x, box.getMinYMapped() - (double)yOffset, box.getMinZMapped() - (double)zOffset + z, box.getMaxXMapped() + (double)xOffset + x, box.getMaxYMapped() + (double)yOffset, box.getMaxZMapped() + (double)zOffset + z));
            });
        }
    }

    void addToModelPropertiesPartWrapperMap(PositionDefinitions actualPositionDefinitions, ObjectArrayList<ModelPropertiesPartWrapper> parts) {
        this.names.forEach(modelPartName -> this.positionDefinitions.forEach(positionDefinitionName -> actualPositionDefinitions.getPositionDefinition((String)positionDefinitionName, (positions, positionsFlipped) -> parts.add(new ModelPropertiesPartWrapper(new PositionDefinition((String)modelPartName, (ObjectArrayList<PartPosition>)positions, (ObjectArrayList<PartPosition>)positionsFlipped), this.condition, this.renderStage, this.type, this.displayXPadding, this.displayYPadding, this.displayColorCjk, this.displayColor, this.displayMaxLineHeight, this.displayCjkSizeRatio, this.displayOptions, this.displayPadZeros, this.displayType, this.displayDefaultText, this.doorXMultiplier, this.doorZMultiplier, this.doorAnimationType, this.renderFromOpeningDoorTime, this.renderUntilOpeningDoorTime, this.renderFromClosingDoorTime, this.renderUntilClosingDoorTime, this.flashOnTime, this.flashOffTime)))));
    }

    void mapDoors(ObjectArrayList<Box> doorways) {
        if (this.isDoor()) {
            this.partDetailsList.forEach(partDetails -> doorways.stream().min(Comparator.comparingDouble(checkDoorway -> ModelPropertiesPart.getClosestDistance(((PartDetails)partDetails).box.getMinXMapped(), ((PartDetails)partDetails).box.getMaxXMapped(), checkDoorway.getMinXMapped(), checkDoorway.getMaxXMapped()) + ModelPropertiesPart.getClosestDistance(((PartDetails)partDetails).box.getMinYMapped(), ((PartDetails)partDetails).box.getMaxYMapped(), checkDoorway.getMinYMapped(), checkDoorway.getMaxYMapped()) + ModelPropertiesPart.getClosestDistance(((PartDetails)partDetails).box.getMinZMapped(), ((PartDetails)partDetails).box.getMaxZMapped(), checkDoorway.getMinZMapped(), checkDoorway.getMaxZMapped()))).ifPresent(closestDoorway -> ((PartDetails)partDetails).doorway = closestDoorway));
        }
    }

    private boolean isDoor() {
        return this.doorXMultiplier != 0.0 || this.doorZMultiplier != 0.0;
    }

    private void renderNormal(StoredMatrixTransformations storedMatrixTransformations, @Nullable VehicleExtension vehicle, ObjectIntImmutablePair<QueuedRenderLayer> renderProperties, ObjectArrayList<ObjectDoubleImmutablePair<Box>> openDoorways, int light, GraphicsHolder graphicsHolder, Vector3d offset) {
        storedMatrixTransformations.transform(graphicsHolder, offset);
        boolean flashOn = this.flashOnTime + this.flashOffTime == 0L || System.currentTimeMillis() % (this.flashOnTime + this.flashOffTime) > this.flashOffTime;
        this.partDetailsList.forEach(partDetails -> {
            float z;
            float x;
            float y;
            float f = y = flashOn ? (float)((PartDetails)partDetails).y : 2.1474836E9f;
            if (vehicle == null) {
                x = (float)((PartDetails)partDetails).x;
                z = (float)((PartDetails)partDetails).z;
            } else {
                boolean opening;
                double doorOverrideValue = 0.0;
                boolean canOpen = false;
                for (ObjectDoubleImmutablePair openDoorway : openDoorways) {
                    if (!((Box)openDoorway.left()).equals(((PartDetails)partDetails).doorway)) continue;
                    doorOverrideValue = openDoorway.rightDouble();
                    canOpen = true;
                    break;
                }
                double doorValue = canOpen ? vehicle.persistentVehicleData.getDoorValue() : 0.0;
                boolean bl = opening = vehicle.persistentVehicleData.getAdjustedDoorMultiplier(vehicle.vehicleExtraData) > 0;
                boolean shouldRender = opening ? this.renderFromOpeningDoorTime == 0L && this.renderUntilOpeningDoorTime == 0L || Utilities.isBetween(Math.abs(doorValue) * 3200.0, this.renderFromOpeningDoorTime, this.renderUntilOpeningDoorTime) : this.renderFromClosingDoorTime == 0L && this.renderUntilClosingDoorTime == 0L || Utilities.isBetween(Math.abs(doorValue) * 3200.0, this.renderFromClosingDoorTime, this.renderUntilClosingDoorTime);
                float f2 = x = shouldRender ? (float)(((PartDetails)partDetails).x + this.doorAnimationType.getDoorAnimationX(this.doorXMultiplier, ((PartDetails)partDetails).flipped, Math.max(doorValue, doorOverrideValue))) : 2.1474836E9f;
                float f3 = shouldRender ? (float)(((PartDetails)partDetails).z + (double)(canOpen ? vehicle.persistentVehicleData.getInterpolatedDoorValue(this.doorAnimationType, this.doorZMultiplier, ((PartDetails)partDetails).flipped, doorOverrideValue, opening) : 0.0f)) : (z = 2.1474836E9f);
            }
            if (OptimizedRenderer.hasOptimizedRendering()) {
                if (!openDoorways.isEmpty() && ((PartDetails)partDetails).optimizedModelDoor != null) {
                    graphicsHolder.push();
                    graphicsHolder.translate(x / 16.0f, y / 16.0f, z / 16.0f);
                    if (((PartDetails)partDetails).flipped) {
                        graphicsHolder.rotateYDegrees(180.0f);
                    }
                    CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.queue(((PartDetails)partDetails).optimizedModelDoor, graphicsHolder, light);
                    graphicsHolder.pop();
                }
            } else {
                ((PartDetails)partDetails).modelParts.forEach(modelPart -> modelPart.render(graphicsHolder, x, y, z, ((PartDetails)partDetails).flipped ? (float)Math.PI : 0.0f, renderProperties.rightInt(), OverlayTexture.getDefaultUvMapped()));
            }
        });
        graphicsHolder.pop();
    }

    private void renderLineColor(StoredMatrixTransformations storedMatrixTransformations, VehicleExtension vehicle, boolean fromResourcePackCreator) {
        int color = fromResourcePackCreator ? 0xFF000000 | ModelPropertiesPart.rainbowColor() : ModelPropertiesPart.getOrDefault(0xFF000000 | vehicle.vehicleExtraData.getThisRouteColor(), 0xFF000000 | vehicle.vehicleExtraData.getNextRouteColor(), 0xFF000000 | vehicle.vehicleExtraData.getPreviousRouteColor(), 0, vehicle);
        MainRenderer.scheduleRender(new Identifier("mtr", String.format("textures/block/%s.png", this.displayType == DisplayType.ROUTE_COLOR ? "white" : "sign/circle")), true, QueuedRenderLayer.LIGHT_2, (graphicsHolder, offset) -> {
            storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
            this.displayPartDetailsList.forEach(displayPartDetails -> {
                graphicsHolder.push();
                graphicsHolder.translate(((DisplayPartDetails)displayPartDetails).x, ((DisplayPartDetails)displayPartDetails).y, ((DisplayPartDetails)displayPartDetails).z);
                graphicsHolder.rotateYDegrees(((DisplayPartDetails)displayPartDetails).flipped ? 180.0f : 0.0f);
                ((DisplayPartDetails)displayPartDetails).modelDisplayParts.forEach(displayParts -> displayParts.forEach(displayPart -> {
                    displayPart.storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, Vector3d.getZeroMapped());
                    graphicsHolder.translate(this.displayXPadding / 16.0, this.displayYPadding / 16.0, -0.003125f);
                    IDrawing.drawTexture(graphicsHolder, 0.0f, 0.0f, ((float)displayPart.width - (float)this.displayXPadding * 2.0f) / 16.0f, ((float)displayPart.height - (float)this.displayYPadding * 2.0f) / 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.UP, color, GraphicsHolder.getDefaultLight());
                    graphicsHolder.pop();
                }));
                graphicsHolder.pop();
            });
            graphicsHolder.pop();
        });
    }

    private void renderSevenSegmentDisplay(StoredMatrixTransformations storedMatrixTransformations, VehicleExtension vehicle) {
        String text = this.formatText(vehicle);
        IGui.HorizontalAlignment horizontalAlignment = this.getHorizontalAlignment(false);
        MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/sign/seven_segment.png"), true, QueuedRenderLayer.LIGHT_2, (graphicsHolder, offset) -> {
            storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
            this.displayPartDetailsList.forEach(displayPartDetails -> {
                graphicsHolder.push();
                graphicsHolder.translate(((DisplayPartDetails)displayPartDetails).x, ((DisplayPartDetails)displayPartDetails).y, ((DisplayPartDetails)displayPartDetails).z);
                graphicsHolder.rotateYDegrees(((DisplayPartDetails)displayPartDetails).flipped ? 180.0f : 0.0f);
                ((DisplayPartDetails)displayPartDetails).modelDisplayParts.forEach(displayParts -> displayParts.forEach(displayPart -> {
                    displayPart.storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, Vector3d.getZeroMapped());
                    graphicsHolder.translate(0.0, this.displayYPadding / 16.0, -0.003125f);
                    IDrawing.drawSevenSegment(graphicsHolder, text, ((float)displayPart.width - (float)this.displayXPadding * 2.0f) / 16.0f, 0.0f, 0.0f, ((float)displayPart.height - (float)this.displayYPadding * 2.0f) / 16.0f, horizontalAlignment, 0xFF000000 | this.displayColorInt, GraphicsHolder.getDefaultLight());
                    graphicsHolder.pop();
                }));
                graphicsHolder.pop();
            });
            graphicsHolder.pop();
        });
    }

    private void renderScrollingDisplay(StoredMatrixTransformations storedMatrixTransformations, VehicleExtension vehicle, int carNumber, int[] scrollingDisplayIndexTracker) {
        String text = this.formatText(vehicle);
        ObjectArrayList<ScrollingText> scrollingTexts = vehicle.persistentVehicleData.getScrollingText(carNumber);
        this.displayPartDetailsList.forEach(displayPartDetails -> {
            StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
            storedMatrixTransformations1.add(graphicsHolder -> {
                graphicsHolder.translate(((DisplayPartDetails)displayPartDetails).x, ((DisplayPartDetails)displayPartDetails).y, ((DisplayPartDetails)displayPartDetails).z);
                graphicsHolder.rotateYDegrees(((DisplayPartDetails)displayPartDetails).flipped ? 180.0f : 0.0f);
            });
            ((DisplayPartDetails)displayPartDetails).modelDisplayParts.forEach(displayParts -> displayParts.forEach(displayPart -> {
                StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations1.copy();
                storedMatrixTransformations2.add(displayPart.storedMatrixTransformations);
                storedMatrixTransformations2.add(graphicsHolder -> graphicsHolder.translate(this.displayXPadding / 16.0, this.displayYPadding / 16.0, -0.003125f));
                double width = ((double)displayPart.width - this.displayXPadding * 2.0) / 16.0;
                double height = ((double)displayPart.height - this.displayYPadding * 2.0) / 16.0;
                while (scrollingTexts.size() <= scrollingDisplayIndexTracker[0]) {
                    scrollingTexts.add(new ScrollingText(width, height, 4, height < 0.1));
                }
                ((ScrollingText)scrollingTexts.get(scrollingDisplayIndexTracker[0])).changeImage(text.isEmpty() ? null : DynamicTextureCache.instance.getPixelatedText(text, 0xFF000000 | this.displayColorInt, Integer.MAX_VALUE, this.displayCjkSizeRatio, height < 0.1));
                ((ScrollingText)scrollingTexts.get(scrollingDisplayIndexTracker[0])).scrollText(storedMatrixTransformations2);
                scrollingDisplayIndexTracker[0] = scrollingDisplayIndexTracker[0] + 1;
            }));
        });
    }

    private void renderDisplay(StoredMatrixTransformations storedMatrixTransformations, VehicleExtension vehicle) {
        String[] textSplit = this.formatText(vehicle).split("\\|");
        boolean[] isCjk = new boolean[textSplit.length];
        double[] textHeightScale = new double[textSplit.length];
        double tempTotalHeight = 0.0;
        for (int i = 0; i < textSplit.length; ++i) {
            isCjk[i] = IGui.isCjk(textSplit[i]);
            textHeightScale[i] = isCjk[i] ? (this.displayCjkSizeRatio <= 0.0 ? 1.0 : this.displayCjkSizeRatio) : 1.0;
            tempTotalHeight += textHeightScale[i];
        }
        double rawTextHeight = tempTotalHeight;
        MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
            storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
            this.displayPartDetailsList.forEach(displayPartDetails -> {
                graphicsHolder.push();
                graphicsHolder.translate(((DisplayPartDetails)displayPartDetails).x, ((DisplayPartDetails)displayPartDetails).y, ((DisplayPartDetails)displayPartDetails).z);
                graphicsHolder.rotateYDegrees(((DisplayPartDetails)displayPartDetails).flipped ? 180.0f : 0.0f);
                ((DisplayPartDetails)displayPartDetails).modelDisplayParts.forEach(displayParts -> displayParts.forEach(displayPart -> {
                    displayPart.storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, Vector3d.getZeroMapped());
                    double totalTextHeight = Math.min((double)displayPart.height - this.displayYPadding * 2.0, this.displayMaxLineHeight <= 0.0 ? Double.MAX_VALUE : this.displayMaxLineHeight * rawTextHeight) / 16.0;
                    double textScale = totalTextHeight / rawTextHeight / 10.0;
                    graphicsHolder.translate(this.displayXPadding / 16.0, this.displayYPadding / 16.0 + (double)Math.max(0.0f, this.getVerticalAlignment().getOffset(0.0f, (float)(totalTextHeight - ((double)displayPart.height - this.displayYPadding * 2.0) / 16.0))), -0.003125f);
                    for (int i = 0; i < textSplit.length; ++i) {
                        double availableTextWidth = ((double)displayPart.width - this.displayXPadding * 2.0) / 16.0;
                        double newTextScale = textHeightScale[i] * textScale;
                        MutableText mutableText = IDrawing.withMTRFont(TextHelper.literal(textSplit[i]));
                        double textWidth = (double)GraphicsHolder.getTextWidth(mutableText) * newTextScale;
                        IGui.HorizontalAlignment horizontalAlignment = this.getHorizontalAlignment(isCjk[i]);
                        graphicsHolder.push();
                        graphicsHolder.translate(Math.max(0.0f, horizontalAlignment.getOffset(0.0f, (float)(textWidth - availableTextWidth))), 0.0, 0.0);
                        graphicsHolder.scale((float)(Math.min(1.0, availableTextWidth / textWidth) * newTextScale), (float)newTextScale, 1.0f);
                        graphicsHolder.drawText(mutableText, 0, 0, isCjk[i] ? this.displayColorCjkInt : this.displayColorInt, false, GraphicsHolder.getDefaultLight());
                        graphicsHolder.pop();
                        graphicsHolder.translate(0.0, newTextScale * 10.0, 0.0);
                    }
                    graphicsHolder.pop();
                }));
                graphicsHolder.pop();
            });
            graphicsHolder.pop();
        });
    }

    private void addCube(Identifier texture, ObjectArrayList<ModelPartExtension> modelParts, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsForPartConditionAndRenderStage, double x, double y, double z, boolean flipped) {
        modelParts.forEach(modelPart -> Data.put(materialGroupsForPartConditionAndRenderStage, this.condition, this.renderStage, oldValue -> {
            OptimizedModelWrapper.MaterialGroupWrapper materialGroup = oldValue == null ? new OptimizedModelWrapper.MaterialGroupWrapper(this.renderStage.shaderType, texture) : oldValue;
            materialGroup.addCube((ModelPartExtension)((Object)modelPart), (x + this.doorAnimationType.getDoorAnimationX(this.doorXMultiplier, flipped, 0.0)) / 16.0, y / 16.0, (z + this.doorAnimationType.getDoorAnimationZ(this.doorZMultiplier, flipped, 0.0, false)) / 16.0, flipped, 0xF000B0);
            return materialGroup;
        }, Object2ObjectOpenHashMap::new));
    }

    private void addObjModelPosition(ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper> objModels, Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>> objModelsForPartConditionAndRenderStage, double x, double y, double z, boolean flipped, double modelYOffset) {
        objModels.forEach(objModel -> Data.put(objModelsForPartConditionAndRenderStage, this.condition, this.renderStage, oldValue -> {
            ObjectArrayList newObjModels = oldValue == null ? new ObjectArrayList() : oldValue;
            objModel.addTransformation(this.renderStage.shaderType, (x + this.doorAnimationType.getDoorAnimationX(this.doorXMultiplier, flipped, 0.0)) / 16.0, y / 16.0 - modelYOffset, (z + this.doorAnimationType.getDoorAnimationZ(this.doorZMultiplier, flipped, 0.0, false)) / 16.0, flipped);
            newObjModels.add(objModel);
            return newObjModels;
        }, Object2ObjectOpenHashMap::new));
    }

    private String formatText(Vehicle vehicle) {
        String text;
        String destination = ModelPropertiesPart.getOrDefault(vehicle.vehicleExtraData.getThisRouteDestination(), vehicle.vehicleExtraData.getNextRouteDestination(), vehicle.vehicleExtraData.getPreviousRouteDestination(), this.displayDefaultText, vehicle);
        String routeNumber = ModelPropertiesPart.getOrDefault(vehicle.vehicleExtraData.getThisRouteNumber(), vehicle.vehicleExtraData.getNextRouteNumber(), vehicle.vehicleExtraData.getPreviousRouteNumber(), this.displayDefaultText, vehicle);
        String routeName = ModelPropertiesPart.getOrDefault(routeNumber + " ", routeNumber, "") + ModelPropertiesPart.getOrDefault(vehicle.vehicleExtraData.getThisRouteName(), vehicle.vehicleExtraData.getNextRouteName(), vehicle.vehicleExtraData.getPreviousRouteName(), this.displayDefaultText, vehicle);
        String thisStation = ModelPropertiesPart.getOrDefault(vehicle.vehicleExtraData.getThisStationName(), vehicle.vehicleExtraData.getPreviousStationName());
        String nextStation = ModelPropertiesPart.getOrDefault(vehicle.vehicleExtraData.getNextStationName(), vehicle.vehicleExtraData.getThisStationName(), vehicle.vehicleExtraData.getThisStationName());
        boolean doorsOpen = vehicle.vehicleExtraData.getDoorMultiplier() > 0;
        switch (this.displayType) {
            case DESTINATION: {
                text = vehicle.getIsOnRoute() ? destination : this.displayDefaultText;
                break;
            }
            case ROUTE_NUMBER: {
                text = vehicle.getIsOnRoute() ? routeNumber : this.displayDefaultText;
                break;
            }
            case DEPARTURE_INDEX: {
                if (vehicle.getIsOnRoute()) {
                    int startLength;
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(vehicle.getDepartureIndex() + 1L));
                    int i = startLength = stringBuilder.length();
                    while ((double)i < this.displayPadZeros) {
                        stringBuilder.insert(0, "0");
                        ++i;
                    }
                    text = stringBuilder.toString();
                    break;
                }
                text = this.displayDefaultText;
                break;
            }
            case NEXT_STATION: {
                text = vehicle.getIsOnRoute() ? (doorsOpen ? thisStation : nextStation) : this.displayDefaultText;
                break;
            }
            case NEXT_STATION_KCR: {
                text = vehicle.getIsOnRoute() ? DisplayType.getHongKongNextStationString(thisStation, nextStation, doorsOpen, true) : this.displayDefaultText;
                break;
            }
            case NEXT_STATION_MTR: {
                text = vehicle.getIsOnRoute() ? DisplayType.getHongKongNextStationString(thisStation, nextStation, doorsOpen, false) : this.displayDefaultText;
                break;
            }
            case NEXT_STATION_UK: {
                text = vehicle.getIsOnRoute() ? DisplayType.getLondonNextStationString(routeName, thisStation, nextStation, vehicle.vehicleExtraData::iterateInterchanges, destination, doorsOpen, vehicle.vehicleExtraData.getIsTerminating()) : this.displayDefaultText;
                break;
            }
            default: {
                text = "";
            }
        }
        String newText = text;
        for (String displayOption : this.displayOptions) {
            newText = EnumHelper.valueOf(DisplayOption.NONE, displayOption).format(newText);
        }
        return newText;
    }

    private IGui.HorizontalAlignment getHorizontalAlignment(boolean isCjk) {
        if (isCjk) {
            if (this.displayOptions.contains(DisplayOption.ALIGN_LEFT_CJK.toString())) {
                return IGui.HorizontalAlignment.LEFT;
            }
            if (this.displayOptions.contains(DisplayOption.ALIGN_RIGHT_CJK.toString())) {
                return IGui.HorizontalAlignment.RIGHT;
            }
            return IGui.HorizontalAlignment.CENTER;
        }
        if (this.displayOptions.contains(DisplayOption.ALIGN_LEFT.toString())) {
            return IGui.HorizontalAlignment.LEFT;
        }
        if (this.displayOptions.contains(DisplayOption.ALIGN_RIGHT.toString())) {
            return IGui.HorizontalAlignment.RIGHT;
        }
        return IGui.HorizontalAlignment.CENTER;
    }

    private IGui.VerticalAlignment getVerticalAlignment() {
        if (this.displayOptions.contains(DisplayOption.ALIGN_TOP.toString())) {
            return IGui.VerticalAlignment.TOP;
        }
        if (this.displayOptions.contains(DisplayOption.ALIGN_BOTTOM.toString())) {
            return IGui.VerticalAlignment.BOTTOM;
        }
        return IGui.VerticalAlignment.CENTER;
    }

    private static ObjectIntImmutablePair<QueuedRenderLayer> getRenderProperties(RenderStage renderStage, int light, @Nullable VehicleExtension vehicle) {
        if (renderStage == RenderStage.ALWAYS_ON_LIGHT) {
            return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.LIGHT_2, GraphicsHolder.getDefaultLight());
        }
        if (vehicle != null) {
            if (vehicle.getIsOnRoute()) {
                switch (renderStage) {
                    case LIGHT: {
                        return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.LIGHT, GraphicsHolder.getDefaultLight());
                    }
                    case INTERIOR: {
                        return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.INTERIOR, 0xF000B0);
                    }
                    case INTERIOR_TRANSLUCENT: {
                        return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.INTERIOR_TRANSLUCENT, 0xF000B0);
                    }
                }
            } else if (renderStage == RenderStage.INTERIOR_TRANSLUCENT) {
                return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.EXTERIOR_TRANSLUCENT, light);
            }
        }
        return new ObjectIntImmutablePair<QueuedRenderLayer>(QueuedRenderLayer.EXTERIOR, light);
    }

    private static Box addBox(Box box, double x, double y, double z, boolean flipped) {
        return new Box((double)(flipped ? -1 : 1) * box.getMinXMapped() + x / 16.0, box.getMinYMapped() + y / 16.0, (double)(flipped ? 1 : -1) * box.getMinZMapped() + z / 16.0, (double)(flipped ? -1 : 1) * box.getMaxXMapped() + x / 16.0, box.getMaxYMapped() + y / 16.0, (double)(flipped ? 1 : -1) * box.getMaxZMapped() + z / 16.0);
    }

    private static void iteratePositions(ObjectArrayList<PartPosition> positions, ObjectArrayList<PartPosition> positionsFlipped, PositionCallback positionCallback) {
        positions.forEach(position -> positionCallback.accept(position.getX(), position.getY(), position.getZ(), false));
        positionsFlipped.forEach(position -> positionCallback.accept(-position.getX(), position.getY(), position.getZ(), true));
    }

    private static double getClosestDistance(double a1, double a2, double b1, double b2) {
        return Math.min(Math.min(Math.abs(b1 - a1), Math.abs(b1 - a2)), Math.min(Math.abs(b2 - a1), Math.abs(b2 - a2)));
    }

    private static int parseColor(String colorString, int defaultColor) {
        try {
            return Integer.parseInt(colorString, 16);
        }
        catch (Exception ignored) {
            return defaultColor;
        }
    }

    private static int rainbowColor() {
        long timeR = System.currentTimeMillis() % 3000L;
        long timeG = (timeR + 1000L) % 3000L;
        long timeB = (timeR + 2000L) % 3000L;
        int r = timeR < 2000L ? (int)Math.round(Math.sin((double)timeR * Math.PI / 2000.0) * 255.0) : 0;
        int g = timeG < 2000L ? (int)Math.round(Math.sin((double)timeG * Math.PI / 2000.0) * 255.0) : 0;
        int b = timeB < 2000L ? (int)Math.round(Math.sin((double)timeB * Math.PI / 2000.0) * 255.0) : 0;
        return (r << 16) + (g << 8) + b;
    }

    private static String getOrDefault(String checkText, String defaultText) {
        return ModelPropertiesPart.getOrDefault(checkText, checkText, defaultText);
    }

    private static <T> T getOrDefault(T outputValue, String checkText, T defaultValue) {
        return checkText.isEmpty() ? defaultValue : outputValue;
    }

    private static <T> T getOrDefault(T thisRouteData, T nextRouteData, T previousRouteData, T defaultValue, Vehicle vehicle) {
        if (vehicle.vehicleExtraData.getThisRouteId() != 0L) {
            return thisRouteData;
        }
        if (vehicle.vehicleExtraData.getNextRouteId() != 0L) {
            return nextRouteData;
        }
        if (vehicle.vehicleExtraData.getPreviousRouteId() != 0L) {
            return previousRouteData;
        }
        return defaultValue;
    }

    private /* synthetic */ void lambda$null$13(ObjectArrayList objModels, Object2ObjectOpenHashMap objModelsForPartConditionAndRenderStage, double modelYOffset, Object2ObjectOpenHashMap objModelsForPartConditionAndRenderStageDoorsClosed, Supplier optimizedModelDoor, MutableBox mutableBox, ObjectArrayList positions, ObjectArrayList positionsFlipped) {
        if (this.type == PartType.NORMAL) {
            ModelPropertiesPart.iteratePositions(positions, positionsFlipped, (arg_0, arg_1, arg_2, arg_3) -> this.lambda$null$12(objModels, objModelsForPartConditionAndRenderStage, modelYOffset, objModelsForPartConditionAndRenderStageDoorsClosed, (Supplier)optimizedModelDoor, mutableBox, arg_0, arg_1, arg_2, arg_3));
        }
    }

    private /* synthetic */ void lambda$null$12(ObjectArrayList objModels, Object2ObjectOpenHashMap objModelsForPartConditionAndRenderStage, double modelYOffset, Object2ObjectOpenHashMap objModelsForPartConditionAndRenderStageDoorsClosed, Supplier optimizedModelDoor, MutableBox mutableBox, double x, double y, double z, boolean flipped) {
        if (!this.isDoor()) {
            this.addObjModelPosition(objModels, objModelsForPartConditionAndRenderStage, x, y, z, flipped, modelYOffset);
        }
        this.addObjModelPosition(objModels, objModelsForPartConditionAndRenderStageDoorsClosed, x, y, z, flipped, modelYOffset);
        this.partDetailsList.add(new PartDetails(new ObjectArrayList(), (OptimizedModelWrapper)optimizedModelDoor.get(), ModelPropertiesPart.addBox(mutableBox.get(), x, y, z, flipped), x, y, z, flipped));
    }

    @FunctionalInterface
    private static interface PositionCallback {
        public void accept(double var1, double var3, double var5, boolean var7);
    }

    private static class DisplayPartDetails {
        private final ObjectArrayList<ObjectArrayList<ModelDisplayPart>> modelDisplayParts;
        private final double x;
        private final double y;
        private final double z;
        private final boolean flipped;

        private DisplayPartDetails(ObjectArrayList<ObjectArrayList<ModelDisplayPart>> modelDisplayParts, double x, double y, double z, boolean flipped) {
            this.modelDisplayParts = modelDisplayParts;
            this.x = x / 16.0;
            this.y = y / 16.0;
            this.z = z / 16.0;
            this.flipped = flipped;
        }
    }

    private static class PartDetails {
        @Nullable
        private Box doorway;
        private final ObjectArrayList<ModelPartExtension> modelParts;
        private final OptimizedModelWrapper optimizedModelDoor;
        private final Box box;
        private final double x;
        private final double y;
        private final double z;
        private final boolean flipped;

        private PartDetails(ObjectArrayList<ModelPartExtension> modelParts, @Nullable OptimizedModelWrapper optimizedModelDoor, Box box, double x, double y, double z, boolean flipped) {
            this.modelParts = OptimizedRenderer.hasOptimizedRendering() ? new ObjectArrayList() : modelParts;
            this.optimizedModelDoor = optimizedModelDoor;
            this.box = box;
            this.x = x;
            this.y = y;
            this.z = z;
            this.flipped = flipped;
        }
    }
}

