/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.servlet;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Locale;
import javax.annotation.Nullable;
import org.mtr.core.serializer.JsonReader;
import org.mtr.libraries.com.google.gson.JsonParser;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.libraries.javax.servlet.AsyncContext;
import org.mtr.libraries.javax.servlet.http.HttpServletRequest;
import org.mtr.libraries.javax.servlet.http.HttpServletResponse;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Screen;
import org.mtr.mod.Init;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.resource.MinecraftModelResource;
import org.mtr.mod.resource.ResourceWrapper;
import org.mtr.mod.screen.FakePauseScreen;
import org.mtr.mod.screen.ReloadCustomResourcesScreen;
import org.mtr.mod.servlet.AbstractResourcePackCreatorServlet;
import org.mtr.mod.sound.BveVehicleSound;
import org.mtr.mod.sound.BveVehicleSoundConfig;
import org.mtr.mod.sound.LegacyVehicleSound;
import org.mtr.mod.sound.VehicleSoundBase;

public final class ResourcePackCreatorOperationServlet
extends AbstractResourcePackCreatorServlet {
    @Nullable
    private static VehicleSoundBase vehicleSoundBase;
    private static long motorSoundExpiry;
    private static float speed;
    private static float targetSpeed;
    private static float acceleration;
    private static int doorMultiplier;

    @Override
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AsyncContext asyncContext = httpServletRequest.startAsync();
        asyncContext.setTimeout(0L);
        ResourcePackCreatorOperationServlet.setEncoding(httpServletRequest, httpServletResponse);
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        switch (httpServletRequest.getPathInfo()) {
            case "/refresh": {
                if (resourceWrapper == null && Files.exists(ResourcePackCreatorOperationServlet.getBackupFile(), new LinkOption[0])) {
                    ResourcePackCreatorOperationServlet.returnStandardResponse(httpServletResponse, asyncContext, null);
                    break;
                }
                ResourcePackCreatorOperationServlet.returnStandardResponse(httpServletResponse, asyncContext, null);
                break;
            }
            case "/play-sound": {
                ResourcePackCreatorOperationServlet.playSound(httpServletRequest, httpServletResponse, asyncContext);
                break;
            }
            case "/preview": {
                ResourcePackCreatorOperationServlet.preview(httpServletRequest, httpServletResponse, asyncContext);
                break;
            }
            case "/force-reload": {
                minecraftClient.execute(() -> minecraftClient.openScreen(new Screen(new ReloadCustomResourcesScreen(() -> {
                    CustomResourceLoader.reload();
                    ResourcePackCreatorOperationServlet.returnStandardResponse(httpServletResponse, asyncContext, "");
                }))));
                break;
            }
            case "/resume-game": {
                minecraftClient.execute(() -> minecraftClient.openScreen(new Screen(new FakePauseScreen())));
                ResourcePackCreatorOperationServlet.returnStandardResponse(httpServletResponse, asyncContext, null);
                break;
            }
            default: {
                ResourcePackCreatorOperationServlet.returnErrorResponse(httpServletResponse, asyncContext);
            }
        }
    }

    @Override
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AsyncContext asyncContext = httpServletRequest.startAsync();
        asyncContext.setTimeout(0L);
        ResourcePackCreatorOperationServlet.setEncoding(httpServletRequest, httpServletResponse);
        switch (httpServletRequest.getPathInfo()) {
            case "/update": {
                ResourcePackCreatorOperationServlet.update(httpServletRequest, httpServletResponse, asyncContext);
                break;
            }
            default: {
                ResourcePackCreatorOperationServlet.returnErrorResponse(httpServletResponse, asyncContext);
            }
        }
    }

    public static void tick(long millisElapsed) {
        ClientPlayerEntity clientPlayerEntity;
        if (System.currentTimeMillis() > motorSoundExpiry && vehicleSoundBase != null) {
            vehicleSoundBase.dispose();
            vehicleSoundBase = null;
        }
        if (vehicleSoundBase != null && (clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped()) != null) {
            float oldSpeed = speed;
            float speedChange = (float)millisElapsed * acceleration;
            if (targetSpeed > speed) {
                speed = Math.min(targetSpeed, speed + speedChange);
            } else if (targetSpeed < speed) {
                speed = Math.max(targetSpeed, speed - speedChange);
            }
            vehicleSoundBase.playMotorSound(clientPlayerEntity.getBlockPos(), speed, speed - oldSpeed, acceleration, true);
        }
    }

    public static int getDoorMultiplier() {
        return doorMultiplier;
    }

    private static void update(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AsyncContext asyncContext) {
        try {
            resourceWrapper = new ResourceWrapper(new JsonReader(JsonParser.parseReader(httpServletRequest.getReader())), new ObjectArrayList<MinecraftModelResource>((ObjectList<MinecraftModelResource>)CustomResourceLoader.getMinecraftModelResources()), new ObjectArrayList<String>((ObjectList<String>)CustomResourceLoader.getTextureResources()));
            resourceWrapper.clean();
            ResourcePackCreatorOperationServlet.returnStandardResponse(httpServletResponse, asyncContext, httpServletRequest.getParameter("id"));
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            ResourcePackCreatorOperationServlet.returnErrorResponse(httpServletResponse, asyncContext);
        }
    }

    private static void playSound(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AsyncContext asyncContext) {
        String id = httpServletRequest.getParameter("id");
        String type = httpServletRequest.getParameter("type");
        String mode = httpServletRequest.getParameter("mode");
        int value = ResourcePackCreatorOperationServlet.parseInt(httpServletRequest.getParameter("value"));
        int legacySpeedSoundCount = ResourcePackCreatorOperationServlet.parseInt(httpServletRequest.getParameter("speed-sound-count"));
        boolean legacyUseAccelerationSoundsWhenCoasting = "true".equalsIgnoreCase(httpServletRequest.getParameter("use-acceleration-sounds-when-coasting"));
        boolean legacyConstantPlaybackSpeed = "true".equalsIgnoreCase(httpServletRequest.getParameter("constant-playback-speed"));
        if (id == null || type == null || mode == null) {
            ResourcePackCreatorOperationServlet.returnErrorResponse(httpServletResponse, asyncContext);
            return;
        }
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        minecraftClient.execute(() -> {
            ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
            if (clientPlayerEntity != null) {
                VehicleSoundBase tempVehicleSoundBase;
                switch (type.toLowerCase(Locale.ENGLISH)) {
                    case "bve": {
                        tempVehicleSoundBase = new BveVehicleSound(new BveVehicleSoundConfig(id));
                        break;
                    }
                    case "legacy": {
                        tempVehicleSoundBase = new LegacyVehicleSound(id, legacySpeedSoundCount, legacyUseAccelerationSoundsWhenCoasting, legacyConstantPlaybackSpeed, id, 0.5);
                        break;
                    }
                    default: {
                        tempVehicleSoundBase = null;
                    }
                }
                if (tempVehicleSoundBase != null) {
                    switch (mode.toLowerCase(Locale.ENGLISH)) {
                        case "speed": {
                            vehicleSoundBase = tempVehicleSoundBase;
                            motorSoundExpiry = System.currentTimeMillis() + 5000L;
                            speed = targetSpeed;
                            targetSpeed = (float)value / 3600.0f;
                            acceleration = Math.abs(targetSpeed - speed) / 200.0f;
                            break;
                        }
                        case "door-open": {
                            tempVehicleSoundBase.playDoorSound(clientPlayerEntity.getBlockPos(), 1.0, 0.0);
                            break;
                        }
                        case "door-close": {
                            tempVehicleSoundBase.playDoorSound(clientPlayerEntity.getBlockPos(), 0.0, 1.0);
                        }
                    }
                }
            }
        });
        ResourcePackCreatorOperationServlet.returnStandardResponse(httpServletResponse, asyncContext, null);
    }

    private static void preview(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AsyncContext asyncContext) {
        String doors = httpServletRequest.getParameter("doors");
        if ("open".equals(doors)) {
            doorMultiplier = 1;
        } else if ("close".equals(doors)) {
            doorMultiplier = -1;
        }
        ResourcePackCreatorOperationServlet.returnStandardResponse(httpServletResponse, asyncContext, null);
    }

    private static int parseInt(@Nullable String value) {
        try {
            return value == null ? 0 : Integer.parseInt(value);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    static {
        doorMultiplier = -1;
    }
}

