/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.sound;

import java.util.Random;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mod.sound.BveVehicleSoundConfig;
import org.mtr.mod.sound.ScheduledSound;
import org.mtr.mod.sound.VehicleLoopingSoundInstance;
import org.mtr.mod.sound.VehicleSoundBase;

public class BveVehicleSound
extends VehicleSoundBase {
    private final BveVehicleSoundConfig config;
    private float oldSpeedChange;
    private boolean oldOnRoute = false;
    private float motorCurrentOutput = 0.0f;
    private float motorBreakerTimer = -1.0f;
    private float mrPress;
    private boolean isCompressorActive;
    private boolean isCompressorActiveLastElapsed;
    private final VehicleLoopingSoundHolder vehicleLoopingSoundHolder;

    public BveVehicleSound(BveVehicleSoundConfig config) {
        this.config = config;
        this.mrPress = BveVehicleSound.randomInt(config.config.mrPressMin, config.config.mrPressMax + 1);
        this.isCompressorActiveLastElapsed = this.isCompressorActive = BveVehicleSound.randomInt(0, 20) == 0;
        VehicleLoopingSoundInstance[] soundLoopMotor = new VehicleLoopingSoundInstance[config.config.motor.length];
        for (int i = 0; i < Math.min(config.config.motor.length, config.motorData.getSoundCount()); ++i) {
            if (config.config.motor[i] == null) continue;
            soundLoopMotor[i] = new VehicleLoopingSoundInstance(config.config.motor[i]);
        }
        this.vehicleLoopingSoundHolder = new VehicleLoopingSoundHolder(soundLoopMotor, config.config.run[0] == null ? null : new VehicleLoopingSoundInstance(config.config.run[0]), config.config.flange[0] == null ? null : new VehicleLoopingSoundInstance(config.config.flange[0]), config.config.noise == null ? null : new VehicleLoopingSoundInstance(config.config.noise), config.config.shoe == null ? null : new VehicleLoopingSoundInstance(config.config.shoe), config.config.compressorLoop == null ? null : new VehicleLoopingSoundInstance(config.config.compressorLoop));
    }

    @Override
    public void playMotorSound(BlockPos blockPos, float speed, float speedChange, float acceleration, boolean isOnRoute) {
        float motorTarget;
        float secondsElapsed = MinecraftClient.getInstance().getLastFrameDuration() / 20.0f;
        float speedKilometersPerHour = speed * 3600.0f;
        float speedMetersPerSecond = speed * 1000.0f;
        if (this.vehicleLoopingSoundHolder.soundLoopRun != null) {
            this.vehicleLoopingSoundHolder.soundLoopRun.setData(Math.min(1.0f, speedMetersPerSecond * 0.04f), speedMetersPerSecond * 0.04f, blockPos);
        }
        if ((motorTarget = Math.signum(speedChange)) == 0.0f && speedMetersPerSecond != 0.0f) {
            motorTarget = this.config.config.motorOutputAtCoast;
        }
        if (motorTarget < 0.0f && speedMetersPerSecond < this.config.config.regenerationLimit) {
            this.motorCurrentOutput = 0.0f;
            this.motorBreakerTimer = -1.0f;
        } else if (motorTarget > 0.0f && speedMetersPerSecond < 1.0f) {
            this.motorCurrentOutput = 1.0f;
            this.motorBreakerTimer = -1.0f;
        } else if (motorTarget != this.motorCurrentOutput && this.motorBreakerTimer < 0.0f) {
            this.motorBreakerTimer = 0.0f;
            if (motorTarget != 0.0f && this.motorCurrentOutput != 0.0f) {
                this.motorCurrentOutput = 0.0f;
            }
        }
        if (this.motorBreakerTimer >= 0.0f) {
            this.motorBreakerTimer += secondsElapsed;
            if (this.motorBreakerTimer > this.config.config.breakerDelay) {
                this.motorBreakerTimer = -1.0f;
                this.motorCurrentOutput = motorTarget;
            }
        }
        if (this.motorCurrentOutput != 0.0f) {
            this.motorCurrentOutput = Math.signum(this.motorCurrentOutput) * (0.3f + Math.abs(this.motorCurrentOutput) * 0.7f);
        }
        this.config.config.getClass();
        if (this.mrPress <= 700.0f) {
            this.isCompressorActive = true;
            this.config.config.getClass();
            this.mrPress = 700.0f;
        } else {
            this.config.config.getClass();
            if (this.mrPress >= 800.0f) {
                this.isCompressorActive = false;
                this.config.config.getClass();
                this.mrPress = 800.0f;
            }
        }
        if (this.isCompressorActive) {
            this.config.config.getClass();
            this.mrPress += (float)((int)(secondsElapsed * 5.0f));
        }
        if (this.vehicleLoopingSoundHolder.soundLoopCompressor != null) {
            this.vehicleLoopingSoundHolder.soundLoopCompressor.setData(this.isCompressorActive ? 1.0f : 0.0f, 1.0f, blockPos);
        }
        if (this.isCompressorActive && !this.isCompressorActiveLastElapsed) {
            BveVehicleSound.playSoundInWorld(this.config.config.compressorAttack, blockPos);
        } else if (!this.isCompressorActive && this.isCompressorActiveLastElapsed) {
            BveVehicleSound.playSoundInWorld(this.config.config.compressorRelease, blockPos);
        }
        for (int i = 0; i < this.config.motorData.getSoundCount(); ++i) {
            if (this.vehicleLoopingSoundHolder.soundLoopMotor[i] == null) continue;
            this.vehicleLoopingSoundHolder.soundLoopMotor[i].setData(this.config.motorData.getVolume(i, speedKilometersPerHour, this.motorCurrentOutput) * this.config.config.motorVolumeMultiply, this.config.motorData.getPitch(i, speedKilometersPerHour, this.motorCurrentOutput), blockPos);
        }
        if (this.vehicleLoopingSoundHolder.soundLoopFlange != null) {
            this.vehicleLoopingSoundHolder.soundLoopFlange.setData(0.0f, 1.0f, blockPos);
        }
        if (this.vehicleLoopingSoundHolder.soundLoopShoe != null) {
            float shoeGain;
            float shoePitch = 1.0f / (speedMetersPerSecond + 1.0f) + 1.0f;
            float f = shoeGain = speedMetersPerSecond < this.config.config.regenerationLimit && speedChange < 0.0f ? 1.0f : 0.0f;
            if ((double)speedMetersPerSecond < 1.39) {
                float t = speedMetersPerSecond * speedMetersPerSecond;
                shoeGain *= 1.5552f * t - 0.746496f * speedMetersPerSecond * t;
            } else if ((double)speedMetersPerSecond > 12.5) {
                float t = speedMetersPerSecond - 12.5f;
                shoeGain *= 1.0f / (0.1f * t * t + 1.0f);
            }
            this.vehicleLoopingSoundHolder.soundLoopShoe.setData(shoeGain, shoePitch, blockPos);
        }
        if (this.vehicleLoopingSoundHolder.soundLoopNoise != null) {
            this.vehicleLoopingSoundHolder.soundLoopNoise.setData(isOnRoute ? 1.0f : 0.0f, 1.0f, blockPos);
        }
        if (this.oldSpeedChange < 0.0f && speedChange >= 0.0f) {
            BveVehicleSound.playSoundInWorld(this.config.config.brakeHandleRelease, blockPos);
            if (speedMetersPerSecond < this.config.config.regenerationLimit) {
                BveVehicleSound.playSoundInWorld(this.config.config.airZero, blockPos);
            }
        } else if (this.oldSpeedChange <= 0.0f && speedChange > 0.0f && (double)speedMetersPerSecond < 0.3) {
            BveVehicleSound.playSoundInWorld(this.config.config.airHigh, blockPos);
        } else if (this.oldSpeedChange >= 0.0f && speedChange < 0.0f) {
            this.config.config.getClass();
            this.mrPress -= (float)5;
            BveVehicleSound.playSoundInWorld(this.config.config.brakeHandleApply, blockPos);
        }
        if (this.oldOnRoute && !isOnRoute) {
            BveVehicleSound.playSoundInWorld(this.config.config.brakeEmergency, blockPos);
        }
        this.oldSpeedChange = speedChange;
        this.oldOnRoute = isOnRoute;
        this.isCompressorActiveLastElapsed = this.isCompressorActive;
    }

    @Override
    protected void playDoorSound(BlockPos blockPos, boolean isOpen) {
        ScheduledSound.schedule(blockPos, isOpen ? this.config.config.doorOpen : this.config.config.doorClose, 2.0f, 1.0f);
    }

    @Override
    public void dispose() {
        this.vehicleLoopingSoundHolder.dispose();
    }

    @Override
    protected double getDoorCloseSoundTime() {
        return this.config.config.doorCloseSoundLength;
    }

    private static void playSoundInWorld(@Nullable SoundEvent soundEvent, BlockPos blockPos) {
        ScheduledSound.schedule(blockPos, soundEvent, 1.0f, 1.0f);
    }

    private static int randomInt(int minInclusive, int maxExclusive) {
        return new Random().nextInt(maxExclusive - minInclusive) + minInclusive;
    }

    private static class VehicleLoopingSoundHolder {
        private final VehicleLoopingSoundInstance[] soundLoopMotor;
        @Nullable
        private final VehicleLoopingSoundInstance soundLoopRun;
        @Nullable
        private final VehicleLoopingSoundInstance soundLoopFlange;
        @Nullable
        private final VehicleLoopingSoundInstance soundLoopNoise;
        @Nullable
        private final VehicleLoopingSoundInstance soundLoopShoe;
        @Nullable
        private final VehicleLoopingSoundInstance soundLoopCompressor;

        private VehicleLoopingSoundHolder(VehicleLoopingSoundInstance[] soundLoopMotor, @Nullable VehicleLoopingSoundInstance soundLoopRun, @Nullable VehicleLoopingSoundInstance soundLoopFlange, @Nullable VehicleLoopingSoundInstance soundLoopNoise, @Nullable VehicleLoopingSoundInstance soundLoopShoe, @Nullable VehicleLoopingSoundInstance soundLoopCompressor) {
            this.soundLoopMotor = soundLoopMotor;
            this.soundLoopRun = soundLoopRun;
            this.soundLoopFlange = soundLoopFlange;
            this.soundLoopNoise = soundLoopNoise;
            this.soundLoopShoe = soundLoopShoe;
            this.soundLoopCompressor = soundLoopCompressor;
        }

        public void dispose() {
            for (VehicleLoopingSoundInstance instance : this.soundLoopMotor) {
                if (instance == null) continue;
                instance.dispose();
            }
            if (this.soundLoopRun != null) {
                this.soundLoopRun.dispose();
            }
            if (this.soundLoopFlange != null) {
                this.soundLoopFlange.dispose();
            }
            if (this.soundLoopNoise != null) {
                this.soundLoopNoise.dispose();
            }
            if (this.soundLoopShoe != null) {
                this.soundLoopShoe.dispose();
            }
            if (this.soundLoopCompressor != null) {
                this.soundLoopCompressor.dispose();
            }
        }
    }
}

