/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_4048;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.DefaultParticleType;
import org.mtr.mapping.holder.EntityType;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockItemExtension;
import org.mtr.mapping.mapper.EntityExtension;
import org.mtr.mapping.registry.BlockEntityTypeRegistryObject;
import org.mtr.mapping.registry.BlockRegistryObject;
import org.mtr.mapping.registry.CommandBuilder;
import org.mtr.mapping.registry.CreativeModeTabHolder;
import org.mtr.mapping.registry.EntityTypeRegistryObject;
import org.mtr.mapping.registry.EventRegistry;
import org.mtr.mapping.registry.ItemRegistryObject;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.registry.ParticleTypeRegistryObject;
import org.mtr.mapping.registry.SoundEventRegistryObject;
import org.mtr.mapping.tool.DummyClass;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public final class Registry
extends DummyClass {
    Identifier packetsIdentifier;
    final Map<String, Function<PacketBufferReceiver, ? extends PacketHandler>> packets = new HashMap<String, Function<PacketBufferReceiver, ? extends PacketHandler>>();
    public final EventRegistry eventRegistry = new EventRegistry();
    private final List<Runnable> objectsToRegister = new ArrayList<Runnable>();
    private final List<Consumer<CommandDispatcher<class_2168>>> commandsToRegister = new ArrayList<Consumer<CommandDispatcher<class_2168>>>();

    @MappedMethod
    public void init() {
        this.objectsToRegister.forEach(Runnable::run);
        CommandRegistrationCallback.EVENT.register((dispatcher, commandRegistryAccess, environment) -> this.commandsToRegister.forEach(consumer -> consumer.accept(dispatcher)));
    }

    @MappedMethod
    public BlockRegistryObject registerBlock(Identifier identifier, Supplier<Block> supplier) {
        Block block = supplier.get();
        this.objectsToRegister.add(() -> class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)((class_2960)identifier.data), (Object)((class_2248)block.data)));
        return new BlockRegistryObject(block);
    }

    @MappedMethod
    public BlockRegistryObject registerBlockWithBlockItem(Identifier identifier, Supplier<Block> supplier, CreativeModeTabHolder ... creativeModeTabHolders) {
        return this.registerBlockWithBlockItem(identifier, supplier, BlockItemExtension::new, creativeModeTabHolders);
    }

    @MappedMethod
    public BlockRegistryObject registerBlockWithBlockItem(Identifier identifier, Supplier<Block> supplier, BiFunction<Block, ItemSettings, BlockItemExtension> function, CreativeModeTabHolder ... creativeModeTabHolders) {
        Block block = supplier.get();
        this.objectsToRegister.add(() -> class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)((class_2960)identifier.data), (Object)((class_2248)block.data)));
        BlockItemExtension blockItemExtension = function.apply(block, new ItemSettings());
        this.objectsToRegister.add(() -> class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)((class_2960)identifier.data), (Object)((Object)blockItemExtension)));
        for (CreativeModeTabHolder creativeModeTabHolder : creativeModeTabHolders) {
            ItemGroupEvents.modifyEntriesEvent((class_1761)creativeModeTabHolder.creativeModeTab).register(content -> content.method_45421((class_1935)blockItemExtension));
        }
        return new BlockRegistryObject(block);
    }

    @MappedMethod
    public ItemRegistryObject registerItem(Identifier identifier, Function<ItemSettings, Item> function, CreativeModeTabHolder ... creativeModeTabHolders) {
        Item item = function.apply(new ItemSettings());
        this.objectsToRegister.add(() -> class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)((class_2960)identifier.data), (Object)((class_1792)item.data)));
        for (CreativeModeTabHolder creativeModeTabHolder : creativeModeTabHolders) {
            ItemGroupEvents.modifyEntriesEvent((class_1761)creativeModeTabHolder.creativeModeTab).register(content -> content.method_45421((class_1935)item.data));
        }
        return new ItemRegistryObject(item);
    }

    @MappedMethod
    public <T extends BlockEntityExtension> BlockEntityTypeRegistryObject<T> registerBlockEntityType(Identifier identifier, BiFunction<BlockPos, BlockState, T> function, Supplier<Block> ... blockSuppliers) {
        class_2591 blockEntityType = FabricBlockEntityTypeBuilder.create((pos, state) -> (BlockEntityExtension)((Object)((Object)function.apply(new BlockPos(pos), new BlockState(state)))), (class_2248[])((class_2248[])HolderBase.convertArray(blockSuppliers, class_2248[]::new))).build(null);
        this.objectsToRegister.add(() -> class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)((class_2960)identifier.data), (Object)blockEntityType));
        return new BlockEntityTypeRegistryObject(new BlockEntityType(blockEntityType));
    }

    @MappedMethod
    public <T extends EntityExtension> EntityTypeRegistryObject<T> registerEntityType(Identifier identifier, BiFunction<EntityType<?>, World, T> function, float width, float height) {
        class_1299 entityType = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, this.getEntityFactory(function)).dimensions(class_4048.method_18385((float)width, (float)height)).build();
        this.objectsToRegister.add(() -> class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)((class_2960)identifier.data), (Object)entityType));
        return new EntityTypeRegistryObject(new EntityType(entityType));
    }

    private <T extends EntityExtension> class_1299.class_4049<T> getEntityFactory(BiFunction<EntityType<?>, World, T> function) {
        return (entityType, world) -> (EntityExtension)((Object)((Object)function.apply(new EntityType(entityType), new World(world))));
    }

    @MappedMethod
    public ParticleTypeRegistryObject registerParticleType(Identifier identifier) {
        return this.registerParticleType(identifier, false);
    }

    @MappedMethod
    public ParticleTypeRegistryObject registerParticleType(Identifier identifier, boolean alwaysSpawn) {
        DefaultParticleType defaultParticleType = new DefaultParticleType(FabricParticleTypes.simple((boolean)alwaysSpawn));
        this.objectsToRegister.add(() -> class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)((class_2960)identifier.data), (Object)((class_2400)defaultParticleType.data)));
        return new ParticleTypeRegistryObject(defaultParticleType, identifier);
    }

    @MappedMethod
    public CreativeModeTabHolder createCreativeModeTabHolder(Identifier identifier, Supplier<ItemStack> iconSupplier) {
        return new CreativeModeTabHolder(FabricItemGroup.builder((class_2960)((class_2960)identifier.data)).method_47320(() -> (class_1799)((ItemStack)iconSupplier.get()).data).method_47324());
    }

    @MappedMethod
    public SoundEventRegistryObject registerSoundEvent(Identifier identifier) {
        class_3414 soundEvent = class_3414.method_47908((class_2960)((class_2960)identifier.data));
        this.objectsToRegister.add(() -> class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)((class_2960)identifier.data), (Object)soundEvent));
        return new SoundEventRegistryObject(new SoundEvent(soundEvent));
    }

    @MappedMethod
    public void registerCommand(String command, Consumer<CommandBuilder<?>> buildCommand, String ... redirects) {
        this.commandsToRegister.add(dispatcher -> {
            CommandBuilder<LiteralArgumentBuilder> commandBuilder = new CommandBuilder<LiteralArgumentBuilder>(class_2170.method_9247((String)command));
            buildCommand.accept(commandBuilder);
            LiteralCommandNode literalCommandNode = dispatcher.register((LiteralArgumentBuilder)commandBuilder.argumentBuilder);
            for (String redirect : redirects) {
                dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)redirect).redirect((CommandNode)literalCommandNode));
            }
        });
    }

    @MappedMethod
    public void setupPackets(Identifier identifier) {
        this.packetsIdentifier = identifier;
        ServerPlayNetworking.registerGlobalReceiver((class_2960)((class_2960)identifier.data), (server, player, handler, buf, responseSender) -> PacketBufferReceiver.receive((ByteBuf)buf, packetBufferReceiver -> {
            Function<PacketBufferReceiver, ? extends PacketHandler> getInstance = this.packets.get(packetBufferReceiver.readString());
            if (getInstance != null) {
                getInstance.apply((PacketBufferReceiver)packetBufferReceiver).runServer(new org.mtr.mapping.holder.MinecraftServer(server), new ServerPlayerEntity(player));
            }
        }, arg_0 -> ((MinecraftServer)server).execute(arg_0)));
    }

    @MappedMethod
    public <T extends PacketHandler> void registerPacket(Class<T> classObject, Function<PacketBufferReceiver, T> getInstance) {
        this.packets.put(classObject.getName(), getInstance);
    }

    @MappedMethod
    public <T extends PacketHandler> void sendPacketToClient(ServerPlayerEntity serverPlayerEntity, T data) {
        if (this.packetsIdentifier != null) {
            PacketBufferSender packetBufferSender = new PacketBufferSender(PacketByteBufs::create);
            packetBufferSender.writeString(data.getClass().getName());
            data.write(packetBufferSender);
            packetBufferSender.send(byteBuf -> ServerPlayNetworking.send((class_3222)((class_3222)serverPlayerEntity.data), (class_2960)((class_2960)this.packetsIdentifier.data), (class_2540)(byteBuf instanceof class_2540 ? (class_2540)byteBuf : new class_2540(byteBuf))), serverPlayerEntity.getServerMapped()::execute);
        }
    }
}

