/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.oba;

import javax.annotation.Nonnull;
import org.mtr.core.oba.Frequency;
import org.mtr.core.oba.OccupancyStatus;
import org.mtr.core.oba.Position;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class TripStatusSchema
implements SerializedDataBase {
    protected final String activeTripId;
    protected final long blockTripSequence;
    protected final long serviceDate;
    protected Frequency frequency = this.getDefaultFrequency();
    protected final double scheduledDistanceAlongTrip;
    protected final double totalDistanceAlongTrip;
    protected final Position position;
    protected final double orientation;
    protected final String closestStop;
    protected final long closestStopTimeOffset;
    protected final String nextStop;
    protected final long nextStopTimeOffset;
    protected final OccupancyStatus occupancyStatus;
    protected final String phase;
    protected final String status;
    protected final boolean predicted;
    protected final long lastUpdateTime;
    protected final long lastLocationUpdateTime;
    protected final Position lastKnownLocation;
    protected final double lastKnownDistanceAlongTrip;
    protected final double lastKnownOrientation;
    protected final double distanceAlongTrip;
    protected final long scheduleDeviation;
    protected final String vehicleId;
    protected final ObjectArrayList<String> situationIds = new ObjectArrayList();

    protected TripStatusSchema(String activeTripId, long blockTripSequence, long serviceDate, double scheduledDistanceAlongTrip, double totalDistanceAlongTrip, Position position, double orientation, String closestStop, long closestStopTimeOffset, String nextStop, long nextStopTimeOffset, OccupancyStatus occupancyStatus, String phase, String status, boolean predicted, long lastUpdateTime, long lastLocationUpdateTime, Position lastKnownLocation, double lastKnownDistanceAlongTrip, double lastKnownOrientation, double distanceAlongTrip, long scheduleDeviation, String vehicleId) {
        this.activeTripId = activeTripId;
        this.blockTripSequence = blockTripSequence;
        this.serviceDate = serviceDate;
        this.scheduledDistanceAlongTrip = scheduledDistanceAlongTrip;
        this.totalDistanceAlongTrip = totalDistanceAlongTrip;
        this.position = position;
        this.orientation = orientation;
        this.closestStop = closestStop;
        this.closestStopTimeOffset = closestStopTimeOffset;
        this.nextStop = nextStop;
        this.nextStopTimeOffset = nextStopTimeOffset;
        this.occupancyStatus = occupancyStatus;
        this.phase = phase;
        this.status = status;
        this.predicted = predicted;
        this.lastUpdateTime = lastUpdateTime;
        this.lastLocationUpdateTime = lastLocationUpdateTime;
        this.lastKnownLocation = lastKnownLocation;
        this.lastKnownDistanceAlongTrip = lastKnownDistanceAlongTrip;
        this.lastKnownOrientation = lastKnownOrientation;
        this.distanceAlongTrip = distanceAlongTrip;
        this.scheduleDeviation = scheduleDeviation;
        this.vehicleId = vehicleId;
    }

    protected TripStatusSchema(ReaderBase readerBase) {
        this.activeTripId = readerBase.getString("activeTripId", "");
        this.blockTripSequence = readerBase.getLong("blockTripSequence", 0L);
        this.serviceDate = readerBase.getLong("serviceDate", 0L);
        this.scheduledDistanceAlongTrip = readerBase.getDouble("scheduledDistanceAlongTrip", 0.0);
        this.totalDistanceAlongTrip = readerBase.getDouble("totalDistanceAlongTrip", 0.0);
        this.position = new Position(readerBase.getChild("position"));
        this.orientation = readerBase.getDouble("orientation", 0.0);
        this.closestStop = readerBase.getString("closestStop", "");
        this.closestStopTimeOffset = readerBase.getLong("closestStopTimeOffset", 0L);
        this.nextStop = readerBase.getString("nextStop", "");
        this.nextStopTimeOffset = readerBase.getLong("nextStopTimeOffset", 0L);
        this.occupancyStatus = EnumHelper.valueOf(OccupancyStatus.values()[0], readerBase.getString("occupancyStatus", ""));
        this.phase = readerBase.getString("phase", "");
        this.status = readerBase.getString("status", "");
        this.predicted = readerBase.getBoolean("predicted", false);
        this.lastUpdateTime = readerBase.getLong("lastUpdateTime", 0L);
        this.lastLocationUpdateTime = readerBase.getLong("lastLocationUpdateTime", 0L);
        this.lastKnownLocation = new Position(readerBase.getChild("lastKnownLocation"));
        this.lastKnownDistanceAlongTrip = readerBase.getDouble("lastKnownDistanceAlongTrip", 0.0);
        this.lastKnownOrientation = readerBase.getDouble("lastKnownOrientation", 0.0);
        this.distanceAlongTrip = readerBase.getDouble("distanceAlongTrip", 0.0);
        this.scheduleDeviation = readerBase.getLong("scheduleDeviation", 0L);
        this.vehicleId = readerBase.getString("vehicleId", "");
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.unpackChild("frequency", readerBaseChild -> {
            this.frequency = new Frequency((ReaderBase)readerBaseChild);
        });
        readerBase.iterateStringArray("situationIds", this.situationIds::clear, this.situationIds::add);
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeString("activeTripId", this.activeTripId);
        writerBase.writeLong("blockTripSequence", this.blockTripSequence);
        writerBase.writeLong("serviceDate", this.serviceDate);
        this.serializeFrequency(writerBase);
        writerBase.writeDouble("scheduledDistanceAlongTrip", this.scheduledDistanceAlongTrip);
        writerBase.writeDouble("totalDistanceAlongTrip", this.totalDistanceAlongTrip);
        if (this.position != null) {
            this.position.serializeData(writerBase.writeChild("position"));
        }
        writerBase.writeDouble("orientation", this.orientation);
        writerBase.writeString("closestStop", this.closestStop);
        writerBase.writeLong("closestStopTimeOffset", this.closestStopTimeOffset);
        writerBase.writeString("nextStop", this.nextStop);
        writerBase.writeLong("nextStopTimeOffset", this.nextStopTimeOffset);
        writerBase.writeString("occupancyStatus", this.occupancyStatus.toString());
        writerBase.writeString("phase", this.phase);
        writerBase.writeString("status", this.status);
        writerBase.writeBoolean("predicted", this.predicted);
        writerBase.writeLong("lastUpdateTime", this.lastUpdateTime);
        writerBase.writeLong("lastLocationUpdateTime", this.lastLocationUpdateTime);
        if (this.lastKnownLocation != null) {
            this.lastKnownLocation.serializeData(writerBase.writeChild("lastKnownLocation"));
        }
        writerBase.writeDouble("lastKnownDistanceAlongTrip", this.lastKnownDistanceAlongTrip);
        writerBase.writeDouble("lastKnownOrientation", this.lastKnownOrientation);
        writerBase.writeDouble("distanceAlongTrip", this.distanceAlongTrip);
        writerBase.writeLong("scheduleDeviation", this.scheduleDeviation);
        writerBase.writeString("vehicleId", this.vehicleId);
        this.serializeSituationIds(writerBase);
    }

    @Nonnull
    public String toString() {
        return "activeTripId: " + this.activeTripId + "\nblockTripSequence: " + this.blockTripSequence + "\nserviceDate: " + this.serviceDate + "\nfrequency: " + this.frequency + "\nscheduledDistanceAlongTrip: " + this.scheduledDistanceAlongTrip + "\ntotalDistanceAlongTrip: " + this.totalDistanceAlongTrip + "\nposition: " + this.position + "\norientation: " + this.orientation + "\nclosestStop: " + this.closestStop + "\nclosestStopTimeOffset: " + this.closestStopTimeOffset + "\nnextStop: " + this.nextStop + "\nnextStopTimeOffset: " + this.nextStopTimeOffset + "\noccupancyStatus: " + (Object)((Object)this.occupancyStatus) + "\nphase: " + this.phase + "\nstatus: " + this.status + "\npredicted: " + this.predicted + "\nlastUpdateTime: " + this.lastUpdateTime + "\nlastLocationUpdateTime: " + this.lastLocationUpdateTime + "\nlastKnownLocation: " + this.lastKnownLocation + "\nlastKnownDistanceAlongTrip: " + this.lastKnownDistanceAlongTrip + "\nlastKnownOrientation: " + this.lastKnownOrientation + "\ndistanceAlongTrip: " + this.distanceAlongTrip + "\nscheduleDeviation: " + this.scheduleDeviation + "\nvehicleId: " + this.vehicleId + "\nsituationIds: " + this.situationIds + "\n";
    }

    protected abstract Frequency getDefaultFrequency();

    protected void serializeFrequency(WriterBase writerBase) {
        if (this.frequency != null) {
            this.frequency.serializeData(writerBase.writeChild("frequency"));
        }
    }

    protected void serializeSituationIds(WriterBase writerBase) {
        WriterBase.Array situationIdsWriterBaseArray = writerBase.writeArray("situationIds");
        this.situationIds.forEach(situationIdsWriterBaseArray::writeString);
    }
}

