/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.libraries.de.javagl.obj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.mtr.libraries.de.javagl.obj.DefaultMtl;
import org.mtr.libraries.de.javagl.obj.DefaultTextureOptions;
import org.mtr.libraries.de.javagl.obj.Mtl;
import org.mtr.libraries.de.javagl.obj.TextureOptions;
import org.mtr.libraries.de.javagl.obj.Utils;

public class MtlReader {
    public static List<Mtl> read(InputStream inputStream2) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2));
        return MtlReader.readImpl(reader);
    }

    public static List<Mtl> read(Reader reader) throws IOException {
        if (reader instanceof BufferedReader) {
            return MtlReader.readImpl((BufferedReader)reader);
        }
        return MtlReader.readImpl(new BufferedReader(reader));
    }

    private static List<Mtl> readImpl(BufferedReader reader) throws IOException {
        String line;
        ArrayList<Mtl> mtlList = new ArrayList<Mtl>();
        DefaultMtl currentMtl = null;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            boolean finished = false;
            while (line.endsWith("\\")) {
                line = line.substring(0, line.length() - 2);
                String nextLine = reader.readLine();
                if (nextLine == null) {
                    finished = true;
                    break;
                }
                line = line + " " + nextLine;
            }
            if (finished) break;
            if ((line = line.trim()).startsWith("newmtl")) {
                String name = line.substring("newmtl".length()).trim();
                currentMtl = new DefaultMtl(name);
                mtlList.add(currentMtl);
                continue;
            }
            if (line.startsWith("#") || line.isEmpty()) continue;
            if (currentMtl == null) {
                throw new IOException("Missing newmtl statement before " + line);
            }
            MtlReader.processLine(currentMtl, line);
        }
        return mtlList;
    }

    private static void processLine(Mtl mtl, String line) throws IOException {
        LinkedList<String> tokens = new LinkedList<String>(Arrays.asList(line.split("[ \t\n\r\f]+")));
        String command = (String)tokens.poll();
        if (command.equalsIgnoreCase("illum")) {
            int value = Utils.parseInt((String)tokens.poll());
            mtl.setIllum(value);
        }
        if (command.equalsIgnoreCase("Ka")) {
            Float[] values2 = Utils.parseFloats(tokens, 3);
            mtl.setKa(values2[0], values2[1], values2[2]);
        } else if (command.equalsIgnoreCase("Kd")) {
            Float[] values3 = Utils.parseFloats(tokens, 3);
            mtl.setKd(values3[0], values3[1], values3[2]);
        } else if (command.equalsIgnoreCase("Ks")) {
            Float[] values4 = Utils.parseFloats(tokens, 3);
            mtl.setKs(values4[0], values4[1], values4[2]);
        } else if (command.equalsIgnoreCase("Tf")) {
            Float[] values5 = Utils.parseFloats(tokens, 3);
            mtl.setTf(values5[0], values5[1], values5[2]);
        } else if (command.equalsIgnoreCase("Ke")) {
            Float[] values6 = Utils.parseFloats(tokens, 3);
            mtl.setKe(values6[0], values6[1], values6[2]);
        } else if (command.equalsIgnoreCase("Tr")) {
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setD(Float.valueOf(1.0f - value));
        } else if (command.equalsIgnoreCase("sharpness")) {
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setSharpness(Float.valueOf(value));
        } else if (command.equalsIgnoreCase("d")) {
            String token = (String)tokens.peek();
            if ("-halo".equals(token)) {
                mtl.setHalo(true);
                tokens.poll();
            }
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setD(Float.valueOf(value));
        } else if (command.equalsIgnoreCase("Ni")) {
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setNi(Float.valueOf(value));
        } else if (command.equalsIgnoreCase("Ns")) {
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setNs(Float.valueOf(value));
        } else if (command.equalsIgnoreCase("Pr")) {
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setPr(Float.valueOf(value));
        } else if (command.equalsIgnoreCase("Pm")) {
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setPm(Float.valueOf(value));
        } else if (command.equalsIgnoreCase("Ps")) {
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setPs(Float.valueOf(value));
        } else if (command.equalsIgnoreCase("Pc")) {
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setPc(Float.valueOf(value));
        } else if (command.equalsIgnoreCase("Pcr")) {
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setPcr(Float.valueOf(value));
        } else if (command.equalsIgnoreCase("aniso")) {
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setAniso(Float.valueOf(value));
        } else if (command.equalsIgnoreCase("anisor")) {
            float value = Utils.parseFloat((String)tokens.poll());
            mtl.setAnisor(Float.valueOf(value));
        } else {
            MtlReader.readTextureMap(mtl, command, tokens);
        }
    }

    private static void readTextureMap(Mtl mtl, String command, Queue<String> tokens) throws IOException {
        if (command.equalsIgnoreCase("map_Ka")) {
            mtl.setMapKaOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("map_Kd")) {
            mtl.setMapKdOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("map_Ks")) {
            mtl.setMapKsOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("map_d")) {
            mtl.setMapDOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("map_Ns")) {
            mtl.setMapNsOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("bump") || command.equalsIgnoreCase("map_bump")) {
            mtl.setBumpOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("disp")) {
            mtl.setDispOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("decal")) {
            mtl.setDecalOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("refl")) {
            TextureOptions refl = MtlReader.readTextureOptions(tokens);
            mtl.getReflOptions().add(refl);
        } else if (command.equalsIgnoreCase("map_Pr")) {
            mtl.setMapPrOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("map_Pm")) {
            mtl.setMapPmOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("map_Ps")) {
            mtl.setMapPsOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("map_Ke")) {
            mtl.setMapKeOptions(MtlReader.readTextureOptions(tokens));
        } else if (command.equalsIgnoreCase("norm")) {
            mtl.setNormOptions(MtlReader.readTextureOptions(tokens));
        }
    }

    static TextureOptions readTextureOptions(Queue<String> tokens) throws IOException {
        DefaultTextureOptions textureOptions = new DefaultTextureOptions();
        while (!tokens.isEmpty()) {
            String optionName = tokens.poll();
            if (optionName.equalsIgnoreCase("-blendu")) {
                boolean value = Utils.parseBoolean(tokens.poll());
                textureOptions.setBlendu(value);
                continue;
            }
            if (optionName.equalsIgnoreCase("-blendv")) {
                boolean value = Utils.parseBoolean(tokens.poll());
                textureOptions.setBlendv(value);
                continue;
            }
            if (optionName.equalsIgnoreCase("-boost")) {
                float value = Utils.parseFloat(tokens.poll());
                textureOptions.setBoost(Float.valueOf(value));
                continue;
            }
            if (optionName.equalsIgnoreCase("-cc")) {
                boolean value = Utils.parseBoolean(tokens.poll());
                textureOptions.setCc(value);
                continue;
            }
            if (optionName.equalsIgnoreCase("-mm")) {
                float base = Utils.parseFloat(tokens.poll());
                float gain = Utils.parseFloat(tokens.poll());
                textureOptions.setMm(Float.valueOf(base), Float.valueOf(gain));
                continue;
            }
            if (optionName.equalsIgnoreCase("-o")) {
                Float[] values2 = Utils.parseFloats(tokens, 3);
                textureOptions.setO(values2[0], values2[1], values2[2]);
                continue;
            }
            if (optionName.equalsIgnoreCase("-s")) {
                Float[] values3 = Utils.parseFloats(tokens, 3);
                textureOptions.setS(values3[0], values3[1], values3[2]);
                continue;
            }
            if (optionName.equalsIgnoreCase("-t")) {
                Float[] values4 = Utils.parseFloats(tokens, 3);
                textureOptions.setT(values4[0], values4[1], values4[2]);
                continue;
            }
            if (optionName.equalsIgnoreCase("-texres")) {
                float value = Utils.parseFloat(tokens.poll());
                textureOptions.setTexres(Float.valueOf(value));
                continue;
            }
            if (optionName.equalsIgnoreCase("-clamp")) {
                boolean value = Utils.parseBoolean(tokens.poll());
                textureOptions.setClamp(value);
                continue;
            }
            if (optionName.equalsIgnoreCase("-bm")) {
                float value = Utils.parseFloat(tokens.poll());
                textureOptions.setBm(Float.valueOf(value));
                continue;
            }
            if (optionName.equalsIgnoreCase("-imfchan")) {
                String value = tokens.poll();
                textureOptions.setImfchan(value);
                continue;
            }
            if (optionName.equalsIgnoreCase("-type")) {
                String value = tokens.poll();
                textureOptions.setType(value);
                continue;
            }
            textureOptions.setFileName(optionName);
        }
        return textureOptions;
    }

    private MtlReader() {
    }
}

