/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.shader;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3306;
import net.minecraft.class_5912;
import org.apache.commons.io.IOUtils;
import org.mtr.mapping.holder.ResourceManager;
import org.mtr.mapping.render.tool.GlStateTracker;

public final class PatchingResourceProvider
implements class_5912 {
    private final class_5912 resourceFactory;

    public PatchingResourceProvider(ResourceManager resourceManager) {
        this.resourceFactory = (class_5912)resourceManager.data;
    }

    public class_3298 method_14486(class_2960 identifier) throws IOException {
        String returningContent;
        class_2960 newIdentifier = identifier.method_12832().contains("_modelmat") ? new class_2960(identifier.method_12836(), identifier.method_12832().replace("_modelmat", "")) : identifier;
        class_3298 resource = this.resourceFactory.method_14486(newIdentifier);
        if (resource == null) {
            throw new IOException();
        }
        InputStream inputStream2 = resource.method_14482();
        if (newIdentifier.method_12832().endsWith(".json")) {
            JsonObject dataObject = new JsonParser().parse(IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8)).getAsJsonObject();
            inputStream2.close();
            dataObject.addProperty("vertex", dataObject.get("vertex").getAsString() + "_modelmat");
            JsonArray attributeArray = dataObject.get("attributes").getAsJsonArray();
            for (int i = 0; i < 6 - attributeArray.size(); ++i) {
                attributeArray.add("Dummy" + i);
            }
            attributeArray.add("ModelMat");
            returningContent = dataObject.toString();
        } else if (newIdentifier.method_12832().endsWith(".vsh")) {
            returningContent = PatchingResourceProvider.patchVertexShaderSource(IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8));
            inputStream2.close();
        } else {
            return resource;
        }
        return new class_3306(resource.method_14480(), identifier, (InputStream)new ByteArrayInputStream(returningContent.getBytes(StandardCharsets.UTF_8)), null);
    }

    private static String patchVertexShaderSource(String sourceContent) {
        String[] contentParts = sourceContent.split("void main");
        contentParts[0] = contentParts[0].replace("uniform mat4 ModelViewMat;", "uniform mat4 ModelViewMat;\nin mat4 ModelMat;");
        if (GlStateTracker.isGl4ES()) {
            contentParts[0] = contentParts[0].replace("ivec2", "vec2");
        }
        contentParts[1] = contentParts[1].replaceAll("\\bPosition\\b", "(MODELVIEWMAT * ModelMat * vec4(Position, 1.0)).xyz").replaceAll("\\bNormal\\b", "normalize(mat3(MODELVIEWMAT * ModelMat) * Normal)").replace("ModelViewMat", "mat4(1.0)").replace("MODELVIEWMAT", "ModelViewMat");
        return contentParts[0] + "void main" + contentParts[1];
    }
}

