/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.tool;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import net.minecraft.class_5944;
import org.lwjgl.opengl.GL33;
import org.mtr.mapping.tool.DummyClass;

public final class GlStateTracker {
    private static boolean supportVertexAttributeDivisor;
    private static boolean isGl4ES;
    private static int vertArrayBinding;
    private static int arrayBufBinding;
    private static int elementBufBinding;
    private static class_5944 currentShaderProgram;
    private static boolean isStateProtected;

    public static void capture() {
        int contextVersion = GL33.glGetInteger((int)33307) * 10 + GL33.glGetInteger((int)33308);
        supportVertexAttributeDivisor = contextVersion >= 33;
        String glVersion = GL33.glGetString((int)7938);
        boolean bl = isGl4ES = glVersion != null && glVersion.toLowerCase(Locale.ENGLISH).contains("gl4es");
        if (isStateProtected) {
            return;
        }
        vertArrayBinding = GL33.glGetInteger((int)34229);
        arrayBufBinding = GL33.glGetInteger((int)34964);
        elementBufBinding = GL33.glGetInteger((int)34965);
        currentShaderProgram = RenderSystem.getShader();
        isStateProtected = true;
    }

    public static void restore() {
        if (!isStateProtected) {
            IllegalStateException e = new IllegalStateException("GlStateTracker: Not captured");
            DummyClass.logException(e);
            throw e;
        }
        GL33.glBindVertexArray((int)vertArrayBinding);
        GL33.glBindBuffer((int)34962, (int)arrayBufBinding);
        GL33.glBindBuffer((int)34963, (int)elementBufBinding);
        RenderSystem.setShader(() -> currentShaderProgram);
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        isStateProtected = false;
    }

    public static void assertProtected() {
        if (!isStateProtected) {
            IllegalStateException e = new IllegalStateException("GlStateTracker: Not protected");
            DummyClass.logException(e);
            throw e;
        }
    }

    public static boolean supportVertexAttributeDivisor() {
        return supportVertexAttributeDivisor;
    }

    public static boolean isGl4ES() {
        return isGl4ES;
    }

    static {
        isGl4ES = false;
    }
}

