/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import org.mtr.core.data.Depot;
import org.mtr.core.operation.NearbyAreasRequest;
import org.mtr.core.operation.NearbyAreasResponse;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.EntityHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.Init;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockWaterloggable;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.item.ItemDepotDriverKey;
import org.mtr.mod.packet.PacketOpenBlockEntityScreen;

public class BlockDriverKeyDispenser
extends BlockWaterloggable
implements DirectionHelper,
BlockWithEntity {
    public static final BooleanProperty TRIGGERED = BooleanProperty.of("triggered");

    public BlockDriverKeyDispenser(BlockSettings blockSettings) {
        super(blockSettings.nonOpaque());
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            org.mtr.mapping.holder.BlockEntity entity = world.getBlockEntity(pos);
            if (entity != null && entity.data instanceof BlockEntity) {
                ((BlockEntity)((Object)((Object)entity.data))).markDirty2();
                Init.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast(player), new PacketOpenBlockEntityScreen(pos));
            }
        });
    }

    @Override
    @Nonnull
    public BlockState getPlacementState2(ItemPlacementContext itemPlacementContext) {
        Direction facing = itemPlacementContext.getPlayerFacing().getOpposite();
        return super.getPlacementState2(itemPlacementContext).with(new Property((class_2769)BlockDriverKeyDispenser.FACING.data), facing.data);
    }

    @Override
    public void neighborUpdate2(BlockState state, World world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean hasPower = BlockDriverKeyDispenser.isReceivingRedstonePower(world, pos) || BlockDriverKeyDispenser.isReceivingRedstonePower(world, pos.up());
        boolean isTriggered = (Boolean)state.get(new Property((class_2769)BlockDriverKeyDispenser.TRIGGERED.data));
        if (hasPower && !isTriggered) {
            BlockDriverKeyDispenser.scheduleBlockTick(world, pos, new Block(this), 4);
            world.setBlockState(pos, state.with(new Property((class_2769)BlockDriverKeyDispenser.TRIGGERED.data), true), 2);
        } else if (!hasPower && isTriggered) {
            world.setBlockState(pos, state.with(new Property((class_2769)BlockDriverKeyDispenser.TRIGGERED.data), false), 2);
        }
    }

    @Override
    public void scheduledTick2(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        org.mtr.mapping.holder.BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null && blockEntity.data instanceof BlockEntity) {
            ((BlockEntity)((Object)blockEntity.data)).dispense(Direction.convert((class_2350)state.get(new Property((class_2769)BlockDriverKeyDispenser.FACING.data))));
        }
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add(FACING);
        properties.add(TRIGGERED);
    }

    @Override
    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    private static boolean isReceivingRedstonePower(World world, BlockPos pos) {
        if (world.isEmittingRedstonePower(pos.down(), Direction.DOWN)) {
            return true;
        }
        if (world.isEmittingRedstonePower(pos.up(), Direction.UP)) {
            return true;
        }
        if (world.isEmittingRedstonePower(pos.north(), Direction.NORTH)) {
            return true;
        }
        if (world.isEmittingRedstonePower(pos.south(), Direction.SOUTH)) {
            return true;
        }
        if (world.isEmittingRedstonePower(pos.west(), Direction.WEST)) {
            return true;
        }
        return world.isEmittingRedstonePower(pos.east(), Direction.EAST);
    }

    public static class BlockEntity
    extends BlockEntityExtension {
        private boolean dispenseBasicDriverKey = false;
        private boolean dispenseAdvancedDriverKey = false;
        private boolean dispenseGuardKey = false;
        private long timeout = 3600000L;
        private static final String KEY_DISPENSE_BASIC_DRIVER_KEY = "dispense_basic_driver_key";
        private static final String KEY_DISPENSE_ADVANCED_DRIVER_KEY = "dispense_advanced_driver_key";
        private static final String KEY_DISPENSE_GUARD_KEY = "dispense_gaurd_key";
        private static final String KEY_TIMEOUT = "timeout";

        public BlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType<?>)BlockEntityTypes.DRIVER_KEY_DISPENSER.get(), pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.dispenseBasicDriverKey = compoundTag.getBoolean(KEY_DISPENSE_BASIC_DRIVER_KEY);
            this.dispenseAdvancedDriverKey = compoundTag.getBoolean(KEY_DISPENSE_ADVANCED_DRIVER_KEY);
            this.dispenseGuardKey = compoundTag.getBoolean(KEY_DISPENSE_GUARD_KEY);
            this.timeout = compoundTag.getLong(KEY_TIMEOUT);
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putBoolean(KEY_DISPENSE_BASIC_DRIVER_KEY, this.dispenseBasicDriverKey);
            compoundTag.putBoolean(KEY_DISPENSE_ADVANCED_DRIVER_KEY, this.dispenseAdvancedDriverKey);
            compoundTag.putBoolean(KEY_DISPENSE_GUARD_KEY, this.dispenseGuardKey);
            compoundTag.putLong(KEY_TIMEOUT, this.timeout);
            super.writeCompoundTag(compoundTag);
        }

        public void setData(boolean dispenseBasicDriverKey, boolean dispenseAdvancedDriverKey, boolean dispenseGuardKey, long timeout2) {
            this.dispenseBasicDriverKey = dispenseBasicDriverKey;
            this.dispenseAdvancedDriverKey = dispenseAdvancedDriverKey;
            this.dispenseGuardKey = dispenseGuardKey;
            this.timeout = timeout2;
            this.markDirty2();
        }

        public boolean getDispenseBasicDriverKey() {
            return this.dispenseBasicDriverKey;
        }

        public boolean getDispenseAdvancedDriverKey() {
            return this.dispenseAdvancedDriverKey;
        }

        public boolean getDispenseGuardKey() {
            return this.dispenseGuardKey;
        }

        public long getTimeout() {
            return this.timeout;
        }

        private void dispense(Direction direction) {
            World world = this.getWorld2();
            if (world != null && !world.isClient()) {
                Init.sendMessageC2S("nearby_depots", world.getServer(), world, new NearbyAreasRequest(Init.blockPosToPosition(this.getPos2()), 0L), nearbyAreasResponse -> {
                    block3: {
                        ObjectIterator objectIterator = nearbyAreasResponse.getDepots().iterator();
                        if (!objectIterator.hasNext()) break block3;
                        Depot depot = (Depot)objectIterator.next();
                        if (this.dispenseBasicDriverKey) {
                            this.spawnItemStack(world, depot, Items.BASIC_DRIVER_KEY.get().getDefaultStack(), direction);
                        }
                        if (this.dispenseAdvancedDriverKey) {
                            this.spawnItemStack(world, depot, Items.ADVANCED_DRIVER_KEY.get().getDefaultStack(), direction);
                        }
                        if (this.dispenseGuardKey) {
                            this.spawnItemStack(world, depot, Items.GUARD_KEY.get().getDefaultStack(), direction);
                        }
                    }
                }, NearbyAreasResponse.class);
            }
        }

        private void spawnItemStack(World world, Depot depot, ItemStack itemStack, Direction direction) {
            ItemDepotDriverKey.setData(itemStack, depot, this.timeout);
            itemStack.setCustomName(new Text((class_2561)TextHelper.literal((String)String.format((String)"%s (%s)", (Object[])new Object[]{itemStack.getItem().getName().getString(), depot.getName()})).data));
            EntityHelper.spawnItem(ServerWorld.cast(world), this.getPos2().offset(direction), itemStack);
        }
    }
}

