/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import org.mtr.mapping.holder.MathHelper;

public enum DoorAnimationType {
    STANDARD(0.5f),
    STANDARD_SLOW(0.5f),
    CONSTANT(0.5f),
    PLUG_FAST(0.5f),
    PLUG_SLOW(2.0f),
    BOUNCY_1(0.5f),
    BOUNCY_2(0.5f),
    MLR(0.7f),
    R179(0.6f),
    R211(0.7f);

    public final float maxTime;

    private DoorAnimationType(float maxTime) {
        this.maxTime = maxTime;
    }

    public static float getDoorAnimationX(DoorAnimationType doorAnimationType, float value) {
        switch (doorAnimationType) {
            case PLUG_FAST: {
                return (double)value < 0.05 ? -value * 20.0f - 0.01f : -1.01f;
            }
            case PLUG_SLOW: {
                return DoorAnimationType.smoothEnds(0.01f, 1.01f, 0.0f, 0.1f, value);
            }
        }
        return 0.0f;
    }

    public static float getDoorAnimationZ(DoorAnimationType doorAnimationType, int doorMax, float duration, float value, boolean opening) {
        switch (doorAnimationType) {
            case CONSTANT: {
                return (float)doorMax * MathHelper.clamp(value, 0.0f, 1.0f) / duration;
            }
            case PLUG_FAST: {
                return DoorAnimationType.smoothEnds(-doorMax, doorMax, -duration, duration, value);
            }
            case PLUG_SLOW: {
                if (opening) {
                    return DoorAnimationType.smoothEnds(0.0f, doorMax, 0.05f, 0.5f, value);
                }
                if ((double)value > 0.5) {
                    return DoorAnimationType.smoothEnds(2.0f, doorMax, 0.5f, 1.0f, value);
                }
                if ((double)value < 0.3) {
                    return DoorAnimationType.smoothEnds(0.0f, 2.0f, 0.05f, 0.3f, value);
                }
                return 2.0f;
            }
            case BOUNCY_1: {
                if (opening) {
                    if ((double)value > 0.4) {
                        return DoorAnimationType.smoothEnds(doorMax - 1, (float)doorMax - 0.5f, 0.4f, 0.5f, value);
                    }
                    return DoorAnimationType.smoothEnds(-doorMax + 1, doorMax - 1, -0.4f, 0.4f, value);
                }
                if ((double)value > 0.2) {
                    return DoorAnimationType.smoothEnds(1.0f, (float)doorMax - 0.5f, 0.2f, 0.5f, value);
                }
                if ((double)value > 0.1) {
                    return DoorAnimationType.smoothEnds(1.5f, 1.0f, 0.1f, 0.2f, value);
                }
                return DoorAnimationType.smoothEnds(-1.5f, 1.5f, -0.1f, 0.1f, value);
            }
            case BOUNCY_2: {
                if (opening) {
                    if ((double)value > 0.4) {
                        return DoorAnimationType.smoothEnds((float)doorMax - 0.5f, doorMax, 0.4f, 0.5f, value);
                    }
                    return DoorAnimationType.smoothEnds((float)(-doorMax) + 0.5f, (float)doorMax - 0.5f, -0.4f, 0.4f, value);
                }
                if ((double)value > 0.3) {
                    return DoorAnimationType.smoothEnds(1.0f, doorMax, 0.3f, 0.5f, value);
                }
                if ((double)value > 0.1) {
                    return DoorAnimationType.smoothEnds(3.0f, 1.0f, 0.1f, 0.3f, value);
                }
                return DoorAnimationType.smoothEnds(-3.0f, 3.0f, -0.1f, 0.1f, value);
            }
            case MLR: {
                if (opening) {
                    if ((double)value < 0.2) {
                        return 0.0f;
                    }
                    if ((double)value > 0.7) {
                        return doorMax;
                    }
                    return (value - 0.2f) * 2.0f * (float)doorMax;
                }
                float stoppingPoint = 1.5f;
                if ((double)value > 0.25) {
                    return Math.min((value - 0.25f) * 2.0f * (float)doorMax + 1.5f + 1.0f, (float)doorMax);
                }
                if ((double)value > 0.2) {
                    return DoorAnimationType.smoothEnds(1.5f, 3.5f, 0.2f, 0.3f, value);
                }
                if ((double)value < 0.1) {
                    return value / 0.1f * 1.5f;
                }
                return 1.5f;
            }
            case R179: {
                if (opening) {
                    if ((double)value > 0.4) {
                        return DoorAnimationType.smoothEnds(doorMax - 1, (float)doorMax - 0.5f, 0.4f, 0.6f, value);
                    }
                    return DoorAnimationType.smoothEnds(-doorMax + 1, doorMax - 1, -0.4f, 0.4f, value);
                }
                if ((double)value > 0.2) {
                    return DoorAnimationType.smoothEnds(1.0f, (float)doorMax - 0.5f, 0.2f, 0.6f, value);
                }
                return DoorAnimationType.smoothEnds(-1.5f, 1.5f, -0.4f, 0.4f, value);
            }
            case R211: {
                if ((double)value < 0.2) {
                    return 0.0f;
                }
                if ((double)value > 0.7) {
                    return doorMax;
                }
                return (value - 0.2f) * 2.0f * (float)doorMax;
            }
            case STANDARD_SLOW: {
                if (opening) break;
                if ((double)value > 0.2) {
                    return DoorAnimationType.smoothEnds(1.0f, doorMax, 0.2f, duration, value);
                }
                if ((double)value > 0.1) {
                    return 1.0f;
                }
                return DoorAnimationType.smoothEnds(0.0f, 1.0f, 0.0f, 0.1f, value);
            }
        }
        return DoorAnimationType.smoothEnds(0.0f, doorMax, 0.0f, duration, value);
    }

    private static float smoothEnds(float startValue, float endValue, float startTime, float endTime, float time) {
        if (time < startTime) {
            return startValue;
        }
        if (time > endTime) {
            return endValue;
        }
        float timeChange = endTime - startTime;
        float valueChange = endValue - startValue;
        return valueChange * (float)(1.0 - Math.cos(Math.PI * (double)(time - startTime) / (double)timeChange)) / 2.0f + startValue;
    }
}

