/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.data;

import javax.annotation.Nonnull;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.mapper.PersistenceStateExtension;

public final class PersistentStateData
extends PersistenceStateExtension {
    private final LongAVLTreeSet routeIdsWithDisabledAnnouncements = new LongAVLTreeSet();
    private static final String KEY_DATA = "route_ids_with_disabled_announcements";

    public PersistentStateData() {
        super("mtr");
    }

    @Override
    public void readNbt(CompoundTag compoundTag) {
        this.routeIdsWithDisabledAnnouncements.clear();
        for (long routeId : compoundTag.getLongArray(KEY_DATA)) {
            this.routeIdsWithDisabledAnnouncements.add(routeId);
        }
    }

    @Override
    @Nonnull
    public CompoundTag writeNbt2(CompoundTag compoundTag) {
        compoundTag.putLongArray(KEY_DATA, this.routeIdsWithDisabledAnnouncements.toLongArray());
        return compoundTag;
    }

    public boolean getRouteIdHasDisabledAnnouncements(long routeId) {
        return this.routeIdsWithDisabledAnnouncements.contains(routeId);
    }

    public void setRouteIdHasDisabledAnnouncements(long routeId, boolean isDisabled) {
        if (isDisabled) {
            this.routeIdsWithDisabledAnnouncements.add(routeId);
        } else {
            this.routeIdsWithDisabledAnnouncements.remove(routeId);
        }
        this.markDirty2();
    }
}

