/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2769;
import org.mtr.core.data.Position;
import org.mtr.core.data.Rail;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.TwoPositionsBase;
import org.mtr.core.tool.Angle;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockNode;
import org.mtr.mod.data.RailType;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.item.ItemNodeModifierBase;
import org.mtr.mod.packet.PacketDeleteData;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.packet.PacketUpdateLastRailStyles;

public class ItemRailModifier
extends ItemNodeModifierBase {
    private final boolean isOneWay;
    private final RailType railType;

    public ItemRailModifier(ItemSettings itemSettings) {
        super(true, true, true, false, itemSettings);
        this.isOneWay = false;
        this.railType = null;
    }

    public ItemRailModifier(boolean forNonContinuousMovementNode, boolean forContinuousMovementNode, boolean forAirplaneNode, boolean isOneWay, RailType railType, ItemSettings itemSettings) {
        super(forNonContinuousMovementNode, forContinuousMovementNode, forAirplaneNode, true, itemSettings);
        this.isOneWay = isOneWay;
        this.railType = railType;
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable World world, List<MutableText> tooltip, TooltipContext options) {
        if (this.isConnector && this.railType != null && this.railType.canAccelerate) {
            tooltip.add(TranslationProvider.TOOLTIP_MTR_RAIL_SPEED_LIMIT.getMutableText(this.railType.speedLimit).formatted(TextFormatting.GRAY));
        }
        super.addTooltips(stack, world, tooltip, options);
    }

    @Override
    protected void onConnect(World world, ItemStack stack, TransportMode transportMode, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, Angle facingStart, Angle facingEnd, @Nullable ServerPlayerEntity player) {
        if (this.railType != null) {
            Rail rail = this.createRail(player == null ? null : player.getUuid(), transportMode, stateStart, stateEnd, posStart, posEnd, facingStart, facingEnd);
            if (rail != null) {
                world.setBlockState(posStart, stateStart.with(new Property((class_2769)BlockNode.IS_CONNECTED.data), true));
                world.setBlockState(posEnd, stateEnd.with(new Property((class_2769)BlockNode.IS_CONNECTED.data), true));
                PacketUpdateData.sendDirectlyToServerRail(ServerWorld.cast(world), rail);
            } else if (player != null) {
                player.sendMessage(TranslationProvider.GUI_MTR_INVALID_ORIENTATION.getText(new Object[0]), true);
            }
        }
    }

    @Override
    protected void onRemove(World world, BlockPos posStart, BlockPos posEnd, @Nullable ServerPlayerEntity player) {
        PacketDeleteData.sendDirectlyToServerRailId(ServerWorld.cast(world), TwoPositionsBase.getHexId(Init.blockPosToPosition(posStart), Init.blockPosToPosition(posEnd)));
    }

    @Nullable
    public Rail createRail(@Nullable UUID uuid, TransportMode transportMode, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, Angle facingStart, Angle facingEnd) {
        if (this.railType != null && uuid != null) {
            RailType newRailType;
            boolean isValidContinuousMovement;
            if (transportMode.continuousMovement) {
                Block blockStart = stateStart.getBlock();
                Block blockEnd = stateEnd.getBlock();
                if (blockStart.data instanceof BlockNode.BlockContinuousMovementNode && blockEnd.data instanceof BlockNode.BlockContinuousMovementNode && ((BlockNode.BlockContinuousMovementNode)blockStart.data).isStation && ((BlockNode.BlockContinuousMovementNode)blockEnd.data).isStation) {
                    isValidContinuousMovement = true;
                    newRailType = this.railType.isSavedRail ? this.railType : RailType.CABLE_CAR_STATION;
                } else {
                    int differenceX = posEnd.getX() - posStart.getX();
                    int differenceZ = posEnd.getZ() - posStart.getZ();
                    isValidContinuousMovement = !this.railType.isSavedRail && facingStart.isParallel(facingEnd) && ((facingStart == Angle.N || facingStart == Angle.S) && differenceX == 0 || (facingStart == Angle.E || facingStart == Angle.W) && differenceZ == 0 || (facingStart == Angle.NE || facingStart == Angle.SW) && differenceX == -differenceZ || (facingStart == Angle.SE || facingStart == Angle.NW) && differenceX == differenceZ);
                    newRailType = RailType.CABLE_CAR;
                }
            } else {
                isValidContinuousMovement = true;
                newRailType = this.railType;
            }
            Position positionStart = Init.blockPosToPosition(posStart);
            Position positionEnd = Init.blockPosToPosition(posEnd);
            Rail rail = switch (newRailType) {
                case RailType.PLATFORM -> Rail.newPlatformRail(positionStart, facingStart, positionEnd, facingEnd, Rail.Shape.QUADRATIC, 0.0, new ObjectArrayList<String>(), transportMode);
                case RailType.SIDING -> Rail.newSidingRail(positionStart, facingStart, positionEnd, facingEnd, Rail.Shape.QUADRATIC, 0.0, new ObjectArrayList<String>(), transportMode);
                case RailType.TURN_BACK -> Rail.newTurnBackRail(positionStart, facingStart, positionEnd, facingEnd, Rail.Shape.QUADRATIC, 0.0, new ObjectArrayList<String>(), transportMode);
                default -> Rail.newRail(positionStart, facingStart, positionEnd, facingEnd, newRailType.railShape, 0.0, new ObjectArrayList<String>(), this.isOneWay ? 0L : (long)newRailType.speedLimit, newRailType.speedLimit, false, false, newRailType.canAccelerate, newRailType == RailType.RUNWAY, newRailType.hasSignal, transportMode);
            };
            if (rail.isValid() && isValidContinuousMovement) {
                return PacketUpdateLastRailStyles.SERVER_CACHE.getRailWithLastStyles(uuid, rail);
            }
        }
        return null;
    }
}

