/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.function.Consumer;
import net.minecraft.class_1922;
import org.mtr.libraries.com.logisticscraft.occlusionculling.DataProvider;
import org.mtr.libraries.com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.MinecraftClientHelper;
import org.mtr.mod.CustomThread;
import org.mtr.mod.Init;

public final class WorkerThread
extends CustomThread {
    private static final int MAX_OCCLUSION_CHUNK_DISTANCE = 32;
    private static final int MAX_QUEUE_SIZE = 2;
    private int renderDistance;
    private OcclusionCullingInstance occlusionCullingInstance;
    private final ObjectArrayList<Consumer<OcclusionCullingInstance>> occlusionQueueVehicle = new ObjectArrayList();
    private final ObjectArrayList<Consumer<OcclusionCullingInstance>> occlusionQueueLift = new ObjectArrayList();
    private final ObjectArrayList<Consumer<OcclusionCullingInstance>> occlusionQueueRail = new ObjectArrayList();
    private final ObjectArrayList<Runnable> dynamicTextureQueue = new ObjectArrayList();

    @Override
    protected void runTick() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!(this.occlusionQueueVehicle.isEmpty() && this.occlusionQueueLift.isEmpty() && this.occlusionQueueRail.isEmpty())) {
            this.updateInstance();
            this.occlusionCullingInstance.resetCache();
            WorkerThread.run(this.occlusionQueueVehicle, task -> task.accept(this.occlusionCullingInstance));
            WorkerThread.run(this.occlusionQueueLift, task -> task.accept(this.occlusionCullingInstance));
            WorkerThread.run(this.occlusionQueueRail, task -> task.accept(this.occlusionCullingInstance));
        }
        WorkerThread.run(this.dynamicTextureQueue, Runnable::run);
    }

    @Override
    protected boolean isRunning() {
        return MinecraftClient.getInstance().isRunning();
    }

    public void scheduleVehicles(Consumer<OcclusionCullingInstance> consumer) {
        if (this.occlusionQueueVehicle.size() < 2) {
            this.occlusionQueueVehicle.add(consumer);
        }
    }

    public void scheduleLifts(Consumer<OcclusionCullingInstance> consumer) {
        if (this.occlusionQueueLift.size() < 2) {
            this.occlusionQueueLift.add(consumer);
        }
    }

    public void scheduleRails(Consumer<OcclusionCullingInstance> consumer) {
        if (this.occlusionQueueRail.size() < 2) {
            this.occlusionQueueRail.add(consumer);
        }
    }

    public void scheduleDynamicTextures(Runnable runnable2) {
        this.dynamicTextureQueue.add(runnable2);
    }

    private void updateInstance() {
        int newRenderDistance = MinecraftClientHelper.getRenderDistance();
        if (this.renderDistance != newRenderDistance) {
            this.renderDistance = newRenderDistance;
            this.occlusionCullingInstance = new OcclusionCullingInstance(Math.min(this.renderDistance, 32) * 16, new CullingDataProvider());
        }
    }

    private static <T> void run(ObjectArrayList<T> queue, Consumer<T> consumer) {
        if (!queue.isEmpty()) {
            try {
                T task = queue.remove(0);
                if (task != null) {
                    consumer.accept(task);
                }
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        }
    }

    private static final class CullingDataProvider
    implements DataProvider {
        private final MinecraftClient minecraftClient = MinecraftClient.getInstance();
        private ClientWorld clientWorld = null;

        private CullingDataProvider() {
        }

        @Override
        public boolean prepareChunk(int chunkX, int chunkZ) {
            this.clientWorld = this.minecraftClient.getWorldMapped();
            return this.clientWorld != null;
        }

        @Override
        public boolean isOpaqueFullCube(int x, int y, int z) {
            BlockPos blockPos = new BlockPos(x, y, z);
            return this.clientWorld != null && this.clientWorld.getBlockState(blockPos).isOpaqueFullCube(new BlockView((class_1922)this.clientWorld.data), blockPos);
        }

        @Override
        public void cleanup() {
            this.clientWorld = null;
        }
    }
}

