/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.class_1657;
import net.minecraft.class_339;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Items;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.PlayerInventory;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketAddBalance;
import org.mtr.mod.screen.MTRScreenBase;

public class TicketMachineScreen
extends MTRScreenBase
implements IGui {
    private final ButtonWidgetExtension[] buttons = new ButtonWidgetExtension[10];
    private final MutableText balanceText;
    private static final int BUTTON_COUNT = 10;
    private static final int BUTTON_WIDTH = 80;

    public TicketMachineScreen(int balance) {
        for (int i = 0; i < 10; ++i) {
            int index = i;
            this.buttons[i] = new ButtonWidgetExtension(0, 0, 0, 20, TranslationProvider.GUI_MTR_ADD_VALUE.getMutableText(new Object[0]), button -> {
                InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketAddBalance(index));
                MinecraftClient.getInstance().openScreen(null);
            });
        }
        this.balanceText = TranslationProvider.GUI_MTR_BALANCE.getMutableText(balance);
    }

    @Override
    protected void init2() {
        super.init2();
        for (int i = 0; i < 10; ++i) {
            IDrawing.setPositionAndWidth(this.buttons[i], this.field_22789 - 80, 20 * (i + 1), 76);
        }
        for (ButtonWidgetExtension button : this.buttons) {
            this.addChild(new ClickableWidget((class_339)button));
        }
    }

    @Override
    public void tick2() {
        int emeraldCount = this.getEmeraldCount();
        for (int i = 0; i < 10; ++i) {
            this.buttons[i].field_22763 = (double)emeraldCount >= Math.pow(2.0, i);
        }
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        MutableText emeraldsText = TranslationProvider.GUI_MTR_EMERALDS.getMutableText(this.getEmeraldCount());
        graphicsHolder.drawText(this.balanceText, 6, 6, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(emeraldsText, this.field_22789 - 6 - GraphicsHolder.getTextWidth(emeraldsText), 6, -1, false, GraphicsHolder.getDefaultLight());
        for (int i = 0; i < 10; ++i) {
            graphicsHolder.drawText(TranslationProvider.GUI_MTR_ADD_BALANCE_FOR_EMERALDS.getMutableText(PacketAddBalance.getAddAmount(i), (int)Math.pow(2.0, i)), 6, (i + 1) * 20 + 6, -1, false, GraphicsHolder.getDefaultLight());
        }
        super.render(graphicsHolder, mouseX, mouseY, delta);
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    private int getEmeraldCount() {
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        PlayerInventory playerInventory = clientPlayerEntity == null ? null : PlayerHelper.getPlayerInventory(new PlayerEntity((class_1657)clientPlayerEntity.data));
        return playerInventory == null ? 0 : playerInventory.count(Items.getEmeraldMapped());
    }
}

