/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class ItemPlacementContext
extends HolderBase<BlockPlaceContext> {
    public ItemPlacementContext(BlockPlaceContext data) {
        super(data);
    }

    @MappedMethod
    public static ItemPlacementContext cast(HolderBase<?> data) {
        return new ItemPlacementContext((BlockPlaceContext)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof BlockPlaceContext;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((BlockPlaceContext)this.data).equals(((HolderBase)data).data);
    }

    @MappedMethod
    public boolean hitsInsideBlock() {
        return ((BlockPlaceContext)this.data).m_43721_();
    }

    @Nonnull
    @MappedMethod
    public Direction getPlayerFacing() {
        return Direction.convert(((BlockPlaceContext)this.data).m_8125_());
    }

    @Nonnull
    @MappedMethod
    public ItemStack getStack() {
        return new ItemStack(((BlockPlaceContext)this.data).m_43722_());
    }

    @Nonnull
    @MappedMethod
    public Vector3d getHitPos() {
        return new Vector3d(((BlockPlaceContext)this.data).m_43720_());
    }

    @Nonnull
    @MappedMethod
    public static ItemPlacementContext offset(ItemPlacementContext arg0, BlockPos arg1, Direction arg2) {
        return new ItemPlacementContext(BlockPlaceContext.m_43644_((BlockPlaceContext)((BlockPlaceContext)arg0.data), (net.minecraft.core.BlockPos)((net.minecraft.core.BlockPos)arg1.data), (net.minecraft.core.Direction)arg2.data));
    }

    @MappedMethod
    public boolean shouldCancelInteraction() {
        return ((BlockPlaceContext)this.data).m_7078_();
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getPlayer() {
        Player tempData = ((BlockPlaceContext)this.data).m_43723_();
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @MappedMethod
    public float getPlayerYaw() {
        return ((BlockPlaceContext)this.data).m_7074_();
    }

    @MappedMethod
    public boolean canReplaceExisting() {
        return ((BlockPlaceContext)this.data).m_7058_();
    }

    @Nonnull
    @MappedMethod
    public BlockPos getBlockPos() {
        return new BlockPos(((BlockPlaceContext)this.data).m_8083_());
    }

    @Nonnull
    @MappedMethod
    public World getWorld() {
        return new World(((BlockPlaceContext)this.data).m_43725_());
    }

    @Nonnull
    @MappedMethod
    public Direction getSide() {
        return Direction.convert(((BlockPlaceContext)this.data).m_43719_());
    }

    @Nonnull
    @MappedMethod
    public Direction getPlayerLookDirection() {
        return Direction.convert(((BlockPlaceContext)this.data).m_7820_());
    }

    @MappedMethod
    public boolean canPlace() {
        return ((BlockPlaceContext)this.data).m_7059_();
    }

    @MappedMethod
    public ItemPlacementContext(PlayerEntity arg0, Hand arg1, ItemStack arg2, BlockHitResult arg3) {
        super(new BlockPlaceContext((Player)arg0.data, arg1.data, (net.minecraft.world.item.ItemStack)arg2.data, (net.minecraft.world.phys.BlockHitResult)arg3.data));
    }

    @Deprecated
    public ItemPlacementContext(World arg0, @Nullable PlayerEntity arg1, Hand arg2, ItemStack arg3, BlockHitResult arg4) {
        super(new BlockPlaceContext((Level)arg0.data, arg1 == null ? null : (Player)arg1.data, arg2.data, (net.minecraft.world.item.ItemStack)arg3.data, (net.minecraft.world.phys.BlockHitResult)arg4.data));
    }

    @MappedMethod
    public ItemPlacementContext(ItemUsageContext arg0) {
        super(new BlockPlaceContext((UseOnContext)arg0.data));
    }

    @Nonnull
    @MappedMethod
    public Hand getHand() {
        return Hand.convert(((BlockPlaceContext)this.data).m_43724_());
    }
}

