/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.Axis;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.block.IBlock;

public class BlockClock
extends BlockExtension
implements BlockWithEntity {
    public static final BooleanProperty FACING = BooleanProperty.of("facing");

    public BlockClock(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        boolean facing = ctx.getPlayerFacing().getAxis() == Axis.X;
        return this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)BlockClock.FACING.data), facing);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING) ? Direction.EAST : Direction.NORTH;
        return VoxelShapes.union(IBlock.getVoxelShapeByDirection(3.0, 0.0, 6.0, 13.0, 12.0, 10.0, facing), Block.createCuboidShape(7.5, 12.0, 7.5, 8.5, 16.0, 8.5));
    }

    @Override
    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
    }

    public static class BlockEntity
    extends BlockEntityExtension {
        public BlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType<?>)BlockEntityTypes.CLOCK.get(), pos, state);
        }
    }
}

