/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyPair;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3324;
import net.minecraft.class_5218;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BossBarManager;
import org.mtr.mapping.holder.CommandFunctionManager;
import org.mtr.mapping.holder.DataCommandStorage;
import org.mtr.mapping.holder.Difficulty;
import org.mtr.mapping.holder.GameMode;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.PlayerManager;
import org.mtr.mapping.holder.SaveProperties;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.WorldSavePath;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class MinecraftServer
extends HolderBase<net.minecraft.server.MinecraftServer> {
    public MinecraftServer(net.minecraft.server.MinecraftServer data) {
        super(data);
    }

    @MappedMethod
    public static MinecraftServer cast(HolderBase<?> data) {
        return new MinecraftServer((net.minecraft.server.MinecraftServer)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof net.minecraft.server.MinecraftServer;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((net.minecraft.server.MinecraftServer)this.data).equals(((HolderBase)data).data);
    }

    @Nonnull
    @MappedMethod
    public SaveProperties getSaveProperties() {
        return new SaveProperties(((net.minecraft.server.MinecraftServer)this.data).method_27728());
    }

    @Nonnull
    @MappedMethod
    public DataFixer getDataFixer() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3855();
    }

    @MappedMethod
    public void setDemo(boolean demo) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3730(demo);
    }

    @MappedMethod
    public void setMotd(String motd) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3834(motd);
    }

    @MappedMethod
    public boolean hasGui() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3727();
    }

    @MappedMethod
    public void setPvpEnabled(boolean pvpEnabled) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3815(pvpEnabled);
    }

    @Nonnull
    @MappedMethod
    public final ServerWorld getOverworld() {
        return new ServerWorld(((net.minecraft.server.MinecraftServer)this.data).method_30002());
    }

    @MappedMethod
    public void setDefaultGameMode(GameMode gameMode) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3838(gameMode.data);
    }

    @MappedMethod
    public boolean isDemo() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3799();
    }

    @Nonnull
    @MappedMethod
    public static <S extends net.minecraft.server.MinecraftServer> S startServer(Function<Thread, S> serverFactory) {
        return (S)net.minecraft.server.MinecraftServer.method_29740(serverFactory);
    }

    @Nonnull
    @MappedMethod
    public String[] getPlayerNames() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3858();
    }

    @Nonnull
    @MappedMethod
    public BossBarManager getBossBarManager() {
        return new BossBarManager(((net.minecraft.server.MinecraftServer)this.data).method_3837());
    }

    @MappedMethod
    public boolean isSpawnProtected(ServerWorld world, BlockPos pos, PlayerEntity player) {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3785((class_3218)world.data, (class_2338)pos.data, (class_1657)player.data);
    }

    @MappedMethod
    public int getPlayerIdleTimeout() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3862();
    }

    @MappedMethod
    public boolean isHardcore() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3754();
    }

    @MappedMethod
    public int getSpawnProtectionRadius() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3841();
    }

    @Nonnull
    @MappedMethod
    public Thread getThread() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3777();
    }

    @MappedMethod
    public void setPlayerIdleTimeout(int playerIdleTimeout) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3803(playerIdleTimeout);
    }

    @MappedMethod
    public int getPermissionLevel(GameProfile profile) {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3835(profile);
    }

    @Nonnull
    @MappedMethod
    public DataCommandStorage getDataCommandStorage() {
        return new DataCommandStorage(((net.minecraft.server.MinecraftServer)this.data).method_22827());
    }

    @MappedMethod
    public int getSpawnRadius(@Nullable ServerWorld world) {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3829(world == null ? null : (class_3218)world.data);
    }

    @MappedMethod
    public void stop(boolean waitForShutdown) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3747(waitForShutdown);
    }

    @MappedMethod
    public void setEnforceWhitelist(boolean enforceWhitelist) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3731(enforceWhitelist);
    }

    @MappedMethod
    public int adjustTrackingDistance(int initialDistance) {
        return ((net.minecraft.server.MinecraftServer)this.data).method_27903(initialDistance);
    }

    @Nonnull
    @MappedMethod
    public <V> CompletableFuture<V> submit(Supplier<V> task) {
        return ((net.minecraft.server.MinecraftServer)this.data).method_5385(task);
    }

    @Nonnull
    @MappedMethod
    public CompletableFuture<Void> submit(Runnable task) {
        return ((net.minecraft.server.MinecraftServer)this.data).method_20493(task);
    }

    @MappedMethod
    public boolean isHost(GameProfile profile) {
        return ((net.minecraft.server.MinecraftServer)this.data).method_19466(profile);
    }

    @MappedMethod
    public void close() {
        ((net.minecraft.server.MinecraftServer)this.data).close();
    }

    @Nonnull
    @MappedMethod
    public MinecraftSessionService getSessionService() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3844();
    }

    @MappedMethod
    public void setPreventProxyConnections(boolean preventProxyConnections) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3764(preventProxyConnections);
    }

    @MappedMethod
    public boolean isStopped() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3750();
    }

    @MappedMethod
    public void setPlayerManager(PlayerManager playerManager) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3846((class_3324)playerManager.data);
    }

    @MappedMethod
    public void dumpProperties(Path file) throws IOException {
        ((net.minecraft.server.MinecraftServer)this.data).method_37113(file);
    }

    @Nonnull
    @MappedMethod
    public KeyPair getKeyPair() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3716();
    }

    @Nonnull
    @MappedMethod
    public CompletableFuture<Void> reloadResources(Collection<String> dataPacks) {
        return ((net.minecraft.server.MinecraftServer)this.data).method_29439(dataPacks);
    }

    @Nonnull
    @MappedMethod
    public PlayerManager getPlayerManager() {
        return new PlayerManager(((net.minecraft.server.MinecraftServer)this.data).method_3760());
    }

    @MappedMethod
    public boolean isEnforceWhitelist() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3729();
    }

    @Nonnull
    @MappedMethod
    public File getFile(String path) {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3758(path);
    }

    @MappedMethod
    public void setFlightEnabled(boolean flightEnabled) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3745(flightEnabled);
    }

    @Nonnull
    @MappedMethod
    public GameProfileRepository getGameProfileRepo() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3719();
    }

    @Nonnull
    @MappedMethod
    public File getRunDirectory() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3831();
    }

    @Nonnull
    @MappedMethod
    public String getServerModName() {
        return ((net.minecraft.server.MinecraftServer)this.data).getServerModName();
    }

    @MappedMethod
    public void setDifficultyLocked(boolean locked) {
        ((net.minecraft.server.MinecraftServer)this.data).method_19467(locked);
    }

    @MappedMethod
    public boolean isRunning() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3806();
    }

    @MappedMethod
    public void execute(Runnable runnable2) {
        ((net.minecraft.server.MinecraftServer)this.data).execute(runnable2);
    }

    @MappedMethod
    public float getTickTime() {
        return ((net.minecraft.server.MinecraftServer)this.data).method_3830();
    }

    @MappedMethod
    public void setDifficulty(Difficulty difficulty, boolean forceUpdate) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3776(difficulty.data, forceUpdate);
    }

    @Nonnull
    @MappedMethod
    public Path getSavePath(WorldSavePath worldSavePath) {
        return ((net.minecraft.server.MinecraftServer)this.data).method_27050((class_5218)worldSavePath.data);
    }

    @Nonnull
    @MappedMethod
    public CommandFunctionManager getCommandFunctionManager() {
        return new CommandFunctionManager(((net.minecraft.server.MinecraftServer)this.data).method_3740());
    }

    @MappedMethod
    public void setOnlineMode(boolean onlineMode) {
        ((net.minecraft.server.MinecraftServer)this.data).method_3864(onlineMode);
    }
}

