/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.OrderedText;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.tool.ColorHelper;
import org.mtr.mapping.tool.DummyClass;

public final class GraphicsHolder
extends DummyClass {
    class_4588 vertexConsumer;
    private int matrixPushes;
    final class_4587 matrixStack;
    private final class_4597 vertexConsumerProvider;

    @MappedMethod
    public static int getDefaultLight() {
        return 0xF000F0;
    }

    @Deprecated
    public static void createInstanceSafe(@Nullable class_4587 matrixStack, @Nullable class_4597 vertexConsumerProvider, Consumer<GraphicsHolder> consumer) {
        GraphicsHolder graphicsHolder = new GraphicsHolder(matrixStack, vertexConsumerProvider);
        try {
            consumer.accept(graphicsHolder);
        }
        catch (Exception e) {
            GraphicsHolder.logException(e);
        }
        while (graphicsHolder.matrixPushes > 0) {
            graphicsHolder.pop();
        }
    }

    private GraphicsHolder(@Nullable class_4587 matrixStack, @Nullable class_4597 vertexConsumerProvider) {
        this.matrixStack = matrixStack;
        this.vertexConsumerProvider = vertexConsumerProvider;
        this.push();
    }

    @MappedMethod
    public void push() {
        if (this.matrixStack != null) {
            this.matrixStack.method_22903();
            ++this.matrixPushes;
        }
    }

    @MappedMethod
    public void pop() {
        if (this.matrixStack != null && this.matrixPushes > 0) {
            this.matrixStack.method_22909();
            --this.matrixPushes;
        }
    }

    @MappedMethod
    public void translate(double x, double y, double z) {
        if (this.matrixStack != null) {
            this.matrixStack.method_22904(x, y, z);
        }
    }

    @MappedMethod
    public void scale(float x, float y, float z) {
        if (this.matrixStack != null) {
            this.matrixStack.method_22905(x, y, z);
        }
    }

    @MappedMethod
    public void rotateXRadians(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.method_22907(class_7833.field_40714.rotation(angle));
        }
    }

    @MappedMethod
    public void rotateYRadians(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.method_22907(class_7833.field_40716.rotation(angle));
        }
    }

    @MappedMethod
    public void rotateZRadians(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.method_22907(class_7833.field_40718.rotation(angle));
        }
    }

    @MappedMethod
    public void rotateXDegrees(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.method_22907(class_7833.field_40714.rotationDegrees(angle));
        }
    }

    @MappedMethod
    public void rotateYDegrees(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.method_22907(class_7833.field_40716.rotationDegrees(angle));
        }
    }

    @MappedMethod
    public void rotateZDegrees(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.method_22907(class_7833.field_40718.rotationDegrees(angle));
        }
    }

    @MappedMethod
    public void drawText(MutableText mutableText, int x, int y, int color, boolean shadow, int light) {
        if (this.matrixStack != null) {
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            GraphicsHolder.getInstance().field_1772.method_30882((class_2561)mutableText.data, (float)x, (float)y, color, shadow, this.matrixStack.method_23760().method_23761(), (class_4597)immediate, class_327.class_6415.field_33993, 0, light);
            immediate.method_22993();
        }
    }

    @MappedMethod
    public void drawText(OrderedText orderedText, int x, int y, int color, boolean shadow, int light) {
        if (this.matrixStack != null) {
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            GraphicsHolder.getInstance().field_1772.method_22942((class_5481)orderedText.data, (float)x, (float)y, color, shadow, this.matrixStack.method_23760().method_23761(), (class_4597)immediate, class_327.class_6415.field_33993, 0, light);
            immediate.method_22993();
        }
    }

    @MappedMethod
    public void drawText(String text, int x, int y, int color, boolean shadow, int light) {
        if (this.matrixStack != null) {
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            GraphicsHolder.getInstance().field_1772.method_27521(text, (float)x, (float)y, color, shadow, this.matrixStack.method_23760().method_23761(), (class_4597)immediate, class_327.class_6415.field_33993, 0, light);
            immediate.method_22993();
        }
    }

    @MappedMethod
    public void drawCenteredText(String text, int centerX, int y, int color) {
        if (this.matrixStack != null) {
            class_332.method_25300((class_4587)this.matrixStack, (class_327)GraphicsHolder.getInstance().field_1772, (String)text, (int)centerX, (int)y, (int)color);
        }
    }

    @MappedMethod
    public void drawCenteredText(MutableText text, int centerX, int y, int color) {
        if (this.matrixStack != null) {
            class_332.method_27534((class_4587)this.matrixStack, (class_327)GraphicsHolder.getInstance().field_1772, (class_2561)((class_2561)text.data), (int)centerX, (int)y, (int)color);
        }
    }

    @MappedMethod
    public static int getTextWidth(MutableText mutableText) {
        return GraphicsHolder.getInstance().field_1772.method_27525((class_5348)mutableText.data);
    }

    @MappedMethod
    public static int getTextWidth(OrderedText orderedText) {
        return GraphicsHolder.getInstance().field_1772.method_30880((class_5481)orderedText.data);
    }

    @MappedMethod
    public static int getTextWidth(String text) {
        return GraphicsHolder.getInstance().field_1772.method_1727(text);
    }

    @MappedMethod
    public static List<OrderedText> wrapLines(MutableText mutableText, int width) {
        return GraphicsHolder.getInstance().field_1772.method_1728((class_5348)mutableText.data, width).stream().map(OrderedText::new).collect(Collectors.toList());
    }

    private static class_310 getInstance() {
        return class_310.method_1551();
    }

    @MappedMethod
    public void createVertexConsumer(RenderLayer renderLayer) {
        if (this.vertexConsumerProvider != null) {
            this.vertexConsumer = this.vertexConsumerProvider.getBuffer((class_1921)renderLayer.data);
        }
    }

    @MappedMethod
    public void drawLineInWorld(float x1, float y1, float z1, float x2, float y2, float z2, int color) {
        if (this.matrixStack != null && this.vertexConsumer != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                class_4587.class_4665 entry = this.matrixStack.method_23760();
                Matrix4f matrix4f = entry.method_23761();
                Matrix3f matrix3f = entry.method_23762();
                this.vertexConsumer.method_22918(matrix4f, x1, y1, z1).method_1336(r, g, b, a).method_23763(matrix3f, 0.0f, 1.0f, 0.0f).method_1344();
                this.vertexConsumer.method_22918(matrix4f, x2, y2, z2).method_1336(r, g, b, a).method_23763(matrix3f, 0.0f, 1.0f, 0.0f).method_1344();
            });
        }
    }

    @MappedMethod
    public void drawTextureInWorld(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        if (this.matrixStack != null && this.vertexConsumer != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                Vector3i vector3i = facing.getVector();
                int x = vector3i.getX();
                int y = vector3i.getY();
                int z = vector3i.getZ();
                class_4587.class_4665 entry = this.matrixStack.method_23760();
                Matrix4f matrix4f = entry.method_23761();
                Matrix3f matrix3f = entry.method_23762();
                this.vertexConsumer.method_22918(matrix4f, x1, y1, z1).method_1336(r, g, b, a).method_22913(u1, v2).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix3f, (float)x, (float)y, (float)z).method_1344();
                this.vertexConsumer.method_22918(matrix4f, x2, y2, z2).method_1336(r, g, b, a).method_22913(u2, v2).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix3f, (float)x, (float)y, (float)z).method_1344();
                this.vertexConsumer.method_22918(matrix4f, x3, y3, z3).method_1336(r, g, b, a).method_22913(u2, v1).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix3f, (float)x, (float)y, (float)z).method_1344();
                this.vertexConsumer.method_22918(matrix4f, x4, y4, z4).method_1336(r, g, b, a).method_22913(u1, v1).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix3f, (float)x, (float)y, (float)z).method_1344();
            });
        }
    }

    @MappedMethod
    public void renderEntity(Entity entity, double x, double y, double z, float yaw, float tickDelta, int light) {
        if (this.matrixStack != null && this.vertexConsumerProvider != null) {
            GraphicsHolder.getInstance().method_1561().method_3954((class_1297)entity.data, x, y, z, yaw, tickDelta, this.matrixStack, this.vertexConsumerProvider, light);
        }
    }
}

