/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonArray;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.com.google.gson.JsonPrimitive;
import org.mtr.mod.Init;

public final class BlockbenchModelValidator {
    public static void validate(JsonObject modelObject, String id, @Nullable BiConsumer<Boolean, String> assertTrue) {
        BlockbenchModelValidator.iterateChildren(modelObject, value -> {}, value -> {});
        modelObject.addProperty("name", id);
        modelObject.addProperty("model_identifier", id);
        modelObject.addProperty("modded_entity_version", "1.17_yarn");
        modelObject.remove("fabricOptions");
        try {
            modelObject.getAsJsonArray("textures").forEach(textureElement -> {
                JsonObject textureObject = textureElement.getAsJsonObject();
                textureObject.remove("path");
                textureObject.remove("source");
                if (assertTrue != null) {
                    String relativePath = textureObject.get("relative_path").getAsString();
                    assertTrue.accept(relativePath.startsWith("../../textures/vehicle/") || relativePath.startsWith("../../textures/overlay/"), relativePath);
                }
            });
        }
        catch (Exception ignored) {
            Init.LOGGER.warn("Failed to read textures from Blockbench model [{}]", (Object)id);
        }
    }

    public static void processValue(String valueString, DoubleConsumer setValueDouble, IntConsumer setValueInt) {
        if (valueString.matches("-?\\d\\.\\d+e-\\d+")) {
            setValueInt.accept(0);
        } else {
            int index1 = valueString.indexOf("999");
            int index2 = valueString.indexOf("000");
            if (valueString.matches("-?\\d+\\.\\d*999\\d*") && (index2 < 0 || index1 < index2)) {
                BlockbenchModelValidator.setValue(valueString, "999", setValueDouble, setValueInt);
            } else if (valueString.matches("-?\\d+\\.\\d*000\\d*") && (index1 < 0 || index2 < index1)) {
                BlockbenchModelValidator.setValue(valueString, "000", setValueDouble, setValueInt);
            }
        }
    }

    private static void iterateChildren(JsonElement jsonElement, DoubleConsumer setValueDouble, IntConsumer setValueInt) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            jsonObject.entrySet().forEach(entry -> BlockbenchModelValidator.iterateChildren((JsonElement)entry.getValue(), value -> jsonObject.addProperty((String)entry.getKey(), value), value -> jsonObject.addProperty((String)entry.getKey(), value)));
        } else if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            int i = 0;
            while (i < jsonArray.size()) {
                int index = i++;
                BlockbenchModelValidator.iterateChildren(jsonArray.get(index), value -> jsonArray.set(index, new JsonPrimitive(value)), value -> jsonArray.set(index, new JsonPrimitive(value)));
            }
        } else {
            BlockbenchModelValidator.processValue(jsonElement.toString().toLowerCase(Locale.ENGLISH), setValueDouble, setValueInt);
        }
    }

    private static void setValue(String valueString, String matchingToken, DoubleConsumer setValueDouble, IntConsumer setValueInt) {
        String[] valueSplit = valueString.split("\\.");
        String decimalString = valueSplit[valueSplit.length - 1];
        BigDecimal decimalValue = BigDecimal.valueOf(Utilities.round(Double.parseDouble(String.format("%s0.%s", valueString.startsWith("-") ? "-" : "", decimalString)), decimalString.indexOf(matchingToken) + 2));
        BigDecimal value = valueSplit.length > 1 ? decimalValue.add(BigDecimal.valueOf(Integer.parseInt(valueSplit[0]))) : decimalValue;
        if (decimalValue.equals(BigDecimal.ZERO)) {
            setValueInt.accept(value.intValueExact());
        } else {
            setValueDouble.accept(value.doubleValue());
        }
    }
}

