/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import javax.annotation.Nullable;
import net.minecraft.class_339;
import org.mtr.mapping.holder.ButtonWidget;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Util;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.OptimizedRenderer;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Init;
import org.mtr.mod.Patreon;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.config.Client;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.screen.MTRScreenBase;
import org.mtr.mod.screen.WidgetShorterSlider;

public class ConfigScreen
extends MTRScreenBase
implements IGui {
    private final Client client = Config.getClient();
    private final ButtonWidgetExtension buttonShowAnnouncementMessages = new ButtonWidgetExtension(0, 0, 0, 16, TextHelper.literal(""), button -> {
        this.client.toggleChatAnnouncements();
        ConfigScreen.setButtonText(button, this.client.getChatAnnouncements());
    });
    private final ButtonWidgetExtension buttonUseTTSAnnouncements = new ButtonWidgetExtension(0, 0, 0, 16, TextHelper.literal(""), button -> {
        this.client.toggleTextToSpeechAnnouncements();
        ConfigScreen.setButtonText(button, this.client.getTextToSpeechAnnouncements());
    });
    private final ButtonWidgetExtension buttonHideTranslucentParts = new ButtonWidgetExtension(0, 0, 0, 16, TextHelper.literal(""), button -> {
        this.client.toggleHideTranslucentParts();
        ConfigScreen.setButtonText(button, this.client.getHideTranslucentParts());
    });
    private final ButtonWidgetExtension buttonLanguageOptions = new ButtonWidgetExtension(0, 0, 0, 16, TextHelper.literal(""), button -> {
        this.client.cycleLanguageDisplay();
        button.setMessage(this.client.getLanguageDisplay().translationKey.getText(new Object[0]));
    });
    private final WidgetShorterSlider sliderDynamicTextureResolution = new WidgetShorterSlider(0, 0, 7, String::valueOf, null);
    private final WidgetShorterSlider sliderTrainOscillationMultiplier = new WidgetShorterSlider(0, 0, 15, i -> i * 10 + "%", null);
    private final ButtonWidgetExtension buttonDefaultRail3D = new ButtonWidgetExtension(0, 0, 0, 16, TextHelper.literal(""), button -> {
        this.client.toggleDefaultRail3D();
        ConfigScreen.setButtonText(button, this.client.getDefaultRail3D());
    });
    private final ButtonWidgetExtension buttonUseMTRFont = new ButtonWidgetExtension(0, 0, 0, 16, TextHelper.literal(""), button -> {
        this.client.toggleUseMTRFont();
        ConfigScreen.setButtonText(button, this.client.getUseMTRFont());
    });
    private final ButtonWidgetExtension buttonDisableShadowsForShaders = new ButtonWidgetExtension(0, 0, 0, 16, TextHelper.literal(""), button -> {
        this.client.toggleDisableShadowsForShaders();
        ConfigScreen.setButtonText(button, this.client.getDisableShadowsForShaders());
    });
    private final ButtonWidgetExtension buttonSupportPatreon = new ButtonWidgetExtension(0, 0, 0, 16, TextHelper.literal(""), button -> Util.getOperatingSystem().open("https://www.patreon.com/minecraft_transit_railway"));
    private static final Identifier HEADER_LOGO = new Identifier("mtr:textures/block/sign/logo.png");
    private static final int HEADER_LOGO_SIZE = 40;
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 16;

    public ConfigScreen(@Nullable Screen previousScreen) {
        super(previousScreen);
    }

    @Override
    protected void init2() {
        super.init2();
        int startY = 6;
        int i = 1;
        IDrawing.setPositionAndWidth(this.buttonShowAnnouncementMessages, this.field_22789 - 20 - 60, startY + 16 * i++ + 20, 60);
        IDrawing.setPositionAndWidth(this.buttonUseTTSAnnouncements, this.field_22789 - 20 - 60, startY + 16 * i++ + 20, 60);
        IDrawing.setPositionAndWidth(this.buttonHideTranslucentParts, this.field_22789 - 20 - 60, startY + 16 * i++ + 20, 60);
        IDrawing.setPositionAndWidth(this.buttonLanguageOptions, this.field_22789 - 20 - 60, startY + 16 * i++ + 20, 60);
        IDrawing.setPositionAndWidth(this.sliderDynamicTextureResolution, this.field_22789 - 20 - 60, startY + 16 * i++ + 20, 54 - GraphicsHolder.getTextWidth("100%"));
        IDrawing.setPositionAndWidth(this.sliderTrainOscillationMultiplier, this.field_22789 - 20 - 60, startY + 16 * i++ + 20, 54 - GraphicsHolder.getTextWidth("100%"));
        IDrawing.setPositionAndWidth(this.buttonDefaultRail3D, this.field_22789 - 20 - 60, startY + 16 * i++ + 20, 60);
        IDrawing.setPositionAndWidth(this.buttonUseMTRFont, this.field_22789 - 20 - 60, startY + 16 * i++ + 20, 60);
        IDrawing.setPositionAndWidth(this.buttonDisableShadowsForShaders, this.field_22789 - 20 - 60, startY + 16 * i++ + 20, 60);
        IDrawing.setPositionAndWidth(this.buttonSupportPatreon, this.field_22789 - 20 - 60, startY + 16 * i + 20, 60);
        ConfigScreen.setButtonText(new ButtonWidget(this.buttonShowAnnouncementMessages), this.client.getChatAnnouncements());
        ConfigScreen.setButtonText(new ButtonWidget(this.buttonUseTTSAnnouncements), this.client.getTextToSpeechAnnouncements());
        ConfigScreen.setButtonText(new ButtonWidget(this.buttonHideTranslucentParts), this.client.getHideTranslucentParts());
        ConfigScreen.setButtonText(new ButtonWidget(this.buttonDefaultRail3D), this.client.getDefaultRail3D());
        ConfigScreen.setButtonText(new ButtonWidget(this.buttonUseMTRFont), this.client.getUseMTRFont());
        ConfigScreen.setButtonText(new ButtonWidget(this.buttonDisableShadowsForShaders), this.client.getDisableShadowsForShaders());
        this.buttonLanguageOptions.setMessage2(this.client.getLanguageDisplay().translationKey.getText(new Object[0]));
        this.sliderDynamicTextureResolution.setHeight(16);
        this.sliderDynamicTextureResolution.setValue(this.client.getDynamicTextureResolution());
        this.sliderTrainOscillationMultiplier.setHeight(16);
        this.sliderTrainOscillationMultiplier.setValue((int)(this.client.getVehicleOscillationMultiplier() * 10.0));
        this.buttonDefaultRail3D.field_22763 = OptimizedRenderer.hasOptimizedRendering();
        this.buttonSupportPatreon.setMessage2(TranslationProvider.GUI_MTR_SUPPORT.getText(new Object[0]));
        this.addChild(new ClickableWidget((class_339)this.buttonShowAnnouncementMessages));
        this.addChild(new ClickableWidget((class_339)this.buttonUseTTSAnnouncements));
        this.addChild(new ClickableWidget((class_339)this.buttonHideTranslucentParts));
        this.addChild(new ClickableWidget((class_339)this.buttonLanguageOptions));
        this.addChild(new ClickableWidget((class_339)this.sliderDynamicTextureResolution));
        this.addChild(new ClickableWidget((class_339)this.sliderTrainOscillationMultiplier));
        this.addChild(new ClickableWidget((class_339)this.buttonDefaultRail3D));
        this.addChild(new ClickableWidget((class_339)this.buttonUseMTRFont));
        this.addChild(new ClickableWidget((class_339)this.buttonDisableShadowsForShaders));
        this.addChild(new ClickableWidget((class_339)this.buttonSupportPatreon));
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        try {
            this.renderBackground(graphicsHolder);
            this.drawHeader(graphicsHolder);
            int yStart1 = 29;
            int i = 1;
            graphicsHolder.drawText(TranslationProvider.OPTIONS_MTR_SHOW_ANNOUNCEMENT_MESSAGES.getMutableText(new Object[0]), 20, 16 * i++ + 29, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(TranslationProvider.OPTIONS_MTR_USE_TTS_ANNOUNCEMENTS.getMutableText(new Object[0]), 20, 16 * i++ + 29, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(TranslationProvider.OPTIONS_MTR_HIDE_TRANSLUCENT_PARTS.getMutableText(new Object[0]), 20, 16 * i++ + 29, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(TranslationProvider.OPTIONS_MTR_LANGUAGE_OPTIONS.getMutableText(new Object[0]), 20, 16 * i++ + 29, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(TranslationProvider.OPTIONS_MTR_DYNAMIC_TEXTURE_RESOLUTION.getMutableText(new Object[0]), 20, 16 * i++ + 29, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(TranslationProvider.OPTIONS_MTR_VEHICLE_OSCILLATION_MULTIPLIER.getMutableText(new Object[0]), 20, 16 * i++ + 29, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(TranslationProvider.OPTIONS_MTR_DEFAULT_RAIL_3D.getMutableText(new Object[0]), 20, 16 * i++ + 29, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(TranslationProvider.OPTIONS_MTR_USE_MTR_FONT.getMutableText(new Object[0]), 20, 16 * i++ + 29, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(TranslationProvider.OPTIONS_MTR_DISABLE_SHADOWS_FOR_SHADERS.getMutableText(new Object[0]), 20, 16 * i++ + 29, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(TranslationProvider.OPTIONS_MTR_SUPPORT_PATREON.getMutableText(new Object[0]), 20, 16 * i++ + 29, -154, false, GraphicsHolder.getDefaultLight());
            int yStart2 = 16 * (i + 1) + 29;
            String tierTitle = "";
            int y = 0;
            int x = 0;
            int maxWidth = 0;
            for (Patreon patreon : Patreon.PATREON_LIST) {
                MutableText text;
                if (!patreon.tierTitle.equals(tierTitle)) {
                    x += maxWidth + 6;
                    y = 0;
                    text = TextHelper.literal(patreon.tierTitle);
                    maxWidth = GraphicsHolder.getTextWidth(text);
                    graphicsHolder.drawText(text, 14 + x, yStart2, patreon.tierColor, false, GraphicsHolder.getDefaultLight());
                } else if (y + yStart2 + 8 + 20 > this.field_22790) {
                    x += maxWidth + 6;
                    y = 0;
                    maxWidth = 0;
                }
                tierTitle = patreon.tierTitle;
                text = patreon.tierAmount < 1000 ? TranslationProvider.OPTIONS_MTR_ANONYMOUS.getMutableText(new Object[0]) : TextHelper.literal(patreon.name);
                maxWidth = Math.max(maxWidth, GraphicsHolder.getTextWidth(text));
                graphicsHolder.drawText(text, 14 + x, yStart2 + y + 8 + 6, -5592406, false, GraphicsHolder.getDefaultLight());
                y += 10;
            }
            super.render(graphicsHolder, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public void onClose2() {
        super.onClose2();
        this.client.setDynamicTextureResolution(this.sliderDynamicTextureResolution.getIntValue());
        this.client.setVehicleOscillationMultiplier((double)this.sliderTrainOscillationMultiplier.getIntValue() / 10.0);
        DynamicTextureCache.instance.reload();
        Config.save();
    }

    private void drawHeader(GraphicsHolder graphicsHolder) {
        MutableText titleText = TranslationProvider.GUI_MTR_BRAND.getMutableText(new Object[0]);
        graphicsHolder.push();
        graphicsHolder.translate(((float)this.getWidthMapped() - (float)GraphicsHolder.getTextWidth(titleText) * 1.5f - 40.0f - 6.0f) / 2.0f, 0.0, 0.0);
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingTexture(HEADER_LOGO);
        guiDrawing.drawTexture(0.0, 0.0, 40.0, 40.0, 0.0f, 0.0f, 1.0f, 1.0f);
        guiDrawing.finishDrawingTexture();
        graphicsHolder.translate(40.0, 0.0, 0.0);
        graphicsHolder.translate(6.0, 0.0, 0.0);
        graphicsHolder.push();
        graphicsHolder.scale(1.5f, 1.5f, 1.5f);
        graphicsHolder.drawText(titleText, 0, 6, -1, true, GraphicsHolder.getDefaultLight());
        graphicsHolder.pop();
        graphicsHolder.drawText("4.0.2-hotfix-1+1.19.4", 0, 24, -1, true, GraphicsHolder.getDefaultLight());
        graphicsHolder.pop();
    }

    private static void setButtonText(ButtonWidget button, boolean state) {
        button.setMessage((state ? TranslationProvider.OPTIONS_MTR_ON : TranslationProvider.OPTIONS_MTR_OFF).getText(new Object[0]));
    }
}

