/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_339;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TexturedButtonWidgetExtension;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.TexturedButtonWidgetHelper;
import org.mtr.mod.screen.WidgetSilentImageButton;

public class DashboardList
implements IGui {
    public int x;
    public int y;
    public int width;
    public int height;
    private final TextFieldWidgetExtension textFieldSearch;
    private final TexturedButtonWidgetExtension buttonPrevPage;
    private final TexturedButtonWidgetExtension buttonNextPage;
    private final TexturedButtonWidgetExtension buttonFind;
    private final TexturedButtonWidgetExtension buttonDrawArea;
    private final TexturedButtonWidgetExtension buttonEdit;
    private final TexturedButtonWidgetExtension buttonUp;
    private final TexturedButtonWidgetExtension buttonDown;
    private final TexturedButtonWidgetExtension buttonAdd;
    private final TexturedButtonWidgetExtension buttonDelete;
    private final Supplier<String> getSearch;
    private final Consumer<String> setSearch;
    private ObjectArrayList<DashboardListItem> dataSorted = new ObjectArrayList();
    private final Int2ObjectAVLTreeMap<DashboardListItem> dataFiltered = new Int2ObjectAVLTreeMap();
    private int hoverIndex;
    private int page;
    private int totalPages;
    private boolean hasFind;
    private boolean hasDrawArea;
    private boolean hasEdit;
    private boolean hasSort;
    private boolean hasAdd;
    private boolean hasDelete;
    private static final int TOP_OFFSET = 24;

    public <T> DashboardList(@Nullable Callback onFind, @Nullable Callback onDrawArea, @Nullable Callback onEdit, @Nullable Runnable onSort, @Nullable Callback onAdd, @Nullable Callback onDelete, @Nullable Supplier<List<T>> getList, Supplier<String> getSearch, Consumer<String> setSearch) {
        this(onFind, onDrawArea, onEdit, onSort, onAdd, onDelete, getList, getSearch, setSearch, true);
    }

    public <T> DashboardList(@Nullable Callback onFind, @Nullable Callback onDrawArea, @Nullable Callback onEdit, @Nullable Runnable onSort, @Nullable Callback onAdd, @Nullable Callback onDelete, @Nullable Supplier<List<T>> getList, Supplier<String> getSearch, Consumer<String> setSearch, boolean playSound) {
        this.getSearch = getSearch;
        this.setSearch = setSearch;
        this.textFieldSearch = new TextFieldWidgetExtension(0, 0, 0, 20, 256, TextCase.DEFAULT, null, TranslationProvider.GUI_MTR_SEARCH.getString(new Object[0]));
        this.buttonPrevPage = TexturedButtonWidgetHelper.create(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_left.png"), new Identifier("textures/gui/sprites/mtr/icon_left_highlighted.png"), button -> this.setPage(this.page - 1));
        this.buttonNextPage = TexturedButtonWidgetHelper.create(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_right.png"), new Identifier("textures/gui/sprites/mtr/icon_right_highlighted.png"), button -> this.setPage(this.page + 1));
        this.buttonFind = new WidgetSilentImageButton(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_find.png"), new Identifier("textures/gui/sprites/mtr/icon_find_highlighted.png"), button -> this.onClick(onFind), playSound);
        this.buttonDrawArea = TexturedButtonWidgetHelper.create(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_draw_area.png"), new Identifier("textures/gui/sprites/mtr/icon_draw_area_highlighted.png"), button -> this.onClick(onDrawArea));
        this.buttonEdit = TexturedButtonWidgetHelper.create(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_edit.png"), new Identifier("textures/gui/sprites/mtr/icon_edit_highlighted.png"), button -> this.onClick(onEdit));
        this.buttonUp = TexturedButtonWidgetHelper.create(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_up.png"), new Identifier("textures/gui/sprites/mtr/icon_up_highlighted.png"), button -> {
            if (getList != null) {
                this.onUp(getList);
            }
            if (onSort != null) {
                onSort.run();
            }
        });
        this.buttonDown = TexturedButtonWidgetHelper.create(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_down.png"), new Identifier("textures/gui/sprites/mtr/icon_down_highlighted.png"), button -> {
            if (getList != null) {
                this.onDown(getList);
            }
            if (onSort != null) {
                onSort.run();
            }
        });
        this.buttonAdd = TexturedButtonWidgetHelper.create(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_add.png"), new Identifier("textures/gui/sprites/mtr/icon_add_highlighted.png"), button -> this.onClick(onAdd));
        this.buttonDelete = TexturedButtonWidgetHelper.create(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_delete.png"), new Identifier("textures/gui/sprites/mtr/icon_delete_highlighted.png"), button -> this.onClick(onDelete));
    }

    public void init(Consumer<ClickableWidget> addDrawableChild) {
        IDrawing.setPositionAndWidth(this.buttonPrevPage, this.x, this.y + 2, 20);
        IDrawing.setPositionAndWidth(this.buttonNextPage, this.x + 60, this.y + 2, 20);
        IDrawing.setPositionAndWidth(this.textFieldSearch, this.x + 80 + 2, this.y + 2, this.width - 80 - 4);
        this.textFieldSearch.setChangedListener2(this.setSearch);
        this.textFieldSearch.setText2(this.getSearch.get());
        this.buttonFind.field_22764 = false;
        this.buttonDrawArea.field_22764 = false;
        this.buttonEdit.field_22764 = false;
        this.buttonUp.field_22764 = false;
        this.buttonDown.field_22764 = false;
        this.buttonAdd.field_22764 = false;
        this.buttonDelete.field_22764 = false;
        addDrawableChild.accept(new ClickableWidget((class_339)this.buttonPrevPage));
        addDrawableChild.accept(new ClickableWidget((class_339)this.buttonNextPage));
        addDrawableChild.accept(new ClickableWidget((class_339)this.buttonFind));
        addDrawableChild.accept(new ClickableWidget((class_339)this.buttonDrawArea));
        addDrawableChild.accept(new ClickableWidget((class_339)this.buttonEdit));
        addDrawableChild.accept(new ClickableWidget((class_339)this.buttonUp));
        addDrawableChild.accept(new ClickableWidget((class_339)this.buttonDown));
        addDrawableChild.accept(new ClickableWidget((class_339)this.buttonAdd));
        addDrawableChild.accept(new ClickableWidget((class_339)this.buttonDelete));
        addDrawableChild.accept(new ClickableWidget((class_339)this.textFieldSearch));
    }

    public void tick() {
        this.textFieldSearch.tick2();
        this.buttonPrevPage.setX2(this.x);
        this.buttonNextPage.setX2(this.x + 60);
        this.textFieldSearch.setX2(this.x + 80 + 2);
        String text = this.textFieldSearch.getText2();
        this.dataFiltered.clear();
        for (int i = 0; i < this.dataSorted.size(); ++i) {
            if (!this.dataSorted.get(i).getName(true).toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))) continue;
            this.dataFiltered.put(i, this.dataSorted.get(i));
        }
        int dataSize = this.dataFiltered.size();
        this.totalPages = dataSize == 0 ? 1 : (int)Math.ceil((double)dataSize / (double)this.itemsToShow());
        this.setPage(this.page);
    }

    public void setData(ObjectSet<DashboardListItem> dataSet, boolean hasFind, boolean hasDrawArea, boolean hasEdit, boolean hasSort, boolean hasAdd, boolean hasDelete) {
        ObjectArrayList<DashboardListItem> dataList = new ObjectArrayList<DashboardListItem>((ObjectCollection<DashboardListItem>)dataSet);
        Collections.sort(dataList);
        this.setData(dataList, hasFind, hasDrawArea, hasEdit, hasSort, hasAdd, hasDelete);
    }

    public void setData(ObjectArrayList<DashboardListItem> dataList, boolean hasFind, boolean hasDrawArea, boolean hasEdit, boolean hasSort, boolean hasAdd, boolean hasDelete) {
        this.dataSorted = new ObjectArrayList<DashboardListItem>((ObjectList<DashboardListItem>)dataList);
        this.hasFind = hasFind;
        boolean hasPermission = MinecraftClientData.hasPermission();
        this.hasDrawArea = hasPermission && hasDrawArea;
        this.hasEdit = hasPermission && hasEdit;
        this.hasSort = hasPermission && hasSort;
        this.hasAdd = hasPermission && hasAdd;
        this.hasDelete = hasPermission && hasDelete;
    }

    public void render(GraphicsHolder graphicsHolder) {
        this.render(graphicsHolder, true);
    }

    public void render(GraphicsHolder graphicsHolder, boolean formatted) {
        graphicsHolder.drawCenteredText(String.format("%s/%s", this.page + 1, this.totalPages), this.x + 40, this.y + 6 + 2, -1);
        int itemsToShow = this.itemsToShow();
        for (int i = 0; i < itemsToShow; ++i) {
            if (i + itemsToShow * this.page >= this.dataFiltered.size()) continue;
            int drawY = 20 * i + 6 + 24;
            IntArrayList sortedKeys = new IntArrayList(this.dataFiltered.keySet());
            Collections.sort(sortedKeys);
            DashboardListItem data = this.dataFiltered.get(sortedKeys.getInt(i + itemsToShow * this.page));
            GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
            guiDrawing.beginDrawingRectangle();
            guiDrawing.drawRectangle(this.x + 6, this.y + drawY, this.x + 6 + 8, this.y + drawY + 8, 0xFF000000 | data.getColor(formatted));
            guiDrawing.finishDrawingRectangle();
            String drawString = IGui.formatStationName(data.getName(formatted));
            int textStart = 20;
            int textWidth = GraphicsHolder.getTextWidth(drawString);
            int availableSpace = this.width - 20;
            graphicsHolder.push();
            graphicsHolder.translate(this.x + 20, 0.0, 0.0);
            if (textWidth > availableSpace) {
                graphicsHolder.scale((float)availableSpace / (float)textWidth, 1.0f, 1.0f);
            }
            graphicsHolder.drawText(drawString, 0, this.y + drawY, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.pop();
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.buttonFind.field_22764 = false;
        this.buttonDrawArea.field_22764 = false;
        this.buttonEdit.field_22764 = false;
        this.buttonUp.field_22764 = false;
        this.buttonDown.field_22764 = false;
        this.buttonAdd.field_22764 = false;
        this.buttonDelete.field_22764 = false;
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)(this.y + 24) && mouseY < (double)(this.y + 24 + 20 * this.itemsToShow())) {
            boolean hasSortFiltered;
            this.hoverIndex = ((int)mouseY - this.y - 24) / 20;
            int dataSize = this.dataFiltered.size();
            int itemsToShow = this.itemsToShow();
            boolean bl = hasSortFiltered = this.hasSort && dataSize == this.dataSorted.size();
            if (this.hoverIndex >= 0 && this.hoverIndex + this.page * itemsToShow < dataSize) {
                this.buttonFind.field_22764 = this.hasFind;
                this.buttonDrawArea.field_22764 = this.hasDrawArea;
                this.buttonEdit.field_22764 = this.hasEdit;
                this.buttonUp.field_22764 = hasSortFiltered;
                this.buttonDown.field_22764 = hasSortFiltered;
                this.buttonAdd.field_22764 = this.hasAdd;
                this.buttonDelete.field_22764 = this.hasDelete;
                this.buttonUp.field_22763 = this.hoverIndex + itemsToShow * this.page > 0;
                this.buttonDown.field_22763 = this.hoverIndex + itemsToShow * this.page < dataSize - 1;
                int renderOffset = this.y + this.hoverIndex * 20 + 24;
                IDrawing.setPositionAndWidth(this.buttonFind, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0) + (hasSortFiltered ? 2 : 0) + (this.hasEdit ? 1 : 0) + (this.hasDrawArea ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth(this.buttonDrawArea, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0) + (hasSortFiltered ? 2 : 0) + (this.hasEdit ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth(this.buttonEdit, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0) + (hasSortFiltered ? 2 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth(this.buttonUp, this.x + this.width - 20 * (2 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth(this.buttonDown, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth(this.buttonAdd, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth(this.buttonDelete, this.x + this.width - 20, renderOffset, 20);
            }
        }
    }

    public void mouseScrolled(double mouseX, double mouseY, double amount) {
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height)) {
            this.setPage(this.page + (int)Math.signum(-amount));
        }
    }

    public void clearSearch() {
        this.textFieldSearch.setText2("");
    }

    public int getHoverItemIndex() {
        IntArrayList sortedKeys = new IntArrayList(this.dataFiltered.keySet());
        Collections.sort(sortedKeys);
        int sortedIndex = this.hoverIndex + this.itemsToShow() * this.page;
        if (sortedIndex >= 0 && sortedIndex < sortedKeys.size()) {
            return sortedKeys.getInt(sortedIndex);
        }
        return -1;
    }

    private void setPage(int newPage) {
        this.page = MathHelper.clamp(newPage, 0, this.totalPages - 1);
        this.buttonPrevPage.field_22764 = this.page > 0;
        this.buttonNextPage.field_22764 = this.page < this.totalPages - 1;
    }

    private void onClick(@Nullable Callback onClick) {
        int index = this.getHoverItemIndex();
        if (index >= 0 && index < this.dataSorted.size() && onClick != null) {
            onClick.accept(this.dataSorted.get(index), index);
        }
    }

    private <T> void onUp(Supplier<List<T>> getList) {
        if (this.textFieldSearch.getText2().isEmpty()) {
            int index = this.hoverIndex + this.itemsToShow() * this.page;
            List<T> list = getList.get();
            if (Screen.hasShiftDown()) {
                list.add(0, list.remove(index));
            } else {
                T aboveItem = list.get(index - 1);
                T thisItem = list.get(index);
                list.set(index - 1, thisItem);
                list.set(index, aboveItem);
            }
        }
    }

    private <T> void onDown(Supplier<List<T>> getList) {
        if (this.textFieldSearch.getText2().isEmpty()) {
            int index = this.hoverIndex + this.itemsToShow() * this.page;
            List<T> list = getList.get();
            if (Screen.hasShiftDown()) {
                list.add(list.remove(index));
            } else {
                T thisItem = list.get(index);
                T belowItem = list.get(index + 1);
                list.set(index, belowItem);
                list.set(index + 1, thisItem);
            }
        }
    }

    private int itemsToShow() {
        return (this.height - 24) / 20;
    }

    @FunctionalInterface
    public static interface Callback {
        public void accept(DashboardListItem var1, int var2);
    }
}

