/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.network.chat.Component;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PressAction;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.TexturedButtonWidgetAbstractMapping;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.TextHelper;

public class TexturedButtonWidgetExtension
extends TexturedButtonWidgetAbstractMapping {
    private final Identifier normalTexture;
    private final Identifier highlightedTexture;
    private final Identifier disabledTexture;

    @MappedMethod
    public TexturedButtonWidgetExtension(int x, int y, int width, int height, Identifier normalTexture, Identifier highlightedTexture, Identifier disabledTexture, PressAction onPress) {
        this(x, y, width, height, normalTexture, highlightedTexture, disabledTexture, onPress, "");
    }

    @MappedMethod
    public TexturedButtonWidgetExtension(int x, int y, int width, int height, Identifier normalTexture, Identifier highlightedTexture, Identifier disabledTexture, PressAction onPress, String message) {
        this(x, y, width, height, normalTexture, highlightedTexture, disabledTexture, onPress, TextHelper.literal(message));
    }

    @MappedMethod
    public TexturedButtonWidgetExtension(int x, int y, int width, int height, Identifier normalTexture, Identifier highlightedTexture, Identifier disabledTexture, PressAction onPress, MutableText message) {
        super(x, y, width, height, 0, 0, 0, normalTexture, 256, 256, onPress, new Text((Component)message.data));
        this.normalTexture = normalTexture;
        this.highlightedTexture = highlightedTexture;
        this.disabledTexture = disabledTexture;
    }

    @MappedMethod
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingTexture(this.getActiveMapped() ? (this.m_5702_() ? this.highlightedTexture : this.normalTexture) : this.disabledTexture);
        guiDrawing.drawTexture(this.f_93620_, this.f_93621_, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_, 0.0f, 0.0f, 1.0f, 1.0f);
        guiDrawing.finishDrawingTexture();
    }

    @Deprecated
    public final void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        GraphicsHolder.createInstanceSafe(matrices, null, graphicsHolder -> this.render((GraphicsHolder)graphicsHolder, mouseX, mouseY, delta));
    }

    @Deprecated
    public final boolean m_6050_(double mouseX, double mouseY, double amount) {
        return this.mouseScrolled2(mouseX, mouseY, amount);
    }

    @MappedMethod
    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @MappedMethod
    public final int getX2() {
        return this.f_93620_;
    }

    @MappedMethod
    public final int getY2() {
        return this.f_93621_;
    }

    @MappedMethod
    public final void setX2(int x) {
        this.f_93620_ = x;
    }

    @MappedMethod
    public final void setY2(int y) {
        this.f_93621_ = y;
    }

    @MappedMethod
    public final boolean m_5702_() {
        return super.m_5702_();
    }
}

