/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import com.mojang.blaze3d.platform.InputConstants;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlclient.registry.ClientRegistry;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BlockColorProvider;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockRenderView;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.EntityType;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.ItemColorProvider;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.KeyBinding;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.SpriteProvider;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.EntityExtension;
import org.mtr.mapping.mapper.EntityRenderer;
import org.mtr.mapping.mapper.ParticleFactoryExtension;
import org.mtr.mapping.registry.BlockEntityTypeRegistryObject;
import org.mtr.mapping.registry.BlockRegistryObject;
import org.mtr.mapping.registry.EntityTypeRegistryObject;
import org.mtr.mapping.registry.EventRegistryClient;
import org.mtr.mapping.registry.ItemRegistryObject;
import org.mtr.mapping.registry.MainEventBusClient;
import org.mtr.mapping.registry.ModEventBusClient;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.registry.ParticleTypeRegistryObject;
import org.mtr.mapping.registry.Registry;
import org.mtr.mapping.tool.DummyClass;
import org.mtr.mapping.tool.PacketBufferSender;

public final class RegistryClient
extends DummyClass {
    public static Function<World, ? extends EntityExtension> worldRenderingEntity;
    private final MainEventBusClient mainEventBusClient = new MainEventBusClient();
    private final ModEventBusClient modEventBusClient = new ModEventBusClient();
    public final EventRegistryClient eventRegistryClient = new EventRegistryClient(this.mainEventBusClient, this.modEventBusClient);
    private final Registry registry;

    @MappedMethod
    public RegistryClient(Registry registry) {
        this.registry = registry;
    }

    @MappedMethod
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this.mainEventBusClient);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.modEventBusClient);
    }

    @MappedMethod
    public <T extends BlockEntityTypeRegistryObject<U>, U extends BlockEntityExtension> void registerBlockEntityRenderer(T blockEntityType, Function<BlockEntityRenderer.Argument, org.mtr.mapping.mapper.BlockEntityRenderer<U>> rendererInstance) {
        this.modEventBusClient.blockEntityRenderers.add(event -> event.registerBlockEntityRenderer((BlockEntityType)((org.mtr.mapping.holder.BlockEntityType)blockEntityType.get()).data, context -> (BlockEntityRenderer)rendererInstance.apply(new BlockEntityRenderer.Argument(context))));
    }

    @MappedMethod
    public <T extends EntityTypeRegistryObject<U>, U extends EntityExtension> void registerEntityRenderer(T entityType, Function<EntityRenderer.Argument, EntityRenderer<U>> rendererInstance) {
        this.modEventBusClient.blockEntityRenderers.add(event -> event.registerEntityRenderer((net.minecraft.world.entity.EntityType)((EntityType)entityType.get()).data, dispatcher -> (net.minecraft.client.renderer.entity.EntityRenderer)rendererInstance.apply(new EntityRenderer.Argument(dispatcher))));
    }

    @MappedMethod
    public void registerParticleRenderer(ParticleTypeRegistryObject particleTypeRegistryObject, Function<SpriteProvider, ParticleFactoryExtension> factory2) {
        this.modEventBusClient.particleFactories.add((Tuple<ParticleTypeRegistryObject, Function<SpriteProvider, ParticleFactoryExtension>>)new Tuple((Object)particleTypeRegistryObject, spriteProvider -> (ParticleFactoryExtension)factory2.apply(new SpriteProvider((SpriteSet)spriteProvider.data))));
    }

    @MappedMethod
    public void registerBlockRenderType(RenderLayer renderLayer, BlockRegistryObject block) {
        this.modEventBusClient.clientObjectsToRegister.add(() -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get().data), (RenderType)((RenderType)renderLayer.data)));
    }

    @MappedMethod
    public KeyBinding registerKeyBinding(String translationKey, int key, String categoryKey) {
        KeyMapping keyBinding = new KeyMapping(translationKey, InputConstants.Type.KEYSYM, key, categoryKey);
        this.modEventBusClient.clientObjectsToRegister.add(() -> ClientRegistry.registerKeyBinding((KeyMapping)keyBinding));
        return new KeyBinding(keyBinding);
    }

    @MappedMethod
    public void registerBlockColors(BlockColorProvider blockColorProvider, BlockRegistryObject ... blocks) {
        this.modEventBusClient.blockColors.add(event -> {
            Block[] newBlocks = new Block[blocks.length];
            for (int i = 0; i < blocks.length; ++i) {
                newBlocks[i] = (Block)blocks[i].get().data;
            }
            event.getBlockColors().m_92589_((blockState, blockRenderView, blockPos, tintIndex) -> blockColorProvider.getColor2(new BlockState(blockState), blockRenderView == null ? null : new BlockRenderView(blockRenderView), blockPos == null ? null : new BlockPos(blockPos), tintIndex), newBlocks);
        });
    }

    @MappedMethod
    public void registerItemColors(ItemColorProvider itemColorProvider, ItemRegistryObject ... items) {
        this.modEventBusClient.itemColors.add(event -> {
            Item[] newItems = new Item[items.length];
            for (int i = 0; i < items.length; ++i) {
                newItems[i] = (Item)items[i].get().data;
            }
            event.getItemColors().m_92689_((itemStack, tintIndex) -> itemColorProvider.getColor2(new ItemStack(itemStack), tintIndex), (ItemLike[])newItems);
        });
    }

    @MappedMethod
    public void registerItemModelPredicate(ItemRegistryObject item, Identifier identifier, ModelPredicateProvider modelPredicateProvider) {
        this.modEventBusClient.clientObjectsToRegisterQueued.add(() -> ItemProperties.register((Item)((Item)item.get().data), (ResourceLocation)((ResourceLocation)identifier.data), (itemStack, clientWorld, livingEntity, seed) -> modelPredicateProvider.call(new ItemStack(itemStack), clientWorld == null ? null : new ClientWorld(clientWorld), livingEntity == null ? null : new LivingEntity(livingEntity))));
    }

    @MappedMethod
    public void setupPackets(Identifier identifier) {
    }

    @MappedMethod
    public <T extends PacketHandler> void sendPacketToServer(T data) {
        if (this.registry.simpleChannel != null) {
            PacketBufferSender packetBufferSender = new PacketBufferSender(Unpooled::buffer);
            packetBufferSender.writeString(data.getClass().getName());
            data.write(packetBufferSender);
            packetBufferSender.send(byteBuf -> this.registry.simpleChannel.sendToServer((Object)new Registry.PacketObject((ByteBuf)byteBuf)), MinecraftClient.getInstance()::execute);
        }
    }

    @FunctionalInterface
    public static interface ModelPredicateProvider {
        @MappedMethod
        public float call(ItemStack var1, @Nullable ClientWorld var2, @Nullable LivingEntity var3);
    }
}

