/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.data;

import javax.annotation.Nonnull;
import org.mtr.core.data.Position;
import org.mtr.core.data.TwoPositionsBase;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;

public abstract class SignalModificationSchema
extends TwoPositionsBase {
    protected final Position position1;
    protected final Position position2;
    protected final LongArrayList signalColorsAdd = new LongArrayList();
    protected final LongArrayList signalColorsRemove = new LongArrayList();
    protected final boolean clearAll;

    protected SignalModificationSchema(Position position1, Position position2, boolean clearAll) {
        this.position1 = position1;
        this.position2 = position2;
        this.clearAll = clearAll;
    }

    protected SignalModificationSchema(ReaderBase readerBase) {
        this.position1 = new Position(readerBase.getChild("position1"));
        this.position2 = new Position(readerBase.getChild("position2"));
        this.clearAll = readerBase.getBoolean("clearAll", false);
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateLongArray("signalColorsAdd", this.signalColorsAdd::clear, this.signalColorsAdd::add);
        readerBase.iterateLongArray("signalColorsRemove", this.signalColorsRemove::clear, this.signalColorsRemove::add);
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        if (this.position1 != null) {
            this.position1.serializeData(writerBase.writeChild("position1"));
        }
        if (this.position2 != null) {
            this.position2.serializeData(writerBase.writeChild("position2"));
        }
        this.serializeSignalColorsAdd(writerBase);
        this.serializeSignalColorsRemove(writerBase);
        writerBase.writeBoolean("clearAll", this.clearAll);
    }

    @Nonnull
    public String toString() {
        return "position1: " + this.position1 + "\nposition2: " + this.position2 + "\nsignalColorsAdd: " + this.signalColorsAdd + "\nsignalColorsRemove: " + this.signalColorsRemove + "\nclearAll: " + this.clearAll + "\n";
    }

    protected void serializeSignalColorsAdd(WriterBase writerBase) {
        WriterBase.Array signalColorsAddWriterBaseArray = writerBase.writeArray("signalColorsAdd");
        this.signalColorsAdd.forEach(signalColorsAddWriterBaseArray::writeLong);
    }

    protected void serializeSignalColorsRemove(WriterBase writerBase) {
        WriterBase.Array signalColorsRemoveWriterBaseArray = writerBase.writeArray("signalColorsRemove");
        this.signalColorsRemove.forEach(signalColorsRemoveWriterBaseArray::writeLong);
    }
}

