/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.operation;

import javax.annotation.Nonnull;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class ArrivalsRequestSchema
implements SerializedDataBase {
    protected final LongArrayList platformIds = new LongArrayList();
    protected final ObjectArrayList<String> platformIdsHex = new ObjectArrayList();
    protected final LongArrayList stationIds = new LongArrayList();
    protected final ObjectArrayList<String> stationIdsHex = new ObjectArrayList();
    protected final long maxCountPerPlatform;
    protected final long maxCountTotal;

    protected ArrivalsRequestSchema(long maxCountPerPlatform, long maxCountTotal) {
        this.maxCountPerPlatform = maxCountPerPlatform;
        this.maxCountTotal = maxCountTotal;
    }

    protected ArrivalsRequestSchema(ReaderBase readerBase) {
        this.maxCountPerPlatform = readerBase.getLong("maxCountPerPlatform", 0L);
        this.maxCountTotal = readerBase.getLong("maxCountTotal", 0L);
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateLongArray("platformIds", this.platformIds::clear, this.platformIds::add);
        readerBase.iterateStringArray("platformIdsHex", this.platformIdsHex::clear, this.platformIdsHex::add);
        readerBase.iterateLongArray("stationIds", this.stationIds::clear, this.stationIds::add);
        readerBase.iterateStringArray("stationIdsHex", this.stationIdsHex::clear, this.stationIdsHex::add);
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        this.serializePlatformIds(writerBase);
        this.serializePlatformIdsHex(writerBase);
        this.serializeStationIds(writerBase);
        this.serializeStationIdsHex(writerBase);
        writerBase.writeLong("maxCountPerPlatform", this.maxCountPerPlatform);
        writerBase.writeLong("maxCountTotal", this.maxCountTotal);
    }

    @Nonnull
    public String toString() {
        return "platformIds: " + this.platformIds + "\nplatformIdsHex: " + this.platformIdsHex + "\nstationIds: " + this.stationIds + "\nstationIdsHex: " + this.stationIdsHex + "\nmaxCountPerPlatform: " + this.maxCountPerPlatform + "\nmaxCountTotal: " + this.maxCountTotal + "\n";
    }

    protected void serializePlatformIds(WriterBase writerBase) {
        WriterBase.Array platformIdsWriterBaseArray = writerBase.writeArray("platformIds");
        this.platformIds.forEach(platformIdsWriterBaseArray::writeLong);
    }

    protected void serializePlatformIdsHex(WriterBase writerBase) {
        WriterBase.Array platformIdsHexWriterBaseArray = writerBase.writeArray("platformIdsHex");
        this.platformIdsHex.forEach(platformIdsHexWriterBaseArray::writeString);
    }

    protected void serializeStationIds(WriterBase writerBase) {
        WriterBase.Array stationIdsWriterBaseArray = writerBase.writeArray("stationIds");
        this.stationIds.forEach(stationIdsWriterBaseArray::writeLong);
    }

    protected void serializeStationIdsHex(WriterBase writerBase) {
        WriterBase.Array stationIdsHexWriterBaseArray = writerBase.writeArray("stationIdsHex");
        this.stationIdsHex.forEach(stationIdsHexWriterBaseArray::writeString);
    }
}

