/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.level.block.Rotation;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Random;

@ParametersAreNonnullByDefault
public enum BlockRotation {
    NONE(Rotation.NONE),
    CLOCKWISE_90(Rotation.CLOCKWISE_90),
    CLOCKWISE_180(Rotation.CLOCKWISE_180),
    COUNTERCLOCKWISE_90(Rotation.COUNTERCLOCKWISE_90);

    public final Rotation data;

    private BlockRotation(Rotation data) {
        this.data = data;
    }

    public static BlockRotation convert(@Nullable Rotation data) {
        return data == null ? null : BlockRotation.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable BlockRotation data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static BlockRotation random(Random arg0) {
        return BlockRotation.convert(Rotation.m_55956_((java.util.Random)((java.util.Random)arg0.data)));
    }

    @Nonnull
    @MappedMethod
    public Direction rotate(Direction arg0) {
        return Direction.convert(this.data.m_55954_(arg0.data));
    }

    @MappedMethod
    public int rotate(int arg0, int arg1) {
        return this.data.m_55949_(arg0, arg1);
    }

    @Nonnull
    @MappedMethod
    public BlockRotation rotate(BlockRotation arg0) {
        return BlockRotation.convert(this.data.m_55952_(arg0.data));
    }

    @Nonnull
    @MappedMethod
    public static BlockRotation getCounterclockwise90Mapped() {
        return BlockRotation.convert(Rotation.COUNTERCLOCKWISE_90);
    }

    @Nonnull
    @MappedMethod
    public static BlockRotation getClockwise90Mapped() {
        return BlockRotation.convert(Rotation.CLOCKWISE_90);
    }

    @Nonnull
    @MappedMethod
    public static BlockRotation getClockwise180Mapped() {
        return BlockRotation.convert(Rotation.CLOCKWISE_180);
    }

    @Nonnull
    @MappedMethod
    public static BlockRotation getNoneMapped() {
        return BlockRotation.convert(Rotation.NONE);
    }
}

