/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import com.mojang.bridge.game.PackType;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.DetectedVersion;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.tool.DummyClass;

public final class ResourceManagerHelper
extends DummyClass {
    @MappedMethod
    public static void readResource(Identifier identifier, Consumer<InputStream> consumer) {
        try {
            ResourceManagerHelper.readResource(Minecraft.m_91087_().m_91098_().m_142591_((ResourceLocation)identifier.data), consumer);
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static String readResource(Identifier identifier) {
        String[] string = new String[]{""};
        ResourceManagerHelper.readResource(identifier, (InputStream inputStream2) -> {
            try {
                string[0] = IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                ResourceManagerHelper.logException(e);
            }
        });
        return string[0];
    }

    @MappedMethod
    public static void readAllResources(Identifier identifier, Consumer<InputStream> consumer) {
        try {
            Minecraft.m_91087_().m_91098_().m_7396_((ResourceLocation)identifier.data).forEach(resource -> ResourceManagerHelper.readResource(resource, consumer));
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static void readDirectory(String path, BiConsumer<Identifier, InputStream> consumer) {
        try {
            Minecraft.m_91087_().m_91098_().m_6540_(path, identifier -> true).forEach(identifier -> ResourceManagerHelper.readAllResources(new Identifier((ResourceLocation)identifier), inputStream2 -> consumer.accept(new Identifier((ResourceLocation)identifier), (InputStream)inputStream2)));
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    private static void readResource(Resource resource, Consumer<InputStream> consumer) {
        try (Resource newResource = resource;){
            try (InputStream inputStream2 = newResource.m_6679_();){
                consumer.accept(inputStream2);
            }
            catch (Exception e) {
                ResourceManagerHelper.logException(e);
            }
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static int getResourcePackVersion() {
        return DetectedVersion.m_195834_().getPackVersion(PackType.RESOURCE);
    }

    @MappedMethod
    public static int getDataPackVersion() {
        return DetectedVersion.m_195834_().getPackVersion(PackType.DATA);
    }
}

