/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;

public abstract class PacketRequestResponseBase
extends PacketHandler {
    private final String content;

    public PacketRequestResponseBase(PacketBufferReceiver packetBufferReceiver) {
        this.content = packetBufferReceiver.readString();
    }

    public PacketRequestResponseBase(String content) {
        this.content = content;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeString(this.content);
    }

    @Override
    public final void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        this.runServerOutbound(serverPlayerEntity.getServerWorld(), serverPlayerEntity);
    }

    @Override
    public final void runClient() {
        this.runClientInbound(new JsonReader(Utilities.parseJson(this.content)));
    }

    protected void runServerOutbound(ServerWorld serverWorld, @Nullable ServerPlayerEntity serverPlayerEntity) {
        Init.sendMessageC2S(this.getKey(), serverWorld.getServer(), new World((Level)serverWorld.data), this.getDataInstance(new JsonReader(Utilities.parseJson(this.content))), this.responseType() == ResponseType.NONE ? null : responseData -> {
            JsonObject responseJson = Utilities.getJsonObjectFromData(responseData);
            if (this.responseType() == ResponseType.PLAYER) {
                if (serverPlayerEntity != null) {
                    Init.REGISTRY.sendPacketToClient(serverPlayerEntity, this.getInstance(responseJson.toString()));
                }
            } else {
                MinecraftServerHelper.iteratePlayers(serverWorld, serverPlayerEntityNew -> Init.REGISTRY.sendPacketToClient((ServerPlayerEntity)serverPlayerEntityNew, this.getInstance(responseJson.toString())));
            }
            this.runServerInbound(serverWorld, responseJson);
        }, SerializedDataBase.class);
    }

    protected void runServerInbound(ServerWorld serverWorld, JsonObject jsonObject) {
    }

    protected void runClientInbound(JsonReader jsonReader) {
    }

    protected abstract PacketRequestResponseBase getInstance(String var1);

    protected abstract SerializedDataBase getDataInstance(JsonReader var1);

    @Nonnull
    protected abstract String getKey();

    protected abstract ResponseType responseType();

    protected static enum ResponseType {
        NONE,
        PLAYER,
        ALL;

    }
}

