/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.servlet;

import org.mtr.core.Main;
import org.mtr.libraries.org.eclipse.jetty.server.Connector;
import org.mtr.libraries.org.eclipse.jetty.server.Server;
import org.mtr.libraries.org.eclipse.jetty.server.ServerConnector;
import org.mtr.libraries.org.eclipse.jetty.servlet.ServletContextHandler;
import org.mtr.libraries.org.eclipse.jetty.servlet.ServletHolder;
import org.mtr.libraries.org.eclipse.jetty.util.thread.QueuedThreadPool;

public final class Webserver {
    private final Server server = new Server(new QueuedThreadPool(100, 10, 120));
    private final ServerConnector serverConnector = new ServerConnector(this.server);
    private final ServletContextHandler servletContextHandler;

    public Webserver(int port) {
        this.server.setConnectors(new Connector[]{this.serverConnector});
        this.servletContextHandler = new ServletContextHandler();
        this.server.setHandler(this.servletContextHandler);
        this.serverConnector.setPort(port);
    }

    public void addServlet(ServletHolder servletHolder, String path) {
        this.servletContextHandler.addServlet(servletHolder, path);
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            Main.LOGGER.error("", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            Main.LOGGER.error("", (Throwable)e);
        }
        try {
            this.serverConnector.stop();
        }
        catch (Exception e) {
            Main.LOGGER.error("", (Throwable)e);
        }
    }
}

