/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Pose;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum EntityPose {
    STANDING(Pose.STANDING),
    FALL_FLYING(Pose.FALL_FLYING),
    SLEEPING(Pose.SLEEPING),
    SWIMMING(Pose.SWIMMING),
    SPIN_ATTACK(Pose.SPIN_ATTACK),
    CROUCHING(Pose.CROUCHING),
    LONG_JUMPING(Pose.LONG_JUMPING),
    DYING(Pose.DYING),
    CROAKING(Pose.CROAKING),
    USING_TONGUE(Pose.USING_TONGUE),
    SITTING(Pose.SITTING),
    ROARING(Pose.ROARING),
    SNIFFING(Pose.SNIFFING),
    EMERGING(Pose.EMERGING),
    DIGGING(Pose.DIGGING),
    SLIDING(Pose.SLIDING),
    SHOOTING(Pose.SHOOTING),
    INHALING(Pose.INHALING);

    public final Pose data;

    private EntityPose(Pose data) {
        this.data = data;
    }

    public static EntityPose convert(@Nullable Pose data) {
        return data == null ? null : EntityPose.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable EntityPose data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static EntityPose getCrouchingMapped() {
        return EntityPose.convert(Pose.CROUCHING);
    }

    @Nonnull
    @MappedMethod
    public static EntityPose getSpinAttackMapped() {
        return EntityPose.convert(Pose.SPIN_ATTACK);
    }

    @Nonnull
    @MappedMethod
    public static EntityPose getSleepingMapped() {
        return EntityPose.convert(Pose.SLEEPING);
    }

    @Nonnull
    @MappedMethod
    public static EntityPose getFallFlyingMapped() {
        return EntityPose.convert(Pose.FALL_FLYING);
    }

    @Nonnull
    @MappedMethod
    public static EntityPose getDyingMapped() {
        return EntityPose.convert(Pose.DYING);
    }

    @Nonnull
    @MappedMethod
    public static EntityPose getStandingMapped() {
        return EntityPose.convert(Pose.STANDING);
    }

    @Nonnull
    @MappedMethod
    public static EntityPose getSwimmingMapped() {
        return EntityPose.convert(Pose.SWIMMING);
    }
}

