/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import it.unimi.dsi.fastutil.shorts.ShortList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelChunkTicks;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ChunkPos;
import org.mtr.mapping.holder.ChunkStatus;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.FluidState;
import org.mtr.mapping.holder.HeightMap;
import org.mtr.mapping.holder.HeightMapType;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class WorldChunk
extends HolderBase<LevelChunk> {
    public WorldChunk(LevelChunk data) {
        super(data);
    }

    @MappedMethod
    public static WorldChunk cast(HolderBase<?> data) {
        return new WorldChunk((LevelChunk)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof LevelChunk;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((LevelChunk)this.data).equals(((HolderBase)data).data);
    }

    @Nullable
    @MappedMethod
    public BlockHitResult raycastBlock(Vector3d arg0, Vector3d arg1, BlockPos arg2, VoxelShape arg3, BlockState arg4) {
        net.minecraft.world.phys.BlockHitResult tempData = ((LevelChunk)this.data).m_45558_((Vec3)arg0.data, (Vec3)arg1.data, (net.minecraft.core.BlockPos)arg2.data, (net.minecraft.world.phys.shapes.VoxelShape)arg3.data, (net.minecraft.world.level.block.state.BlockState)arg4.data);
        return tempData == null ? null : new BlockHitResult(tempData);
    }

    @MappedMethod
    public double getDismountHeight(BlockPos arg0) {
        return ((LevelChunk)this.data).m_45573_((net.minecraft.core.BlockPos)arg0.data);
    }

    @Nullable
    @MappedMethod
    public BlockState setBlockState(BlockPos arg0, BlockState arg1, boolean arg2) {
        net.minecraft.world.level.block.state.BlockState tempData = ((LevelChunk)this.data).m_6978_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.state.BlockState)arg1.data, arg2);
        return tempData == null ? null : new BlockState(tempData);
    }

    @MappedMethod
    public long getInhabitedTime() {
        return ((LevelChunk)this.data).m_6319_();
    }

    @Nonnull
    @MappedMethod
    public ChunkPos getPos() {
        return new ChunkPos(((LevelChunk)this.data).m_7697_());
    }

    @Deprecated
    public WorldChunk(ServerWorld arg0, ProtoChunk arg1, @Nullable LevelChunk.PostLoadProcessor arg2) {
        super(new LevelChunk((ServerLevel)arg0.data, arg1, arg2));
    }

    @Deprecated
    public WorldChunk(World arg0, ChunkPos arg1, UpgradeData arg2, LevelChunkTicks<Block> arg3, LevelChunkTicks<Fluid> arg4, long arg5, @Nullable LevelChunkSection[] arg6, @Nullable LevelChunk.PostLoadProcessor arg7, @Nullable BlendingData arg8) {
        super(new LevelChunk((Level)arg0.data, (net.minecraft.world.level.ChunkPos)arg1.data, arg2, arg3, arg4, arg5, arg6, arg7, arg8));
    }

    @Deprecated
    public WorldChunk(World arg0, ChunkPos arg1) {
        super(new LevelChunk((Level)arg0.data, (net.minecraft.world.level.ChunkPos)arg1.data));
    }

    @Nonnull
    @MappedMethod
    public ChunkStatus getStatus() {
        return new ChunkStatus(((LevelChunk)this.data).m_6415_());
    }

    @MappedMethod
    public int getLuminance(BlockPos arg0) {
        return ((LevelChunk)this.data).m_7146_((net.minecraft.core.BlockPos)arg0.data);
    }

    @Nullable
    @MappedMethod
    public CompoundTag getPackedBlockEntityNbt(BlockPos arg0) {
        net.minecraft.nbt.CompoundTag tempData = ((LevelChunk)this.data).m_8051_((net.minecraft.core.BlockPos)arg0.data);
        return tempData == null ? null : new CompoundTag(tempData);
    }

    @MappedMethod
    public void markBlockForPostProcessing(short arg0, int arg1) {
        ((LevelChunk)this.data).m_6561_(arg0, arg1);
    }

    @MappedMethod
    public void addEntity(Entity arg0) {
        ((LevelChunk)this.data).m_6286_((net.minecraft.world.entity.Entity)arg0.data);
    }

    @Nullable
    @MappedMethod
    public BlockEntity getBlockEntity(BlockPos arg0) {
        net.minecraft.world.level.block.entity.BlockEntity tempData = ((LevelChunk)this.data).m_7702_((net.minecraft.core.BlockPos)arg0.data);
        return tempData == null ? null : new BlockEntity(tempData);
    }

    @MappedMethod
    public boolean areSectionsEmptyBetween(int arg0, int arg1) {
        return ((LevelChunk)this.data).m_5566_(arg0, arg1);
    }

    @Nonnull
    @MappedMethod
    public HeightMap getHeightmap(HeightMapType arg0) {
        return new HeightMap(((LevelChunk)this.data).m_6005_(arg0.data));
    }

    @MappedMethod
    public boolean isEmpty() {
        return ((LevelChunk)this.data).m_6430_();
    }

    @MappedMethod
    public int getMaxLightLevel() {
        return ((LevelChunk)this.data).m_7469_();
    }

    @Nonnull
    @MappedMethod
    public FluidState getFluidState(int arg0, int arg1, int arg2) {
        return new FluidState(((LevelChunk)this.data).m_62814_(arg0, arg1, arg2));
    }

    @Nonnull
    @MappedMethod
    public FluidState getFluidState(BlockPos arg0) {
        return new FluidState(((LevelChunk)this.data).m_6425_((net.minecraft.core.BlockPos)arg0.data));
    }

    @MappedMethod
    public void setHeightmap(HeightMapType arg0, long[] arg1) {
        ((LevelChunk)this.data).m_6511_(arg0.data, arg1);
    }

    @Nonnull
    @MappedMethod
    public ShortList[] getPostProcessingLists() {
        return ((LevelChunk)this.data).m_6720_();
    }

    @MappedMethod
    public void setInhabitedTime(long arg0) {
        ((LevelChunk)this.data).m_6141_(arg0);
    }

    @MappedMethod
    public void addPendingBlockEntityNbt(CompoundTag arg0) {
        ((LevelChunk)this.data).m_5604_((net.minecraft.nbt.CompoundTag)arg0.data);
    }

    @Nullable
    @MappedMethod
    public CompoundTag getBlockEntityNbt(BlockPos arg0) {
        net.minecraft.nbt.CompoundTag tempData = ((LevelChunk)this.data).m_8049_((net.minecraft.core.BlockPos)arg0.data);
        return tempData == null ? null : new CompoundTag(tempData);
    }

    @MappedMethod
    public void removeBlockEntity(BlockPos arg0) {
        ((LevelChunk)this.data).m_8114_((net.minecraft.core.BlockPos)arg0.data);
    }

    @MappedMethod
    public void markBlockForPostProcessing(BlockPos arg0) {
        ((LevelChunk)this.data).m_8113_((net.minecraft.core.BlockPos)arg0.data);
    }

    @Nonnull
    @MappedMethod
    public BlockState getBlockState(BlockPos arg0) {
        return new BlockState(((LevelChunk)this.data).m_8055_((net.minecraft.core.BlockPos)arg0.data));
    }

    @MappedMethod
    public int sampleHeightmap(HeightMapType arg0, int arg1, int arg2) {
        return ((LevelChunk)this.data).m_5885_(arg0.data, arg1, arg2);
    }
}

