/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.DummyClass;

public final class CommandBuilder<T extends ArgumentBuilder<CommandSourceStack, T>>
extends DummyClass {
    T argumentBuilder;

    CommandBuilder(T argumentBuilder) {
        this.argumentBuilder = argumentBuilder;
    }

    @MappedMethod
    public void permissionLevel(int permissionLevel) {
        this.argumentBuilder = this.argumentBuilder.requires(serverCommandSource -> serverCommandSource.m_6761_(permissionLevel));
    }

    @MappedMethod
    public <U> void then(String argumentName, ArgumentType<U> argumentType, Consumer<CommandBuilder<?>> consumer) {
        CommandBuilder<RequiredArgumentBuilder> commandBuilder = new CommandBuilder<RequiredArgumentBuilder>(Commands.m_82129_((String)argumentName, argumentType));
        consumer.accept(commandBuilder);
        this.argumentBuilder = this.argumentBuilder.then(commandBuilder.argumentBuilder);
    }

    @MappedMethod
    public void then(String commandName, Consumer<CommandBuilder<?>> consumer) {
        CommandBuilder<LiteralArgumentBuilder> commandBuilder = new CommandBuilder<LiteralArgumentBuilder>(Commands.m_82127_((String)commandName));
        consumer.accept(commandBuilder);
        this.argumentBuilder = this.argumentBuilder.then(commandBuilder.argumentBuilder);
    }

    @MappedMethod
    public void executes(ToIntFunction<ContextHandler> execute2) {
        this.argumentBuilder = this.argumentBuilder.executes(context -> execute2.applyAsInt(new ContextHandler((CommandContext<CommandSourceStack>)context)));
    }

    public static class ContextHandler {
        private final CommandContext<CommandSourceStack> context;

        private ContextHandler(CommandContext<CommandSourceStack> context) {
            this.context = context;
        }

        @MappedMethod
        public boolean getBoolean(String argumentName) {
            return BoolArgumentType.getBool(this.context, (String)argumentName);
        }

        @MappedMethod
        public double getDouble(String argumentName) {
            return DoubleArgumentType.getDouble(this.context, (String)argumentName);
        }

        @MappedMethod
        public float getFloat(String argumentName) {
            return FloatArgumentType.getFloat(this.context, (String)argumentName);
        }

        @MappedMethod
        public int getInteger(String argumentName) {
            return IntegerArgumentType.getInteger(this.context, (String)argumentName);
        }

        @MappedMethod
        public long getLong(String argumentName) {
            return LongArgumentType.getLong(this.context, (String)argumentName);
        }

        @MappedMethod
        public String getString(String argumentName) {
            return StringArgumentType.getString(this.context, (String)argumentName);
        }

        @MappedMethod
        public void sendSuccess(String message, boolean broadcastToOps, Object ... translatableArguments) {
            ((CommandSourceStack)this.context.getSource()).m_288197_(() -> Component.m_237110_((String)message, (Object[])translatableArguments), broadcastToOps);
        }

        @MappedMethod
        public void sendFailure(String message, Object ... translatableArguments) {
            ((CommandSourceStack)this.context.getSource()).m_81352_((Component)Component.m_237110_((String)message, (Object[])translatableArguments));
        }

        @MappedMethod
        public MinecraftServer getServer() {
            return new MinecraftServer(((CommandSourceStack)this.context.getSource()).m_81377_());
        }

        @MappedMethod
        public World getWorld() {
            return new World((Level)((CommandSourceStack)this.context.getSource()).m_81372_());
        }

        @MappedMethod
        @Nullable
        public ServerPlayerEntity getServerPlayer() {
            ServerPlayer serverPlayerEntity = ((CommandSourceStack)this.context.getSource()).m_230896_();
            return serverPlayerEntity == null ? null : new ServerPlayerEntity(serverPlayerEntity);
        }
    }
}

