/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.commands.Commands;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.EntityType;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockItemExtension;
import org.mtr.mapping.mapper.EntityExtension;
import org.mtr.mapping.registry.BlockEntityTypeRegistryObject;
import org.mtr.mapping.registry.BlockRegistryObject;
import org.mtr.mapping.registry.CommandBuilder;
import org.mtr.mapping.registry.CreativeModeTabHolder;
import org.mtr.mapping.registry.EntityTypeRegistryObject;
import org.mtr.mapping.registry.EventRegistry;
import org.mtr.mapping.registry.ItemRegistryObject;
import org.mtr.mapping.registry.MainEventBus;
import org.mtr.mapping.registry.ModEventBus;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.registry.ParticleTypeRegistryObject;
import org.mtr.mapping.registry.SoundEventRegistryObject;
import org.mtr.mapping.tool.DummyClass;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public final class Registry
extends DummyClass {
    SimpleChannel simpleChannel;
    private final MainEventBus mainEventBus = new MainEventBus();
    private final ModEventBus modEventBus = new ModEventBus();
    final Map<String, Function<PacketBufferReceiver, ? extends PacketHandler>> packets = new HashMap<String, Function<PacketBufferReceiver, ? extends PacketHandler>>();
    public final EventRegistry eventRegistry = new EventRegistry(this.mainEventBus);
    private static final int PROTOCOL_VERSION = 1;

    @MappedMethod
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this.mainEventBus);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.modEventBus);
    }

    @MappedMethod
    public BlockRegistryObject registerBlock(Identifier identifier, Supplier<org.mtr.mapping.holder.Block> supplier) {
        this.modEventBus.BLOCKS.put(identifier, supplier);
        return new BlockRegistryObject(identifier);
    }

    @MappedMethod
    public BlockRegistryObject registerBlockWithBlockItem(Identifier identifier, Supplier<org.mtr.mapping.holder.Block> supplier, CreativeModeTabHolder ... creativeModeTabHolders) {
        return this.registerBlockWithBlockItem(identifier, supplier, BlockItemExtension::new, creativeModeTabHolders);
    }

    @MappedMethod
    public BlockRegistryObject registerBlockWithBlockItem(Identifier identifier, Supplier<org.mtr.mapping.holder.Block> supplier, BiFunction<org.mtr.mapping.holder.Block, ItemSettings, BlockItemExtension> function, CreativeModeTabHolder ... creativeModeTabHolders) {
        this.modEventBus.BLOCKS.put(identifier, supplier);
        BlockRegistryObject blockRegistryObject = new BlockRegistryObject(identifier);
        this.modEventBus.BLOCK_ITEMS.put(identifier, () -> (BlockItemExtension)((Object)((Object)function.apply(blockRegistryObject.get(), new ItemSettings()))));
        for (CreativeModeTabHolder creativeModeTabHolder : creativeModeTabHolders) {
            creativeModeTabHolder.itemSuppliers.add(new ItemRegistryObject(identifier)::get);
        }
        return blockRegistryObject;
    }

    @MappedMethod
    public ItemRegistryObject registerItem(Identifier identifier, Function<ItemSettings, Item> function, CreativeModeTabHolder ... creativeModeTabHolders) {
        this.modEventBus.ITEMS.put(identifier, () -> (Item)function.apply(new ItemSettings()));
        ItemRegistryObject itemRegistryObject = new ItemRegistryObject(identifier);
        for (CreativeModeTabHolder creativeModeTabHolder : creativeModeTabHolders) {
            creativeModeTabHolder.itemSuppliers.add(itemRegistryObject::get);
        }
        return itemRegistryObject;
    }

    @MappedMethod
    public <T extends BlockEntityExtension> BlockEntityTypeRegistryObject<T> registerBlockEntityType(Identifier identifier, BiFunction<BlockPos, BlockState, T> function, Supplier<org.mtr.mapping.holder.Block> ... blockSuppliers) {
        this.modEventBus.blockEntityTypes.put(identifier, () -> BlockEntityType.Builder.m_155273_((pos, state) -> (BlockEntityExtension)((Object)((Object)((Object)function.apply(new BlockPos(pos), new BlockState(state))))), (Block[])((Block[])HolderBase.convertArray(blockSuppliers, Block[]::new))).m_58966_(null));
        return new BlockEntityTypeRegistryObject(identifier);
    }

    @MappedMethod
    public <T extends EntityExtension> EntityTypeRegistryObject<T> registerEntityType(Identifier identifier, BiFunction<EntityType<?>, World, T> function, float width, float height) {
        this.modEventBus.entityTypes.put(identifier, () -> EntityType.Builder.m_20704_(this.getEntityFactory(function), (MobCategory)MobCategory.MISC).m_20699_(width, height).m_20712_(identifier.toString()));
        return new EntityTypeRegistryObject(identifier);
    }

    private <T extends EntityExtension> EntityType.EntityFactory<T> getEntityFactory(BiFunction<EntityType<?>, World, T> function) {
        return (entityType, world) -> (EntityExtension)((Object)((Object)function.apply(new EntityType(entityType), new World(world))));
    }

    @MappedMethod
    public ParticleTypeRegistryObject registerParticleType(Identifier identifier) {
        return this.registerParticleType(identifier, false);
    }

    @MappedMethod
    public ParticleTypeRegistryObject registerParticleType(Identifier identifier, boolean alwaysSpawn) {
        this.modEventBus.particleTypes.put(identifier, () -> new SimpleParticleType(alwaysSpawn));
        return new ParticleTypeRegistryObject(identifier);
    }

    @MappedMethod
    public CreativeModeTabHolder createCreativeModeTabHolder(Identifier identifier, Supplier<ItemStack> iconSupplier) {
        CreativeModeTabHolder creativeModeTabHolder = new CreativeModeTabHolder((ResourceLocation)identifier.data, iconSupplier);
        this.modEventBus.creativeModeTabs.add(creativeModeTabHolder);
        return creativeModeTabHolder;
    }

    @MappedMethod
    public SoundEventRegistryObject registerSoundEvent(Identifier identifier) {
        this.modEventBus.soundEvents.put(identifier, () -> new SoundEvent(net.minecraft.sounds.SoundEvent.m_262824_((ResourceLocation)((ResourceLocation)identifier.data))));
        return new SoundEventRegistryObject(identifier);
    }

    @MappedMethod
    public void registerCommand(String command, Consumer<CommandBuilder<?>> buildCommand, String ... redirects) {
        this.mainEventBus.commands.add(dispatcher -> {
            CommandBuilder<LiteralArgumentBuilder> commandBuilder = new CommandBuilder<LiteralArgumentBuilder>(Commands.m_82127_((String)command));
            buildCommand.accept(commandBuilder);
            LiteralCommandNode literalCommandNode = dispatcher.register((LiteralArgumentBuilder)commandBuilder.argumentBuilder);
            for (String redirect : redirects) {
                dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)redirect).redirect((CommandNode)literalCommandNode));
            }
        });
    }

    @MappedMethod
    public void setupPackets(Identifier identifier) {
        this.simpleChannel = ChannelBuilder.named((ResourceLocation)((ResourceLocation)identifier.data)).networkProtocolVersion(1).clientAcceptedVersions(Registry::validProtocol).serverAcceptedVersions(Registry::validProtocol).simpleChannel();
        this.simpleChannel.messageBuilder(PacketObject.class, 0).encoder((packetObject, packetBuffer) -> packetBuffer.writeBytes(packetObject.byteBuf)).decoder(packetBuffer -> new PacketObject(packetBuffer.readBytes(packetBuffer.readableBytes()))).consumerNetworkThread((packetObject, context) -> PacketBufferReceiver.receive(packetObject.byteBuf, packetBufferReceiver -> {
            Function<PacketBufferReceiver, ? extends PacketHandler> getPacketInstance = this.packets.get(packetBufferReceiver.readString());
            if (getPacketInstance != null) {
                PacketHandler packetHandler = getPacketInstance.apply((PacketBufferReceiver)packetBufferReceiver);
                if (context.getDirection().getReceptionSide().isClient()) {
                    packetHandler.runClient();
                } else {
                    ServerPlayer serverPlayerEntity = context.getSender();
                    if (serverPlayerEntity != null) {
                        packetHandler.runServer(new MinecraftServer(serverPlayerEntity.f_8924_), new ServerPlayerEntity(serverPlayerEntity));
                    }
                }
            }
        }, arg_0 -> ((CustomPayloadEvent.Context)context).enqueueWork(arg_0))).add();
    }

    @MappedMethod
    public <T extends PacketHandler> void registerPacket(Class<T> classObject, Function<PacketBufferReceiver, T> getInstance) {
        this.packets.put(classObject.getName(), getInstance);
    }

    @MappedMethod
    public <T extends PacketHandler> void sendPacketToClient(ServerPlayerEntity serverPlayerEntity, T data) {
        if (this.simpleChannel != null) {
            PacketBufferSender packetBufferSender = new PacketBufferSender(Unpooled::buffer);
            packetBufferSender.writeString(data.getClass().getName());
            data.write(packetBufferSender);
            packetBufferSender.send(byteBuf -> this.simpleChannel.send((Object)new PacketObject((ByteBuf)byteBuf), PacketDistributor.PLAYER.with((Object)((ServerPlayer)serverPlayerEntity.data))), serverPlayerEntity.getServerMapped()::execute);
        }
    }

    private static boolean validProtocol(Channel.VersionTest.Status status, int version) {
        return version == 1 || status == Channel.VersionTest.Status.VANILLA || status == Channel.VersionTest.Status.MISSING;
    }

    static class PacketObject {
        final ByteBuf byteBuf;

        PacketObject(ByteBuf byteBuf) {
            this.byteBuf = byteBuf;
        }
    }
}

