/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockRenderType;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.Blocks;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockWaterloggable;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.packet.PacketOpenBlockEntityScreen;

public class BlockEyeCandy
extends BlockWaterloggable
implements DirectionHelper,
BlockWithEntity {
    public BlockEyeCandy() {
        super(Blocks.createDefaultBlockSettings(true).nonOpaque());
    }

    @Override
    @Nonnull
    public BlockState getPlacementState2(ItemPlacementContext itemPlacementContext) {
        return super.getPlacementState2(itemPlacementContext).with(new org.mtr.mapping.holder.Property((Property)BlockEyeCandy.FACING.data), itemPlacementContext.getPlayerFacing().data);
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return VoxelShapes.empty();
    }

    @Override
    @Nonnull
    public VoxelShape getCullingShape2(BlockState state, BlockView world, BlockPos pos) {
        return VoxelShapes.empty();
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add(FACING);
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            org.mtr.mapping.holder.BlockEntity entity = world.getBlockEntity(pos);
            if (entity != null && entity.data instanceof BlockEntity) {
                ((BlockEntity)((Object)((Object)entity.data))).markDirty2();
                Init.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast(player), new PacketOpenBlockEntityScreen(pos));
            }
        });
    }

    @Override
    @Nonnull
    public BlockRenderType getRenderType2(BlockState state) {
        return BlockRenderType.getEntityblockAnimatedMapped();
    }

    @Override
    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public static class BlockEntity
    extends BlockEntityExtension {
        private String modelId = "";
        private float translateX;
        private float translateY;
        private float translateZ;
        private float rotateX;
        private float rotateY;
        private float rotateZ;
        private boolean fullBrightness;
        private static final String KEY_MODEL_ID = "prefabId";
        private static final String KEY_TRANSLATE_X = "translateX";
        private static final String KEY_TRANSLATE_Y = "translateY";
        private static final String KEY_TRANSLATE_Z = "translateZ";
        private static final String KEY_ROTATE_X = "rotateX";
        private static final String KEY_ROTATE_Y = "rotateY";
        private static final String KEY_ROTATE_Z = "rotateZ";
        private static final String KEY_FULL_BRIGHTNESS = "fullLight";

        public BlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType<?>)BlockEntityTypes.EYE_CANDY.get(), pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.modelId = compoundTag.getString(KEY_MODEL_ID);
            this.translateX = compoundTag.getFloat(KEY_TRANSLATE_X);
            this.translateY = compoundTag.getFloat(KEY_TRANSLATE_Y);
            this.translateZ = compoundTag.getFloat(KEY_TRANSLATE_Z);
            this.rotateX = compoundTag.getFloat(KEY_ROTATE_X);
            this.rotateY = compoundTag.getFloat(KEY_ROTATE_Y);
            this.rotateZ = compoundTag.getFloat(KEY_ROTATE_Z);
            this.fullBrightness = compoundTag.getBoolean(KEY_FULL_BRIGHTNESS);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putString(KEY_MODEL_ID, this.modelId);
            compoundTag.putFloat(KEY_TRANSLATE_X, this.translateX);
            compoundTag.putFloat(KEY_TRANSLATE_Y, this.translateY);
            compoundTag.putFloat(KEY_TRANSLATE_Z, this.translateZ);
            compoundTag.putFloat(KEY_ROTATE_X, this.rotateX);
            compoundTag.putFloat(KEY_ROTATE_Y, this.rotateY);
            compoundTag.putFloat(KEY_ROTATE_Z, this.rotateZ);
            compoundTag.putBoolean(KEY_FULL_BRIGHTNESS, this.fullBrightness);
        }

        public void setData(String modelId, float translateX, float translateY, float translateZ, float rotateX, float rotateY, float rotateZ, boolean fullLight) {
            this.modelId = modelId;
            this.fullBrightness = fullLight;
            this.translateX = translateX;
            this.translateY = translateY;
            this.translateZ = translateZ;
            this.rotateX = rotateX;
            this.rotateY = rotateY;
            this.rotateZ = rotateZ;
            this.markDirty2();
        }

        @Nullable
        public String getModelId() {
            return this.modelId.isEmpty() ? null : this.modelId;
        }

        public float getTranslateX() {
            return this.translateX;
        }

        public float getTranslateY() {
            return this.translateY;
        }

        public float getTranslateZ() {
            return this.translateZ;
        }

        public float getRotateX() {
            return this.rotateX;
        }

        public float getRotateY() {
            return this.rotateY;
        }

        public float getRotateZ() {
            return this.rotateZ;
        }

        public boolean getFullBrightness() {
            return this.fullBrightness;
        }
    }
}

