/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.data;

import org.mtr.core.data.Rail;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.data.RailAction;
import org.mtr.mod.data.RailActionType;
import org.mtr.mod.packet.PacketBroadcastRailActions;

public class RailActionModule {
    private final ServerWorld serverWorld;
    private final ObjectArrayList<RailAction> railActions = new ObjectArrayList();

    public RailActionModule(ServerWorld serverWorld) {
        this.serverWorld = serverWorld;
    }

    public void tick() {
        if (!this.railActions.isEmpty() && this.railActions.get(0).build()) {
            this.railActions.remove(0);
            this.broadcastUpdate();
        }
    }

    public void markRailForBridge(Rail rail, ServerPlayerEntity serverPlayerEntity, int radius, BlockState blockState) {
        this.railActions.add(new RailAction(this.serverWorld, serverPlayerEntity, RailActionType.BRIDGE, rail, radius, 0, blockState));
        this.broadcastUpdate();
    }

    public void markRailForTunnel(Rail rail, ServerPlayerEntity serverPlayerEntity, int radius, int height) {
        this.railActions.add(new RailAction(this.serverWorld, serverPlayerEntity, RailActionType.TUNNEL, rail, radius, height, null));
        this.broadcastUpdate();
    }

    public void markRailForTunnelWall(Rail rail, ServerPlayerEntity serverPlayerEntity, int radius, int height, BlockState blockState) {
        this.railActions.add(new RailAction(this.serverWorld, serverPlayerEntity, RailActionType.TUNNEL_WALL, rail, radius + 1, height + 1, blockState));
        this.broadcastUpdate();
    }

    public void removeRailAction(long id) {
        this.railActions.removeIf(railAction -> railAction.id == id);
        this.broadcastUpdate();
    }

    private void broadcastUpdate() {
        MinecraftServerHelper.iteratePlayers(this.serverWorld, serverPlayerEntity -> Init.REGISTRY.sendPacketToClient((ServerPlayerEntity)serverPlayerEntity, new PacketBroadcastRailActions(this.railActions)));
    }
}

