/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.WorldHelper;
import org.mtr.mod.block.BlockClock;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.MoreRenderLayers;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderClock
extends BlockEntityRenderer<BlockClock.BlockEntity>
implements IGui,
IBlock {
    public RenderClock(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void render(BlockClock.BlockEntity entity, float v, GraphicsHolder graphicsHolder, int i, int i1) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.getPos2();
        BlockState state = world.getBlockState(pos);
        boolean rotated = IBlock.getStatePropertySafe(state, BlockClock.FACING);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)pos.getX() + 0.5, (double)pos.getY() + 0.3125, (double)pos.getZ() + 0.5);
        if (rotated) {
            storedMatrixTransformations.add(graphicsHolderNew -> graphicsHolderNew.rotateYDegrees(90.0f));
        }
        MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/white.png"), false, QueuedRenderLayer.LIGHT, (graphicsHolderNew, offset) -> {
            storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
            long time = WorldHelper.getTimeOfDay(world) + 6000L;
            RenderClock.drawHand(graphicsHolderNew, (float)time * 360.0f / 12000.0f, true);
            RenderClock.drawHand(graphicsHolderNew, (float)time * 360.0f / 1000.0f, false);
            graphicsHolderNew.rotateYDegrees(180.0f);
            RenderClock.drawHand(graphicsHolderNew, (float)time * 360.0f / 12000.0f, true);
            RenderClock.drawHand(graphicsHolderNew, (float)time * 360.0f / 1000.0f, false);
            graphicsHolderNew.pop();
        });
    }

    private static void drawHand(GraphicsHolder graphicsHolder, float rotation, boolean isHourHand) {
        graphicsHolder.push();
        graphicsHolder.rotateZDegrees(-rotation);
        graphicsHolder.createVertexConsumer(MoreRenderLayers.getLight(new Identifier("mtr", "textures/block/white.png"), false));
        IDrawing.drawTexture(graphicsHolder, -0.01f, isHourHand ? 0.15f : 0.24f, isHourHand ? 0.1f : 0.105f, 0.01f, -0.03f, isHourHand ? 0.1f : 0.105f, Direction.UP, -5592406, 0xF000B0);
        graphicsHolder.pop();
    }
}

