/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import java.util.function.Consumer;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mod.generated.resource.ResourceWrapperSchema;
import org.mtr.mod.resource.MinecraftModelResource;
import org.mtr.mod.resource.ModelWrapper;
import org.mtr.mod.resource.VehicleResourceWrapper;

public final class ResourceWrapper
extends ResourceWrapperSchema {
    public ResourceWrapper(ObjectArrayList<VehicleResourceWrapper> vehicles, ObjectArrayList<ModelWrapper> modelResources, ObjectArrayList<String> textureResources, ObjectArrayList<MinecraftModelResource> minecraftModelResources, ObjectArrayList<String> minecraftTextureResources) {
        this.vehicles.addAll(vehicles);
        this.modelResources.addAll(modelResources);
        this.textureResources.addAll(textureResources);
        this.minecraftModelResources.addAll(minecraftModelResources);
        this.minecraftTextureResources.addAll(minecraftTextureResources);
    }

    public ResourceWrapper(JsonReader jsonReader, ObjectArrayList<MinecraftModelResource> minecraftModelResources, ObjectArrayList<String> minecraftTextureResources) {
        super(jsonReader);
        this.updateData(jsonReader);
        this.minecraftModelResources.clear();
        this.minecraftModelResources.addAll(minecraftModelResources);
        this.minecraftTextureResources.clear();
        this.minecraftTextureResources.addAll(minecraftTextureResources);
    }

    public void iterateVehicles(Consumer<VehicleResourceWrapper> consumer) {
        this.vehicles.forEach(consumer);
    }

    public void addModelResource(ModelWrapper modelResource) {
        this.modelResources.add(modelResource);
    }

    public void addTextureResource(String textureResource) {
        this.textureResources.add(textureResource);
    }

    public void updateMinecraftInfo() {
        this.isMinecraftPaused = MinecraftClient.getInstance().isPaused();
        this.exportDirectory = MinecraftClient.getInstance().getRunDirectoryMapped().getAbsolutePath().replace("\\", "/") + "/resourcepacks";
    }

    public void clean() {
        this.vehicles.forEach(VehicleResourceWrapper::clean);
    }

    public JsonObject flatten() {
        return Utilities.getJsonObjectFromData(new ResourceWrapper(this.vehicles, new ObjectArrayList<ModelWrapper>(), new ObjectArrayList<String>(), new ObjectArrayList<MinecraftModelResource>(), new ObjectArrayList<String>()));
    }
}

